/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.ImageResolver$AssetManagerImageResolver;
import com.badlogic.gdx.maps.ImageResolver$DirectImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TideMapLoader$Parameters;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer$Cell;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import com.badlogic.gdx.utils.XmlReader$Element;
import java.io.IOException;
import java.util.StringTokenizer;

public class TideMapLoader
extends SynchronousAssetLoader<TiledMap, TideMapLoader$Parameters> {
    private XmlReader xml = new XmlReader();
    private XmlReader$Element root;

    public TideMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TideMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    public TiledMap load(String string) {
        try {
            FileHandle fileHandle = this.resolve(string);
            this.root = this.xml.parse(fileHandle);
            ObjectMap<String, Texture> objectMap = new ObjectMap<String, Texture>();
            TideMapLoader tideMapLoader = this;
            for (FileHandle object2 : tideMapLoader.loadTileSheets(tideMapLoader.root, fileHandle)) {
                objectMap.put(object2.path(), new Texture(object2));
            }
            ImageResolver$DirectImageResolver imageResolver$DirectImageResolver = new ImageResolver$DirectImageResolver(objectMap);
            TideMapLoader tideMapLoader2 = this;
            TiledMap tiledMap = tideMapLoader2.loadMap(tideMapLoader2.root, fileHandle, imageResolver$DirectImageResolver);
            tiledMap.setOwnedResources(objectMap.values().toArray());
            return tiledMap;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + string + "'", iOException);
        }
    }

    @Override
    public TiledMap load(AssetManager assetManager, String string, FileHandle fileHandle, TideMapLoader$Parameters tideMapLoader$Parameters) {
        try {
            TideMapLoader tideMapLoader = this;
            return tideMapLoader.loadMap(tideMapLoader.root, fileHandle, new ImageResolver$AssetManagerImageResolver(assetManager));
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + string + "'", exception);
        }
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string, FileHandle object, TideMapLoader$Parameters object2) {
        object2 = new Array();
        try {
            this.root = this.xml.parse((FileHandle)object);
            TideMapLoader tideMapLoader = this;
            for (FileHandle fileHandle : tideMapLoader.loadTileSheets(tideMapLoader.root, (FileHandle)object)) {
                ((Array)object2).add(new AssetDescriptor<Texture>(fileHandle.path(), Texture.class));
            }
            return object2;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + string + "'", iOException);
        }
    }

    private TiledMap loadMap(XmlReader$Element xmlReader$Element22, FileHandle fileHandle, ImageResolver imageResolver) {
        TiledMap tiledMap = new TiledMap();
        Object object = xmlReader$Element22.getChildByName("Properties");
        if (object != null) {
            this.loadProperties(tiledMap.getProperties(), (XmlReader$Element)object);
        }
        object = xmlReader$Element22.getChildByName("TileSheets");
        for (XmlReader$Element object2 : ((XmlReader$Element)object).getChildrenByName("TileSheet")) {
            this.loadTileSheet(tiledMap, object2, fileHandle, imageResolver);
        }
        object = xmlReader$Element22.getChildByName("Layers");
        for (XmlReader$Element xmlReader$Element22 : ((XmlReader$Element)object).getChildrenByName("Layer")) {
            this.loadLayer(tiledMap, xmlReader$Element22);
        }
        return tiledMap;
    }

    private Array<FileHandle> loadTileSheets(XmlReader$Element object, FileHandle fileHandle) {
        Array<FileHandle> array = new Array<FileHandle>();
        object = ((XmlReader$Element)object).getChildByName("TileSheets");
        for (XmlReader$Element xmlReader$Element : ((XmlReader$Element)object).getChildrenByName("TileSheet")) {
            XmlReader$Element xmlReader$Element2 = xmlReader$Element.getChildByName("ImageSource");
            FileHandle object2 = TideMapLoader.getRelativeFileHandle(fileHandle, xmlReader$Element2.getText());
            array.add(object2);
        }
        return array;
    }

    private void loadTileSheet(TiledMap object, XmlReader$Element xmlReader$Element, FileHandle object2, ImageResolver imageResolver) {
        if (xmlReader$Element.getName().equals("TileSheet")) {
            String string = xmlReader$Element.getAttribute("Id");
            xmlReader$Element.getChildByName("Description").getText();
            Object object3 = xmlReader$Element.getChildByName("ImageSource").getText();
            String[] stringArray = xmlReader$Element.getChildByName("Alignment");
            String string2 = stringArray.getAttribute("SheetSize");
            String[] stringArray2 = stringArray.getAttribute("TileSize");
            String[] stringArray3 = stringArray.getAttribute("Margin");
            stringArray.getAttribute("Spacing");
            stringArray = string2.split(" x ");
            Integer.parseInt(stringArray[0]);
            Integer.parseInt(stringArray[1]);
            stringArray = stringArray2.split(" x ");
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            stringArray2 = stringArray3.split(" x ");
            int n4 = Integer.parseInt(stringArray2[0]);
            int n5 = Integer.parseInt(stringArray2[1]);
            stringArray3 = stringArray3.split(" x ");
            int n6 = Integer.parseInt(stringArray3[0]);
            int n7 = Integer.parseInt(stringArray3[1]);
            object2 = TideMapLoader.getRelativeFileHandle((FileHandle)object2, (String)object3);
            object2 = imageResolver.getImage(((FileHandle)object2).path());
            object = ((TiledMap)object).getTileSets();
            int n8 = 1;
            object3 = ((TiledMapTileSets)object).iterator();
            while (object3.hasNext()) {
                TiledMapTileSet tiledMapTileSet = (TiledMapTileSet)object3.next();
                n8 += tiledMapTileSet.size();
            }
            object3 = new TiledMapTileSet();
            ((TiledMapTileSet)object3).setName(string);
            ((TiledMapTileSet)object3).getProperties().put("firstgid", n8);
            int n9 = n8;
            n8 = ((TextureRegion)object2).getRegionWidth() - n2;
            int n10 = ((TextureRegion)object2).getRegionHeight() - n3;
            while (n5 <= n10) {
                for (int i2 = n4; i2 <= n8; i2 += n2 + n6) {
                    StaticTiledMapTile staticTiledMapTile = new StaticTiledMapTile(new TextureRegion((TextureRegion)object2, i2, n5, n2, n3));
                    staticTiledMapTile.setId(n9);
                    ((TiledMapTileSet)object3).putTile(n9++, staticTiledMapTile);
                }
                n5 += n3 + n7;
            }
            XmlReader$Element xmlReader$Element2 = xmlReader$Element.getChildByName("Properties");
            if (xmlReader$Element2 != null) {
                this.loadProperties(((TiledMapTileSet)object3).getProperties(), xmlReader$Element2);
            }
            ((TiledMapTileSets)object).addTileSet((TiledMapTileSet)object3);
        }
    }

    private void loadLayer(TiledMap tiledMap, XmlReader$Element xmlReader$Element) {
        if (xmlReader$Element.getName().equals("Layer")) {
            Array<XmlReader$Element> array = xmlReader$Element.getAttribute("Id");
            Object object = xmlReader$Element.getAttribute("Visible");
            String[] stringArray = xmlReader$Element.getChildByName("Dimensions");
            String[] stringArray2 = stringArray.getAttribute("LayerSize");
            stringArray = stringArray.getAttribute("TileSize");
            stringArray2 = stringArray2.split(" x ");
            int n2 = Integer.parseInt(stringArray2[0]);
            int n3 = Integer.parseInt(stringArray2[1]);
            stringArray = stringArray.split(" x ");
            int n4 = Integer.parseInt(stringArray[0]);
            int n5 = Integer.parseInt(stringArray[1]);
            TiledMapTileLayer tiledMapTileLayer = new TiledMapTileLayer(n2, n3, n4, n5);
            tiledMapTileLayer.setName((String)((Object)array));
            tiledMapTileLayer.setVisible(((String)object).equalsIgnoreCase("True"));
            array = xmlReader$Element.getChildByName("TileArray");
            array = ((XmlReader$Element)((Object)array)).getChildrenByName("Row");
            object = tiledMap.getTileSets();
            TiledMapTileSet tiledMapTileSet = null;
            n2 = 0;
            int n6 = array.size;
            for (int i2 = 0; i2 < n6; ++i2) {
                XmlReader$Element xmlReader$Element2 = array.get(i2);
                int n7 = n6 - 1 - i2;
                n4 = 0;
                int n8 = xmlReader$Element2.getChildCount();
                for (int i3 = 0; i3 < n8; ++i3) {
                    XmlReader$Element xmlReader$Element3 = xmlReader$Element2.getChild(i3);
                    Object object2 = xmlReader$Element3.getName();
                    if (((String)object2).equals("TileSheet")) {
                        tiledMapTileSet = ((TiledMapTileSets)object).getTileSet(xmlReader$Element3.getAttribute("Ref"));
                        n2 = tiledMapTileSet.getProperties().get("firstgid", Integer.class);
                        continue;
                    }
                    if (((String)object2).equals("Null")) {
                        n4 += xmlReader$Element3.getIntAttribute("Count");
                        continue;
                    }
                    if (((String)object2).equals("Static")) {
                        object2 = new TiledMapTileLayer$Cell();
                        ((TiledMapTileLayer$Cell)object2).setTile(tiledMapTileSet.getTile(n2 + xmlReader$Element3.getIntAttribute("Index")));
                        tiledMapTileLayer.setCell(n4++, n7, (TiledMapTileLayer$Cell)object2);
                        continue;
                    }
                    if (!((String)object2).equals("Animated")) continue;
                    int n9 = xmlReader$Element3.getInt("Interval");
                    xmlReader$Element3 = xmlReader$Element3.getChildByName("Frames");
                    Array<StaticTiledMapTile> array2 = new Array<StaticTiledMapTile>();
                    int n10 = xmlReader$Element3.getChildCount();
                    for (int i4 = 0; i4 < n10; ++i4) {
                        XmlReader$Element xmlReader$Element4 = xmlReader$Element3.getChild(i4);
                        String string = xmlReader$Element4.getName();
                        if (string.equals("TileSheet")) {
                            tiledMapTileSet = ((TiledMapTileSets)object).getTileSet(xmlReader$Element4.getAttribute("Ref"));
                            n2 = tiledMapTileSet.getProperties().get("firstgid", Integer.class);
                            continue;
                        }
                        if (!string.equals("Static")) continue;
                        array2.add((StaticTiledMapTile)tiledMapTileSet.getTile(n2 + xmlReader$Element4.getIntAttribute("Index")));
                    }
                    TiledMapTileLayer$Cell tiledMapTileLayer$Cell = new TiledMapTileLayer$Cell();
                    tiledMapTileLayer$Cell.setTile(new AnimatedTiledMapTile((float)n9 / 1000.0f, array2));
                    tiledMapTileLayer.setCell(n4++, n7, tiledMapTileLayer$Cell);
                }
            }
            XmlReader$Element xmlReader$Element5 = xmlReader$Element.getChildByName("Properties");
            if (xmlReader$Element5 != null) {
                this.loadProperties(tiledMapTileLayer.getProperties(), xmlReader$Element5);
            }
            tiledMap.getLayers().add(tiledMapTileLayer);
        }
    }

    private void loadProperties(MapProperties mapProperties, XmlReader$Element object) {
        if (((XmlReader$Element)object).getName().equals("Properties")) {
            for (XmlReader$Element xmlReader$Element : ((XmlReader$Element)object).getChildrenByName("Property")) {
                String string = xmlReader$Element.getAttribute("Key", null);
                String string2 = xmlReader$Element.getAttribute("Type", null);
                String object2 = xmlReader$Element.getText();
                if (string2.equals("Int32")) {
                    mapProperties.put(string, Integer.parseInt(object2));
                    continue;
                }
                if (!string2.equals("String") && string2.equals("Boolean")) {
                    mapProperties.put(string, object2.equalsIgnoreCase("true"));
                    continue;
                }
                mapProperties.put(string, object2);
            }
        }
    }

    private static FileHandle getRelativeFileHandle(FileHandle fileHandle, String object) {
        object = new StringTokenizer((String)object, "\\/");
        fileHandle = fileHandle.parent();
        while (((StringTokenizer)object).hasMoreElements()) {
            String string = ((StringTokenizer)object).nextToken();
            if (string.equals("..")) {
                fileHandle = fileHandle.parent();
                continue;
            }
            fileHandle = fileHandle.child(string);
        }
        return fileHandle;
    }
}

