/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader$TextureParameter;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.ImageResolver$AssetManagerImageResolver;
import com.badlogic.gdx.maps.ImageResolver$DirectImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TmxMapLoader$Parameters;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader$Element;

public class TmxMapLoader
extends BaseTmxMapLoader<TmxMapLoader$Parameters> {
    public TmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    public TiledMap load(String string) {
        return this.load(string, new TmxMapLoader$Parameters());
    }

    public TiledMap load(String object, TmxMapLoader$Parameters tmxMapLoader$Parameters) {
        object = this.resolve((String)object);
        this.root = this.xml.parse((FileHandle)object);
        ObjectMap<String, Texture> objectMap = new ObjectMap<String, Texture>();
        Object object2 = this.getDependencyFileHandles((FileHandle)object);
        object2 = ((Array)object2).iterator();
        while (object2.hasNext()) {
            FileHandle fileHandle = (FileHandle)object2.next();
            Texture texture = new Texture(fileHandle, tmxMapLoader$Parameters.generateMipMaps);
            texture.setFilter(tmxMapLoader$Parameters.textureMinFilter, tmxMapLoader$Parameters.textureMagFilter);
            objectMap.put(fileHandle.path(), texture);
        }
        object2 = this.loadTiledMap((FileHandle)object, tmxMapLoader$Parameters, new ImageResolver$DirectImageResolver(objectMap));
        ((TiledMap)object2).setOwnedResources(objectMap.values().toArray());
        return object2;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string, FileHandle fileHandle, TmxMapLoader$Parameters tmxMapLoader$Parameters) {
        this.map = this.loadTiledMap(fileHandle, tmxMapLoader$Parameters, new ImageResolver$AssetManagerImageResolver(assetManager));
    }

    @Override
    public TiledMap loadSync(AssetManager assetManager, String string, FileHandle fileHandle, TmxMapLoader$Parameters tmxMapLoader$Parameters) {
        return this.map;
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle object, TextureLoader$TextureParameter textureLoader$TextureParameter) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        object = this.getDependencyFileHandles((FileHandle)object);
        object = ((Array)object).iterator();
        while (object.hasNext()) {
            FileHandle fileHandle = (FileHandle)object.next();
            array.add(new AssetDescriptor<Texture>(fileHandle, Texture.class, textureLoader$TextureParameter));
        }
        return array;
    }

    protected Array<FileHandle> getDependencyFileHandles(FileHandle fileHandle) {
        Object object;
        Object object2;
        Array<FileHandle> array = new Array<FileHandle>();
        for (XmlReader$Element xmlReader$Element : this.root.getChildrenByName("tileset")) {
            Object object32;
            object2 = xmlReader$Element.getAttribute("source", null);
            if (object2 != null) {
                XmlReader$Element xmlReader$Element2 = this.xml.parse((FileHandle)(object2 = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object2)));
                object = xmlReader$Element2.getChildByName("image");
                if (object != null) {
                    String string = xmlReader$Element2.getChildByName("image").getAttribute("source");
                    object32 = TmxMapLoader.getRelativeFileHandle((FileHandle)object2, string);
                    array.add((FileHandle)object32);
                    continue;
                }
                for (Object object32 : xmlReader$Element2.getChildrenByName("tile")) {
                    object32 = ((XmlReader$Element)object32).getChildByName("image").getAttribute("source");
                    object = TmxMapLoader.getRelativeFileHandle((FileHandle)object2, (String)object32);
                    array.add((FileHandle)object);
                }
                continue;
            }
            object2 = xmlReader$Element.getChildByName("image");
            if (object2 != null) {
                object = xmlReader$Element.getChildByName("image").getAttribute("source");
                FileHandle fileHandle2 = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object);
                array.add(fileHandle2);
                continue;
            }
            for (XmlReader$Element xmlReader$Element3 : xmlReader$Element.getChildrenByName("tile")) {
                object32 = xmlReader$Element3.getChildByName("image").getAttribute("source");
                object32 = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object32);
                array.add((FileHandle)object32);
            }
        }
        for (XmlReader$Element xmlReader$Element : this.root.getChildrenByName("imagelayer")) {
            object2 = xmlReader$Element.getChildByName("image");
            if ((object2 = ((XmlReader$Element)object2).getAttribute("source", null)) == null) continue;
            object = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object2);
            array.add((FileHandle)object);
        }
        return array;
    }

    @Override
    protected void addStaticTiles(FileHandle fileHandle, ImageResolver object, TiledMapTileSet tiledMapTileSet, XmlReader$Element object2, Array<XmlReader$Element> object3, String object4, int n2, int n3, int n4, int n5, int n6, String string, int n7, int n8, String object5, int n9, int n10, FileHandle fileHandle2) {
        object2 = tiledMapTileSet.getProperties();
        if (fileHandle2 != null) {
            object3 = object.getImage(fileHandle2.path());
            ((MapProperties)object2).put("imagesource", object5);
            ((MapProperties)object2).put("imagewidth", n9);
            ((MapProperties)object2).put("imageheight", n10);
            ((MapProperties)object2).put("tilewidth", n3);
            ((MapProperties)object2).put("tileheight", n4);
            ((MapProperties)object2).put("margin", n6);
            ((MapProperties)object2).put("spacing", n5);
            int n11 = ((TextureRegion)object3).getRegionWidth() - n3;
            int n12 = ((TextureRegion)object3).getRegionHeight() - n4;
            int n13 = n2;
            for (n9 = n6; n9 <= n12; n9 += n4 + n5) {
                for (int i2 = n6; i2 <= n11; i2 += n3 + n5) {
                    object = new TextureRegion((TextureRegion)object3, i2, n9, n3, n4);
                    n2 = n13++;
                    this.addStaticTiledMapTile(tiledMapTileSet, (TextureRegion)object, n2, n7, n8);
                }
            }
            return;
        }
        object3 = ((Array)object3).iterator();
        while (object3.hasNext()) {
            object2 = (XmlReader$Element)object3.next();
            object4 = ((XmlReader$Element)object2).getChildByName("image");
            if (object4 != null) {
                object5 = ((XmlReader$Element)object4).getAttribute("source");
                fileHandle2 = string != null ? TmxMapLoader.getRelativeFileHandle(TmxMapLoader.getRelativeFileHandle(fileHandle, string), (String)object5) : TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object5);
            }
            object5 = object.getImage(fileHandle2.path());
            n9 = n2 + ((XmlReader$Element)object2).getIntAttribute("id");
            this.addStaticTiledMapTile(tiledMapTileSet, (TextureRegion)object5, n9, n7, n8);
        }
    }
}

