/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.Map;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer$Cell;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;

public class HexagonalTiledMapRenderer
extends BatchTiledMapRenderer {
    private boolean staggerAxisX = true;
    private boolean staggerIndexEven = false;
    private float hexSideLength = 0.0f;

    public HexagonalTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
        this.init(tiledMap);
    }

    public HexagonalTiledMapRenderer(TiledMap tiledMap, float f2) {
        super(tiledMap, f2);
        this.init(tiledMap);
    }

    public HexagonalTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
        this.init(tiledMap);
    }

    public HexagonalTiledMapRenderer(TiledMap tiledMap, float f2, Batch batch) {
        super(tiledMap, f2, batch);
        this.init(tiledMap);
    }

    private void init(TiledMap object) {
        Object object2 = ((Map)object).getProperties().get("staggeraxis", String.class);
        if (object2 != null) {
            this.staggerAxisX = ((String)object2).equals("x");
        }
        if ((object2 = ((Map)object).getProperties().get("staggerindex", String.class)) != null) {
            this.staggerIndexEven = ((String)object2).equals("even");
        }
        if (!this.staggerAxisX && ((Map)object).getProperties().get("height", Integer.class) % 2 == 0) {
            boolean bl = this.staggerIndexEven = !this.staggerIndexEven;
        }
        if ((object2 = ((Map)object).getProperties().get("hexsidelength", Integer.class)) != null) {
            this.hexSideLength = ((Integer)object2).intValue();
            return;
        }
        if (this.staggerAxisX) {
            object2 = ((Map)object).getProperties().get("tilewidth", Integer.class);
            if (object2 != null) {
                this.hexSideLength = 0.5f * (float)((Integer)object2).intValue();
                return;
            }
            object = (TiledMapTileLayer)((Map)object).getLayers().get(0);
            this.hexSideLength = 0.5f * (float)((TiledMapTileLayer)object).getTileWidth();
            return;
        }
        object2 = ((Map)object).getProperties().get("tileheight", Integer.class);
        if (object2 != null) {
            this.hexSideLength = 0.5f * (float)((Integer)object2).intValue();
            return;
        }
        object = (TiledMapTileLayer)((Map)object).getLayers().get(0);
        this.hexSideLength = 0.5f * (float)((TiledMapTileLayer)object).getTileHeight();
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        Color color = this.batch.getColor();
        float f2 = Color.toFloatBits(color.r, color.g, color.b, color.a * tiledMapTileLayer.getOpacity());
        int n2 = tiledMapTileLayer.getWidth();
        int n3 = tiledMapTileLayer.getHeight();
        float f3 = (float)tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f4 = (float)tiledMapTileLayer.getTileHeight() * this.unitScale;
        float f5 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale - this.viewBounds.x * (tiledMapTileLayer.getParallaxX() - 1.0f);
        float f6 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale - this.viewBounds.y * (tiledMapTileLayer.getParallaxY() - 1.0f);
        float f7 = this.hexSideLength * this.unitScale;
        if (this.staggerAxisX) {
            float f8 = (f3 - f7) / 2.0f;
            f7 = (f3 + f7) / 2.0f;
            float f9 = f4 * 0.5f;
            int n4 = Math.max(0, (int)((this.viewBounds.y - f9 - f5) / f4));
            n3 = Math.min(n3, (int)((this.viewBounds.y + this.viewBounds.height + f4 - f5) / f4));
            int n5 = Math.max(0, (int)((this.viewBounds.x - f8 - f6) / f7));
            n2 = Math.min(n2, (int)((this.viewBounds.x + this.viewBounds.width + f7 - f6) / f7));
            int n6 = this.staggerIndexEven == (n5 % 2 == 0) ? n5 + 1 : n5;
            int n7 = this.staggerIndexEven == (n5 % 2 == 0) ? n5 : n5 + 1;
            --n3;
            while (n3 >= n4) {
                int n8;
                for (n8 = n6; n8 < n2; n8 += 2) {
                    this.renderCell(tiledMapTileLayer.getCell(n8, n3), f7 * (float)n8 + f5, f9 + f4 * (float)n3 + f6, f2);
                }
                for (n8 = n7; n8 < n2; n8 += 2) {
                    this.renderCell(tiledMapTileLayer.getCell(n8, n3), f7 * (float)n8 + f5, f4 * (float)n3 + f6, f2);
                }
                --n3;
            }
            return;
        }
        float f10 = (f4 - f7) / 2.0f;
        f7 = (f4 + f7) / 2.0f;
        float f11 = f3 * 0.5f;
        int n9 = Math.max(0, (int)((this.viewBounds.y - f10 - f5) / f7));
        n3 = Math.min(n3, (int)((this.viewBounds.y + this.viewBounds.height + f7 - f5) / f7));
        int n10 = Math.max(0, (int)((this.viewBounds.x - f11 - f6) / f3));
        n2 = Math.min(n2, (int)((this.viewBounds.x + this.viewBounds.width + f3 - f6) / f3));
        for (int i2 = n3 - 1; i2 >= n9; --i2) {
            float f12 = i2 % 2 == 0 == this.staggerIndexEven ? f11 : 0.0f;
            for (n3 = n10; n3 < n2; ++n3) {
                this.renderCell(tiledMapTileLayer.getCell(n3, i2), f3 * (float)n3 + f12 + f5, f7 * (float)i2 + f6, f2);
            }
        }
    }

    private void renderCell(TiledMapTileLayer$Cell tiledMapTileLayer$Cell, float f2, float f3, float f4) {
        TiledMapTile tiledMapTile;
        if (tiledMapTileLayer$Cell != null && (tiledMapTile = tiledMapTileLayer$Cell.getTile()) != null) {
            if (tiledMapTile instanceof AnimatedTiledMapTile) {
                return;
            }
            boolean bl = tiledMapTileLayer$Cell.getFlipHorizontally();
            boolean bl2 = tiledMapTileLayer$Cell.getFlipVertically();
            int n2 = tiledMapTileLayer$Cell.getRotation();
            TextureRegion textureRegion = tiledMapTile.getTextureRegion();
            float f5 = (f2 += tiledMapTile.getOffsetX() * this.unitScale) + (float)textureRegion.getRegionWidth() * this.unitScale;
            float f6 = (f3 += tiledMapTile.getOffsetY() * this.unitScale) + (float)textureRegion.getRegionHeight() * this.unitScale;
            float f7 = textureRegion.getU();
            float f8 = textureRegion.getV2();
            float f9 = textureRegion.getU2();
            float f10 = textureRegion.getV();
            this.vertices[0] = f2;
            this.vertices[1] = f3;
            this.vertices[2] = f4;
            this.vertices[3] = f7;
            this.vertices[4] = f8;
            this.vertices[5] = f2;
            this.vertices[6] = f6;
            this.vertices[7] = f4;
            this.vertices[8] = f7;
            this.vertices[9] = f10;
            this.vertices[10] = f5;
            this.vertices[11] = f6;
            this.vertices[12] = f4;
            this.vertices[13] = f9;
            this.vertices[14] = f10;
            this.vertices[15] = f5;
            this.vertices[16] = f3;
            this.vertices[17] = f4;
            this.vertices[18] = f9;
            this.vertices[19] = f8;
            if (bl) {
                f2 = this.vertices[3];
                this.vertices[3] = this.vertices[13];
                this.vertices[13] = f2;
                f2 = this.vertices[8];
                this.vertices[8] = this.vertices[18];
                this.vertices[18] = f2;
            }
            if (bl2) {
                f2 = this.vertices[4];
                this.vertices[4] = this.vertices[14];
                this.vertices[14] = f2;
                f2 = this.vertices[9];
                this.vertices[9] = this.vertices[19];
                this.vertices[19] = f2;
            }
            if (n2 == 2) {
                f2 = this.vertices[3];
                this.vertices[3] = this.vertices[13];
                this.vertices[13] = f2;
                f2 = this.vertices[8];
                this.vertices[8] = this.vertices[18];
                this.vertices[18] = f2;
                float f11 = this.vertices[4];
                this.vertices[4] = this.vertices[14];
                this.vertices[14] = f11;
                f11 = this.vertices[9];
                this.vertices[9] = this.vertices[19];
                this.vertices[19] = f11;
            }
            this.batch.draw(textureRegion.getTexture(), this.vertices, 0, 20);
        }
    }
}

