/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer$Cell;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class IsometricTiledMapRenderer
extends BatchTiledMapRenderer {
    private Matrix4 isoTransform;
    private Matrix4 invIsotransform;
    private Vector3 screenPos = new Vector3();
    private Vector2 topRight = new Vector2();
    private Vector2 bottomLeft = new Vector2();
    private Vector2 topLeft = new Vector2();
    private Vector2 bottomRight = new Vector2();

    public IsometricTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
        this.init();
    }

    public IsometricTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
        this.init();
    }

    public IsometricTiledMapRenderer(TiledMap tiledMap, float f2) {
        super(tiledMap, f2);
        this.init();
    }

    public IsometricTiledMapRenderer(TiledMap tiledMap, float f2, Batch batch) {
        super(tiledMap, f2, batch);
        this.init();
    }

    private void init() {
        this.isoTransform = new Matrix4();
        this.isoTransform.idt();
        this.isoTransform.scale((float)(Math.sqrt(2.0) / 2.0), (float)(Math.sqrt(2.0) / 4.0), 1.0f);
        this.isoTransform.rotate(0.0f, 0.0f, 1.0f, -45.0f);
        this.invIsotransform = new Matrix4(this.isoTransform);
        this.invIsotransform.inv();
    }

    private Vector3 translateScreenToIso(Vector2 vector2) {
        this.screenPos.set(vector2.x, vector2.y, 0.0f);
        this.screenPos.mul(this.invIsotransform);
        return this.screenPos;
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        Color color = this.batch.getColor();
        float f2 = Color.toFloatBits(color.r, color.g, color.b, color.a * tiledMapTileLayer.getOpacity());
        float f3 = (float)tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f4 = (float)tiledMapTileLayer.getTileHeight() * this.unitScale;
        float f5 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale - this.viewBounds.x * (tiledMapTileLayer.getParallaxX() - 1.0f);
        float f6 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale - this.viewBounds.y * (tiledMapTileLayer.getParallaxY() - 1.0f);
        float f7 = f3 * 0.5f;
        f4 *= 0.5f;
        this.topRight.set(this.viewBounds.x + this.viewBounds.width - f5, this.viewBounds.y - f6);
        this.bottomLeft.set(this.viewBounds.x - f5, this.viewBounds.y + this.viewBounds.height - f6);
        this.topLeft.set(this.viewBounds.x - f5, this.viewBounds.y - f6);
        this.bottomRight.set(this.viewBounds.x + this.viewBounds.width - f5, this.viewBounds.y + this.viewBounds.height - f6);
        IsometricTiledMapRenderer isometricTiledMapRenderer = this;
        int n2 = (int)(isometricTiledMapRenderer.translateScreenToIso((Vector2)isometricTiledMapRenderer.topLeft).y / f3) - 2;
        IsometricTiledMapRenderer isometricTiledMapRenderer2 = this;
        int n3 = (int)(isometricTiledMapRenderer2.translateScreenToIso((Vector2)isometricTiledMapRenderer2.bottomRight).y / f3) + 2;
        IsometricTiledMapRenderer isometricTiledMapRenderer3 = this;
        int n4 = (int)(isometricTiledMapRenderer3.translateScreenToIso((Vector2)isometricTiledMapRenderer3.bottomLeft).x / f3) - 2;
        IsometricTiledMapRenderer isometricTiledMapRenderer4 = this;
        int n5 = (int)(isometricTiledMapRenderer4.translateScreenToIso((Vector2)isometricTiledMapRenderer4.topRight).x / f3) + 2;
        while (n3 >= n2) {
            for (int i2 = n4; i2 <= n5; ++i2) {
                TiledMapTile tiledMapTile;
                float f8 = (float)i2 * f7 + (float)n3 * f7;
                float f9 = (float)n3 * f4 - (float)i2 * f4;
                TiledMapTileLayer$Cell tiledMapTileLayer$Cell = tiledMapTileLayer.getCell(i2, n3);
                if (tiledMapTileLayer$Cell == null || (tiledMapTile = tiledMapTileLayer$Cell.getTile()) == null) continue;
                boolean bl = tiledMapTileLayer$Cell.getFlipHorizontally();
                boolean bl2 = tiledMapTileLayer$Cell.getFlipVertically();
                int n6 = tiledMapTileLayer$Cell.getRotation();
                TextureRegion textureRegion = tiledMapTile.getTextureRegion();
                f8 = f8 + tiledMapTile.getOffsetX() * this.unitScale + f5;
                f9 = f9 + tiledMapTile.getOffsetY() * this.unitScale + f6;
                float f10 = f8 + (float)textureRegion.getRegionWidth() * this.unitScale;
                float f11 = f9 + (float)textureRegion.getRegionHeight() * this.unitScale;
                float f12 = textureRegion.getU();
                float f13 = textureRegion.getV2();
                float f14 = textureRegion.getU2();
                float f15 = textureRegion.getV();
                this.vertices[0] = f8;
                this.vertices[1] = f9;
                this.vertices[2] = f2;
                this.vertices[3] = f12;
                this.vertices[4] = f13;
                this.vertices[5] = f8;
                this.vertices[6] = f11;
                this.vertices[7] = f2;
                this.vertices[8] = f12;
                this.vertices[9] = f15;
                this.vertices[10] = f10;
                this.vertices[11] = f11;
                this.vertices[12] = f2;
                this.vertices[13] = f14;
                this.vertices[14] = f15;
                this.vertices[15] = f10;
                this.vertices[16] = f9;
                this.vertices[17] = f2;
                this.vertices[18] = f14;
                this.vertices[19] = f13;
                if (bl) {
                    f8 = this.vertices[3];
                    this.vertices[3] = this.vertices[13];
                    this.vertices[13] = f8;
                    f8 = this.vertices[8];
                    this.vertices[8] = this.vertices[18];
                    this.vertices[18] = f8;
                }
                if (bl2) {
                    f8 = this.vertices[4];
                    this.vertices[4] = this.vertices[14];
                    this.vertices[14] = f8;
                    f8 = this.vertices[9];
                    this.vertices[9] = this.vertices[19];
                    this.vertices[19] = f8;
                }
                if (n6 != 0) {
                    switch (n6) {
                        case 1: {
                            f8 = this.vertices[4];
                            this.vertices[4] = this.vertices[9];
                            this.vertices[9] = this.vertices[14];
                            this.vertices[14] = this.vertices[19];
                            this.vertices[19] = f8;
                            f8 = this.vertices[3];
                            this.vertices[3] = this.vertices[8];
                            this.vertices[8] = this.vertices[13];
                            this.vertices[13] = this.vertices[18];
                            this.vertices[18] = f8;
                            break;
                        }
                        case 2: {
                            f8 = this.vertices[3];
                            this.vertices[3] = this.vertices[13];
                            this.vertices[13] = f8;
                            f8 = this.vertices[8];
                            this.vertices[8] = this.vertices[18];
                            this.vertices[18] = f8;
                            f8 = this.vertices[4];
                            this.vertices[4] = this.vertices[14];
                            this.vertices[14] = f8;
                            f8 = this.vertices[9];
                            this.vertices[9] = this.vertices[19];
                            this.vertices[19] = f8;
                            break;
                        }
                        case 3: {
                            f8 = this.vertices[4];
                            this.vertices[4] = this.vertices[19];
                            this.vertices[19] = this.vertices[14];
                            this.vertices[14] = this.vertices[9];
                            this.vertices[9] = f8;
                            f8 = this.vertices[3];
                            this.vertices[3] = this.vertices[18];
                            this.vertices[18] = this.vertices[13];
                            this.vertices[13] = this.vertices[8];
                            this.vertices[8] = f8;
                        }
                    }
                }
                this.batch.draw(textureRegion.getTexture(), this.vertices, 0, 20);
            }
            --n3;
        }
    }
}

