/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer$Cell;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;

public class OrthogonalTiledMapRenderer
extends BatchTiledMapRenderer {
    public OrthogonalTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, float f2) {
        super(tiledMap, f2);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, float f2, Batch batch) {
        super(tiledMap, f2, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        Color color = this.batch.getColor();
        float f2 = Color.toFloatBits(color.r, color.g, color.b, color.a * tiledMapTileLayer.getOpacity());
        int n2 = tiledMapTileLayer.getWidth();
        int n3 = tiledMapTileLayer.getHeight();
        float f3 = (float)tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f4 = (float)tiledMapTileLayer.getTileHeight() * this.unitScale;
        float f5 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale - this.viewBounds.x * (tiledMapTileLayer.getParallaxX() - 1.0f);
        float f6 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale - this.viewBounds.y * (tiledMapTileLayer.getParallaxY() - 1.0f);
        int n4 = Math.max(0, (int)((this.viewBounds.x - f5) / f3));
        n2 = Math.min(n2, (int)((this.viewBounds.x + this.viewBounds.width + f3 - f5) / f3));
        int n5 = Math.max(0, (int)((this.viewBounds.y - f6) / f4));
        n3 = Math.min(n3, (int)((this.viewBounds.y + this.viewBounds.height + f4 - f6) / f4));
        f6 = (float)n3 * f4 + f6;
        f5 = (float)n4 * f3 + f5;
        float[] fArray = this.vertices;
        while (n3 >= n5) {
            float f7 = f5;
            for (int i2 = n4; i2 < n2; ++i2) {
                TiledMapTile tiledMapTile;
                TiledMapTileLayer$Cell tiledMapTileLayer$Cell = tiledMapTileLayer.getCell(i2, n3);
                if (tiledMapTileLayer$Cell != null && (tiledMapTile = tiledMapTileLayer$Cell.getTile()) != null) {
                    boolean bl = tiledMapTileLayer$Cell.getFlipHorizontally();
                    boolean bl2 = tiledMapTileLayer$Cell.getFlipVertically();
                    int n6 = tiledMapTileLayer$Cell.getRotation();
                    TextureRegion textureRegion = tiledMapTile.getTextureRegion();
                    float f8 = f7 + tiledMapTile.getOffsetX() * this.unitScale;
                    float f9 = f6 + tiledMapTile.getOffsetY() * this.unitScale;
                    float f10 = f8 + (float)textureRegion.getRegionWidth() * this.unitScale;
                    float f11 = f9 + (float)textureRegion.getRegionHeight() * this.unitScale;
                    float f12 = textureRegion.getU();
                    float f13 = textureRegion.getV2();
                    float f14 = textureRegion.getU2();
                    float f15 = textureRegion.getV();
                    fArray[0] = f8;
                    fArray[1] = f9;
                    fArray[2] = f2;
                    fArray[3] = f12;
                    fArray[4] = f13;
                    fArray[5] = f8;
                    fArray[6] = f11;
                    fArray[7] = f2;
                    fArray[8] = f12;
                    fArray[9] = f15;
                    fArray[10] = f10;
                    fArray[11] = f11;
                    fArray[12] = f2;
                    fArray[13] = f14;
                    fArray[14] = f15;
                    fArray[15] = f10;
                    fArray[16] = f9;
                    fArray[17] = f2;
                    fArray[18] = f14;
                    fArray[19] = f13;
                    if (bl) {
                        f9 = fArray[3];
                        fArray[3] = fArray[13];
                        fArray[13] = f9;
                        f9 = fArray[8];
                        fArray[8] = fArray[18];
                        fArray[18] = f9;
                    }
                    if (bl2) {
                        f9 = fArray[4];
                        fArray[4] = fArray[14];
                        fArray[14] = f9;
                        f9 = fArray[9];
                        fArray[9] = fArray[19];
                        fArray[19] = f9;
                    }
                    if (n6 != 0) {
                        switch (n6) {
                            case 1: {
                                f9 = fArray[4];
                                fArray[4] = fArray[9];
                                fArray[9] = fArray[14];
                                fArray[14] = fArray[19];
                                fArray[19] = f9;
                                float f16 = fArray[3];
                                fArray[3] = fArray[8];
                                fArray[8] = fArray[13];
                                fArray[13] = fArray[18];
                                fArray[18] = f16;
                                break;
                            }
                            case 2: {
                                f9 = fArray[3];
                                fArray[3] = fArray[13];
                                fArray[13] = f9;
                                f9 = fArray[8];
                                fArray[8] = fArray[18];
                                fArray[18] = f9;
                                float f17 = fArray[4];
                                fArray[4] = fArray[14];
                                fArray[14] = f17;
                                f17 = fArray[9];
                                fArray[9] = fArray[19];
                                fArray[19] = f17;
                                break;
                            }
                            case 3: {
                                f9 = fArray[4];
                                fArray[4] = fArray[19];
                                fArray[19] = fArray[14];
                                fArray[14] = fArray[9];
                                fArray[9] = f9;
                                float f18 = fArray[3];
                                fArray[3] = fArray[18];
                                fArray[18] = fArray[13];
                                fArray[13] = fArray[8];
                                fArray[8] = f18;
                            }
                        }
                    }
                    this.batch.draw(textureRegion.getTexture(), fArray, 0, 20);
                }
                f7 += f3;
            }
            f6 -= f4;
            --n3;
        }
    }
}

