/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;

public class BSpline<T extends Vector<T>>
implements Path<T> {
    private static final float d6 = 0.16666667f;
    public T[] controlPoints;
    public Array<T> knots;
    public int degree;
    public boolean continuous;
    public int spanCount;
    private T tmp;
    private T tmp2;
    private T tmp3;

    public static <T extends Vector<T>> T cubic(T t2, float f2, T[] TArray, boolean bl, T t3) {
        int n2 = bl ? TArray.length : TArray.length - 3;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return (T)BSpline.cubic(t2, (int)n3, (float)(f3 -= (float)n3), TArray, (boolean)bl, t3);
    }

    public static <T extends Vector<T>> T cubic_derivative(T t2, float f2, T[] TArray, boolean bl, T t3) {
        int n2 = bl ? TArray.length : TArray.length - 3;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return (T)BSpline.cubic(t2, (int)n3, (float)(f3 -= (float)n3), TArray, (boolean)bl, t3);
    }

    public static <T extends Vector<T>> T cubic(T object, int n2, float f2, T[] TArray, boolean bl, T object2) {
        int n3 = TArray.length;
        float f3 = 1.0f - f2;
        float f4 = f2;
        float f5 = f4 * f4;
        float f6 = f5 * f2;
        object.set(TArray[n2]).scl((float)((3.0f * f6 - 6.0f * f5 + 4.0f) * 0.16666667f));
        if (bl || n2 > 0) {
            float f7 = f3;
            object.add(object2.set(TArray[(n3 + n2 - 1) % n3]).scl((float)(f7 * f7 * f3 * 0.16666667f)));
        }
        if (bl || n2 < n3 - 1) {
            object.add(object2.set(TArray[(n2 + 1) % n3]).scl((float)((-3.0f * f6 + 3.0f * f5 + 3.0f * f2 + 1.0f) * 0.16666667f)));
        }
        if (bl || n2 < n3 - 2) {
            object.add(object2.set(TArray[(n2 + 2) % n3]).scl((float)(f6 * 0.16666667f)));
        }
        return (T)object;
    }

    public static <T extends Vector<T>> T cubic_derivative(T object, int n2, float f2, T[] TArray, boolean bl, T object2) {
        int n3 = TArray.length;
        float f3 = 1.0f - f2;
        float f4 = f2;
        float f5 = f4 * f4;
        object.set(TArray[n2]).scl((float)(1.5f * f5 - f2 * 2.0f));
        if (bl || n2 > 0) {
            object.add(object2.set(TArray[(n3 + n2 - 1) % n3]).scl((float)(-0.5f * f3 * f3)));
        }
        if (bl || n2 < n3 - 1) {
            object.add(object2.set(TArray[(n2 + 1) % n3]).scl((float)(-1.5f * f5 + f2 + 0.5f)));
        }
        if (bl || n2 < n3 - 2) {
            object.add(object2.set(TArray[(n2 + 2) % n3]).scl((float)(0.5f * f5)));
        }
        return (T)object;
    }

    public static <T extends Vector<T>> T calculate(T t2, float f2, T[] TArray, int n2, boolean bl, T t3) {
        int n3 = bl ? TArray.length : TArray.length - n2;
        float f3 = f2 * (float)n3;
        int n4 = f2 >= 1.0f ? n3 - 1 : (int)f3;
        return (T)BSpline.calculate(t2, (int)n4, (float)(f3 -= (float)n4), TArray, (int)n2, (boolean)bl, t3);
    }

    public static <T extends Vector<T>> T derivative(T t2, float f2, T[] TArray, int n2, boolean bl, T t3) {
        int n3 = bl ? TArray.length : TArray.length - n2;
        float f3 = f2 * (float)n3;
        int n4 = f2 >= 1.0f ? n3 - 1 : (int)f3;
        return (T)BSpline.derivative(t2, (int)n4, (float)(f3 -= (float)n4), TArray, (int)n2, (boolean)bl, t3);
    }

    public static <T extends Vector<T>> T calculate(T t2, int n2, float f2, T[] TArray, int n3, boolean bl, T t3) {
        switch (n3) {
            case 3: {
                return (T)BSpline.cubic(t2, (int)n2, (float)f2, TArray, (boolean)bl, t3);
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends Vector<T>> T derivative(T t2, int n2, float f2, T[] TArray, int n3, boolean bl, T t3) {
        switch (n3) {
            case 3: {
                return (T)BSpline.cubic_derivative(t2, (int)n2, (float)f2, TArray, (boolean)bl, t3);
            }
        }
        throw new IllegalArgumentException();
    }

    public BSpline() {
    }

    public BSpline(T[] TArray, int n2, boolean bl) {
        this.set((Vector[])TArray, n2, bl);
    }

    public BSpline set(T[] TArray, int n2, boolean bl) {
        if (this.tmp == null) {
            this.tmp = TArray[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = TArray[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = TArray[0].cpy();
        }
        this.controlPoints = TArray;
        this.degree = n2;
        this.continuous = bl;
        int n3 = this.spanCount = bl ? TArray.length : TArray.length - n2;
        if (this.knots == null) {
            this.knots = new Array(this.spanCount);
        } else {
            this.knots.clear();
            this.knots.ensureCapacity(this.spanCount);
        }
        for (int i2 = 0; i2 < this.spanCount; ++i2) {
            this.knots.add(BSpline.calculate(TArray[0].cpy(), (int)(bl ? i2 : (int)((float)i2 + 0.5f * (float)n2)), (float)0.0f, TArray, (int)n2, (boolean)bl, this.tmp));
        }
        return this;
    }

    @Override
    public T valueAt(T t2, float f2) {
        int n2 = this.spanCount;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return this.valueAt(t2, n3, f3 -= (float)n3);
    }

    public T valueAt(T t2, int n2, float f2) {
        return (T)BSpline.calculate(t2, (int)(this.continuous ? n2 : n2 + (int)((float)this.degree * 0.5f)), (float)f2, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.tmp);
    }

    @Override
    public T derivativeAt(T t2, float f2) {
        int n2 = this.spanCount;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return this.derivativeAt(t2, n3, f3 -= (float)n3);
    }

    public T derivativeAt(T t2, int n2, float f2) {
        return (T)BSpline.derivative(t2, (int)(this.continuous ? n2 : n2 + (int)((float)this.degree * 0.5f)), (float)f2, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.tmp);
    }

    public int nearest(T t2) {
        return this.nearest(t2, 0, this.spanCount);
    }

    public int nearest(T vector, int n2, int n3) {
        while (n2 < 0) {
            n2 += this.spanCount;
        }
        int n4 = n2 % this.spanCount;
        float f2 = vector.dst2((Vector)((Vector)this.knots.get(n4)));
        for (int i2 = 1; i2 < n3; ++i2) {
            float f3;
            int n5 = (n2 + i2) % this.spanCount;
            float f4 = vector.dst2((Vector)((Vector)this.knots.get(n5)));
            if (!(f3 < f2)) continue;
            f2 = f4;
            n4 = n5;
        }
        return n4;
    }

    @Override
    public float approximate(T t2) {
        return this.approximate(t2, this.nearest(t2));
    }

    public float approximate(T t2, int n2, int n3) {
        return this.approximate(t2, this.nearest(t2, n2, n3));
    }

    public float approximate(T vector, int n2) {
        float f2;
        int n3 = n2;
        Vector vector2 = (Vector)this.knots.get(n2);
        Vector vector3 = (Vector)this.knots.get(n2 > 0 ? n2 - 1 : this.spanCount - 1);
        Vector vector4 = (Vector)this.knots.get((n2 + 1) % this.spanCount);
        float f3 = vector.dst2((Vector)vector3);
        float f4 = vector.dst2((Vector)vector4);
        if (f2 < f3) {
            vector3 = vector2;
            vector2 = vector4;
        } else {
            n3 = n2 > 0 ? n2 - 1 : this.spanCount - 1;
        }
        float f5 = vector3.dst2(vector2);
        float f6 = vector.dst2((Vector)vector2);
        float f7 = vector.dst2((Vector)vector3);
        float f8 = (float)Math.sqrt(f5);
        f7 = (f6 + f5 - f7) / (f8 * 2.0f);
        f7 = MathUtils.clamp((f8 - f7) / f8, 0.0f, 1.0f);
        return ((float)n3 + f7) / (float)this.spanCount;
    }

    @Override
    public float locate(T t2) {
        return this.approximate(t2);
    }

    @Override
    public float approxLength(int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tmp2.set(this.tmp3);
            BSpline bSpline = this;
            bSpline.valueAt(bSpline.tmp3, (float)i2 / ((float)n2 - 1.0f));
            if (i2 <= 0) continue;
            f2 += this.tmp2.dst(this.tmp3);
        }
        return f2;
    }
}

