/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Circle
implements Shape2D,
Serializable {
    public float x;
    public float y;
    public float radius;

    public Circle() {
    }

    public Circle(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.radius = f4;
    }

    public Circle(Vector2 vector2, float f2) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = f2;
    }

    public Circle(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public Circle(Vector2 vector2, Vector2 vector22) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = Vector2.len(vector2.x - vector22.x, vector2.y - vector22.y);
    }

    public void set(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.radius = f4;
    }

    public void set(Vector2 vector2, float f2) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = f2;
    }

    public void set(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public void set(Vector2 vector2, Vector2 vector22) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = Vector2.len(vector2.x - vector22.x, vector2.y - vector22.y);
    }

    public void setPosition(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
    }

    public void setPosition(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public void setX(float f2) {
        this.x = f2;
    }

    public void setY(float f2) {
        this.y = f2;
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    @Override
    public boolean contains(float f2, float f3) {
        f2 = this.x - f2;
        f3 = this.y - f3;
        float f4 = f2;
        float f5 = f3;
        return f4 * f4 + f5 * f5 <= this.radius * this.radius;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        float f2 = this.x - vector2.x;
        float f3 = this.y - vector2.y;
        float f4 = f2;
        float f5 = f3;
        return f4 * f4 + f5 * f5 <= this.radius * this.radius;
    }

    public boolean contains(Circle circle) {
        float f2;
        float f3 = this.radius - circle.radius;
        if (f2 < 0.0f) {
            return false;
        }
        float f4 = this.x - circle.x;
        float f5 = this.y - circle.y;
        float f6 = f4;
        float f7 = f5;
        f4 = f6 * f6 + f7 * f7;
        float f8 = this.radius + circle.radius;
        float f9 = f3;
        if (!(f9 * f9 < f4)) {
            float f10 = f8;
            if (f4 < f10 * f10) {
                return true;
            }
        }
        return false;
    }

    public boolean overlaps(Circle circle) {
        float f2;
        float f3 = this.x - circle.x;
        float f4 = this.y - circle.y;
        float f5 = f3;
        float f6 = f4;
        f3 = f5 * f5 + f6 * f6;
        float f7 = f2 = this.radius + circle.radius;
        return f3 < f7 * f7;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.radius;
    }

    public float circumference() {
        return this.radius * ((float)Math.PI * 2);
    }

    public float area() {
        return this.radius * this.radius * (float)Math.PI;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Circle)object;
        return this.x == ((Circle)object).x && this.y == ((Circle)object).y && this.radius == ((Circle)object).radius;
    }

    public int hashCode() {
        int n2 = 41 + NumberUtils.floatToRawIntBits(this.radius);
        n2 = n2 * 41 + NumberUtils.floatToRawIntBits(this.x);
        n2 = n2 * 41 + NumberUtils.floatToRawIntBits(this.y);
        return n2;
    }
}

