/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.CumulativeDistribution$CumulativeValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;

public class CumulativeDistribution<T> {
    private Array<CumulativeDistribution$CumulativeValue> values = new Array(false, 10, CumulativeDistribution$CumulativeValue.class);

    public void add(T t2, float f2) {
        this.values.add(new CumulativeDistribution$CumulativeValue(this, t2, 0.0f, f2));
    }

    public void add(T t2) {
        this.values.add(new CumulativeDistribution$CumulativeValue(this, t2, 0.0f, 0.0f));
    }

    public void generate() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.values.size; ++i2) {
            ((CumulativeDistribution$CumulativeValue[])this.values.items)[i2].frequency = f2 += ((CumulativeDistribution$CumulativeValue[])this.values.items)[i2].interval;
        }
    }

    public void generateNormalized() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.values.size; ++i2) {
            f2 += ((CumulativeDistribution$CumulativeValue[])this.values.items)[i2].interval;
        }
        float f3 = 0.0f;
        for (int i3 = 0; i3 < this.values.size; ++i3) {
            ((CumulativeDistribution$CumulativeValue[])this.values.items)[i3].frequency = f3 += ((CumulativeDistribution$CumulativeValue[])this.values.items)[i3].interval / f2;
        }
    }

    public void generateUniform() {
        float f2 = 1.0f / (float)this.values.size;
        for (int i2 = 0; i2 < this.values.size; ++i2) {
            ((CumulativeDistribution$CumulativeValue[])this.values.items)[i2].interval = f2;
            ((CumulativeDistribution$CumulativeValue[])this.values.items)[i2].frequency = (float)(i2 + 1) * f2;
        }
    }

    public T value(float f2) {
        int n2 = this.values.size - 1;
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = n3 + (n2 - n3) / 2;
            CumulativeDistribution$CumulativeValue cumulativeDistribution$CumulativeValue = ((CumulativeDistribution$CumulativeValue[])this.values.items)[n4];
            if (f2 < cumulativeDistribution$CumulativeValue.frequency) {
                n2 = n4 - 1;
                continue;
            }
            if (!(f2 > cumulativeDistribution$CumulativeValue.frequency)) break;
            n3 = n4 + 1;
        }
        return ((CumulativeDistribution$CumulativeValue[])this.values.items)[n3].value;
    }

    public T value() {
        return this.value(MathUtils.random());
    }

    public int size() {
        return this.values.size;
    }

    public float getInterval(int n2) {
        return ((CumulativeDistribution$CumulativeValue[])this.values.items)[n2].interval;
    }

    public T getValue(int n2) {
        return ((CumulativeDistribution$CumulativeValue[])this.values.items)[n2].value;
    }

    public void setInterval(T t2, float f2) {
        for (CumulativeDistribution$CumulativeValue cumulativeDistribution$CumulativeValue : this.values) {
            if (cumulativeDistribution$CumulativeValue.value != t2) continue;
            cumulativeDistribution$CumulativeValue.interval = f2;
            return;
        }
    }

    public void setInterval(int n2, float f2) {
        ((CumulativeDistribution$CumulativeValue[])this.values.items)[n2].interval = f2;
    }

    public void clear() {
        this.values.clear();
    }
}

