/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.BooleanArray;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;

public class DelaunayTriangulator {
    private static final float EPSILON = 1.0E-6f;
    private static final int INSIDE = 0;
    private static final int COMPLETE = 1;
    private static final int INCOMPLETE = 2;
    private final IntArray quicksortStack = new IntArray();
    private float[] sortedPoints;
    private final ShortArray triangles = new ShortArray(false, 16);
    private final ShortArray originalIndices = new ShortArray(false, 0);
    private final IntArray edges = new IntArray();
    private final BooleanArray complete = new BooleanArray(false, 16);
    private final float[] superTriangle = new float[6];
    private final Vector2 centroid = new Vector2();

    public ShortArray computeTriangles(FloatArray floatArray, boolean bl) {
        return this.computeTriangles(floatArray.items, 0, floatArray.size, bl);
    }

    public ShortArray computeTriangles(float[] fArray, boolean bl) {
        return this.computeTriangles(fArray, 0, fArray.length, bl);
    }

    public ShortArray computeTriangles(float[] fArray, int n2, int n3, boolean bl) {
        float f2;
        if (n3 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("count must be <= 32767");
        }
        ShortArray shortArray = this.triangles;
        shortArray.clear();
        if (n3 < 6) {
            return shortArray;
        }
        shortArray.ensureCapacity(n3);
        if (!bl) {
            if (this.sortedPoints == null || this.sortedPoints.length < n3) {
                this.sortedPoints = new float[n3];
            }
            System.arraycopy(fArray, n2, this.sortedPoints, 0, n3);
            fArray = this.sortedPoints;
            n2 = 0;
            this.sort(fArray, n3);
        }
        int n4 = n2 + n3;
        float f3 = fArray[0];
        float f4 = fArray[1];
        float f5 = f3;
        float f6 = f4;
        for (int i2 = n2 + 2; i2 < n4; ++i2) {
            float f7;
            float f8;
            f2 = fArray[i2];
            if (f8 < f3) {
                f3 = f2;
            }
            if (f2 > f5) {
                f5 = f2;
            }
            f2 = fArray[++i2];
            if (f7 < f4) {
                f4 = f2;
            }
            if (!(f2 > f6)) continue;
            f6 = f2;
        }
        float f9 = f5 - f3;
        f2 = f6 - f4;
        f9 = (f9 > f2 ? f9 : f2) * 20.0f;
        f3 = (f5 + f3) / 2.0f;
        f4 = (f6 + f4) / 2.0f;
        float[] fArray2 = this.superTriangle;
        this.superTriangle[0] = f3 - f9;
        fArray2[1] = f4 - f9;
        fArray2[2] = f3;
        fArray2[3] = f4 + f9;
        fArray2[4] = f3 + f9;
        fArray2[5] = f4 - f9;
        IntArray intArray = this.edges;
        intArray.ensureCapacity(n3 / 2);
        BooleanArray booleanArray = this.complete;
        booleanArray.clear();
        booleanArray.ensureCapacity(n3);
        shortArray.add(n4);
        shortArray.add(n4 + 2);
        shortArray.add(n4 + 4);
        booleanArray.add(false);
        for (n3 = n2; n3 < n4; n3 += 2) {
            int n5;
            int n6;
            int n7;
            int n8;
            f6 = fArray[n3];
            f9 = fArray[n3 + 1];
            short[] sArray = shortArray.items;
            boolean[] blArray = booleanArray.items;
            block6: for (int i3 = shortArray.size - 1; i3 >= 0; i3 -= 3) {
                float f10;
                float f11;
                float f12;
                float f13;
                float f14;
                float f15;
                int n9;
                n8 = i3 / 3;
                if (blArray[n8]) continue;
                n7 = sArray[i3 - 2];
                n6 = sArray[i3 - 1];
                n5 = sArray[i3];
                if (n7 >= n4) {
                    n9 = n7 - n4;
                    f15 = fArray2[n9];
                    f14 = fArray2[n9 + 1];
                } else {
                    f15 = fArray[n7];
                    f14 = fArray[n7 + 1];
                }
                if (n6 >= n4) {
                    n9 = n6 - n4;
                    f13 = fArray2[n9];
                    f12 = fArray2[n9 + 1];
                } else {
                    f13 = fArray[n6];
                    f12 = fArray[n6 + 1];
                }
                if (n5 >= n4) {
                    n9 = n5 - n4;
                    f11 = fArray2[n9];
                    f10 = fArray2[n9 + 1];
                } else {
                    f11 = fArray[n5];
                    f10 = fArray[n5 + 1];
                }
                switch (this.circumCircle(f6, f9, f15, f14, f13, f12, f11, f10)) {
                    case 1: {
                        blArray[n8] = true;
                        continue block6;
                    }
                    case 0: {
                        int n10 = n6;
                        intArray.add(n7, n10, n10, n5);
                        intArray.add(n5, n7);
                        shortArray.removeRange(i3 - 2, i3);
                        booleanArray.removeIndex(n8);
                    }
                }
            }
            int[] nArray = intArray.items;
            n7 = intArray.size;
            for (n8 = 0; n8 < n7; n8 += 2) {
                n6 = nArray[n8];
                if (n6 == -1) continue;
                n5 = nArray[n8 + 1];
                boolean bl2 = false;
                for (int i4 = n8 + 2; i4 < n7; i4 += 2) {
                    if (n6 != nArray[i4 + 1] || n5 != nArray[i4]) continue;
                    bl2 = true;
                    nArray[i4] = -1;
                }
                if (bl2) continue;
                shortArray.add(n6);
                shortArray.add(nArray[n8 + 1]);
                shortArray.add(n3);
                booleanArray.add(false);
            }
            intArray.clear();
        }
        short[] sArray = shortArray.items;
        for (int i5 = shortArray.size - 1; i5 >= 0; i5 -= 3) {
            if (sArray[i5] < n4 && sArray[i5 - 1] < n4 && sArray[i5 - 2] < n4) continue;
            shortArray.removeIndex(i5);
            shortArray.removeIndex(i5 - 1);
            shortArray.removeIndex(i5 - 2);
        }
        if (!bl) {
            short[] sArray2 = this.originalIndices.items;
            int n11 = shortArray.size;
            for (int i6 = 0; i6 < n11; ++i6) {
                sArray[i6] = (short)(sArray2[sArray[i6] / 2] << 1);
            }
        }
        if (n2 == 0) {
            int n12 = shortArray.size;
            for (int i7 = 0; i7 < n12; ++i7) {
                sArray[i7] = (short)(sArray[i7] / 2);
            }
        } else {
            int n13 = shortArray.size;
            for (int i8 = 0; i8 < n13; ++i8) {
                sArray[i8] = (short)((sArray[i8] - n2) / 2);
            }
        }
        return shortArray;
    }

    private int circumCircle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11;
        float f12 = Math.abs(f5 - f7);
        float f13 = Math.abs(f7 - f9);
        if (f12 < 1.0E-6f) {
            if (f13 < 1.0E-6f) {
                return 2;
            }
            f12 = -(f8 - f6) / (f9 - f7);
            f11 = (f6 + f8) / 2.0f;
            f10 = (f7 + f9) / 2.0f;
            f4 = (f6 + f4) / 2.0f;
            f5 = f12 * (f4 - f11) + f10;
        } else {
            f12 = -(f6 - f4) / (f7 - f5);
            f11 = (f4 + f6) / 2.0f;
            f10 = (f5 + f7) / 2.0f;
            if (f13 < 1.0E-6f) {
                f4 = (f8 + f6) / 2.0f;
                f5 = f12 * (f4 - f11) + f10;
            } else {
                f4 = -(f8 - f6) / (f9 - f7);
                f5 = (f6 + f8) / 2.0f;
                f8 = (f7 + f9) / 2.0f;
                f4 = (f12 * f11 - f4 * f5 + f8 - f10) / (f12 - f4);
                f5 = f12 * (f4 - f11) + f10;
            }
        }
        f12 = f6 - f4;
        f11 = f7 - f5;
        float f14 = f12;
        float f15 = f11;
        f10 = f14 * f14 + f15 * f15;
        f12 = f2 - f4;
        f12 *= f12;
        float f16 = f11 = f3 - f5;
        if (f12 + f16 * f16 - f10 <= 1.0E-6f) {
            return 0;
        }
        if (f2 > f4 && f12 > f10) {
            return 1;
        }
        return 2;
    }

    private void sort(float[] fArray, int n2) {
        int n3;
        int n4 = n2 / 2;
        this.originalIndices.clear();
        this.originalIndices.ensureCapacity(n4);
        short[] sArray = this.originalIndices.items;
        for (n3 = 0; n3 < n4; n3 = (int)((short)(n3 + 1))) {
            int n5 = n3;
            sArray[n5] = n5;
        }
        IntArray intArray = this.quicksortStack;
        intArray.add(0);
        intArray.add(--n2 - 1);
        while (intArray.size > 0) {
            n2 = intArray.pop();
            if (n2 <= (n3 = intArray.pop())) continue;
            int n6 = this.quicksortPartition(fArray, n3, n2, sArray);
            if (n6 - n3 > n2 - n6) {
                intArray.add(n3);
                intArray.add(n6 - 2);
            }
            intArray.add(n6 + 2);
            intArray.add(n2);
            if (n2 - n6 < n6 - n3) continue;
            intArray.add(n3);
            intArray.add(n6 - 2);
        }
    }

    private int quicksortPartition(float[] fArray, int n2, int n3, short[] sArray) {
        float f2 = fArray[n2];
        int n4 = n2 + 2;
        while (n4 < n3) {
            while (n4 < n3 && fArray[n4] <= f2) {
                n4 += 2;
            }
            while (fArray[n3] > f2) {
                n3 -= 2;
            }
            if (n4 >= n3) continue;
            float f3 = fArray[n4];
            fArray[n4] = fArray[n3];
            fArray[n3] = f3;
            f3 = fArray[n4 + 1];
            fArray[n4 + 1] = fArray[n3 + 1];
            fArray[n3 + 1] = f3;
            short s2 = sArray[n4 / 2];
            sArray[n4 / 2] = sArray[n3 / 2];
            sArray[n3 / 2] = s2;
        }
        if (f2 > fArray[n3]) {
            fArray[n2] = fArray[n3];
            fArray[n3] = f2;
            float f4 = fArray[n2 + 1];
            fArray[n2 + 1] = fArray[n3 + 1];
            fArray[n3 + 1] = f4;
            short s3 = sArray[n2 / 2];
            sArray[n2 / 2] = sArray[n3 / 2];
            sArray[n3 / 2] = s3;
        }
        return n3;
    }

    public void trim(ShortArray shortArray, float[] fArray, float[] fArray2, int n2, int n3) {
        short[] sArray = shortArray.items;
        for (int i2 = shortArray.size - 1; i2 >= 0; i2 -= 3) {
            int n4 = sArray[i2 - 2] << 1;
            int n5 = sArray[i2 - 1] << 1;
            int n6 = sArray[i2] << 1;
            GeometryUtils.triangleCentroid(fArray[n4], fArray[n4 + 1], fArray[n5], fArray[n5 + 1], fArray[n6], fArray[n6 + 1], this.centroid);
            if (Intersector.isPointInPolygon(fArray2, n2, n3, this.centroid.x, this.centroid.y)) continue;
            shortArray.removeIndex(i2);
            shortArray.removeIndex(i2 - 1);
            shortArray.removeIndex(i2 - 2);
        }
    }
}

