/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.math.Octree$1;
import com.badlogic.gdx.math.Octree$Collider;
import com.badlogic.gdx.math.Octree$OctreeNode;
import com.badlogic.gdx.math.Octree$RayCastResult;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.Pool;

public class Octree<T> {
    final int maxItemsPerNode;
    final Pool<Octree$OctreeNode> nodePool = new Octree$1(this);
    protected Octree$OctreeNode root;
    final Octree$Collider<T> collider;
    static final Vector3 tmp = new Vector3();

    public Octree(Vector3 vector3, Vector3 vector32, int n2, int n3, Octree$Collider<T> octree$Collider) {
        Vector3 vector33 = new Vector3(Math.min(vector3.x, vector32.x), Math.min(vector3.y, vector32.y), Math.min(vector3.z, vector32.z));
        vector3 = new Vector3(Math.max(vector3.x, vector32.x), Math.max(vector3.y, vector32.y), Math.max(vector3.z, vector32.z));
        this.root = this.createNode(vector33, vector3, n2);
        this.collider = octree$Collider;
        this.maxItemsPerNode = n3;
    }

    Octree$OctreeNode createNode(Vector3 vector3, Vector3 vector32, int n2) {
        Octree$OctreeNode octree$OctreeNode = this.nodePool.obtain();
        octree$OctreeNode.bounds.set(vector3, vector32);
        octree$OctreeNode.level = n2;
        octree$OctreeNode.leaf = true;
        return octree$OctreeNode;
    }

    public void add(T t2) {
        this.root.add(t2);
    }

    public void remove(T t2) {
        this.root.remove(t2);
    }

    public void update(T t2) {
        this.root.remove(t2);
        this.root.add(t2);
    }

    public ObjectSet<T> getAll(ObjectSet<T> objectSet) {
        this.root.getAll(objectSet);
        return objectSet;
    }

    public ObjectSet<T> query(BoundingBox boundingBox, ObjectSet<T> objectSet) {
        this.root.query(boundingBox, objectSet);
        return objectSet;
    }

    public ObjectSet<T> query(Frustum frustum, ObjectSet<T> objectSet) {
        this.root.query(frustum, objectSet);
        return objectSet;
    }

    public T rayCast(Ray ray, Octree$RayCastResult<T> octree$RayCastResult) {
        octree$RayCastResult.distance = octree$RayCastResult.maxDistanceSq;
        this.root.rayCast(ray, octree$RayCastResult);
        return octree$RayCastResult.geometry;
    }

    public ObjectSet<BoundingBox> getNodesBoxes(ObjectSet<BoundingBox> objectSet) {
        this.root.getBoundingBox(objectSet);
        return objectSet;
    }
}

