/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Vector4
implements Vector<Vector4>,
Serializable {
    private static final long serialVersionUID = -5394070284130414492L;
    public float x;
    public float y;
    public float z;
    public float w;
    public static final Vector4 X = new Vector4(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4 Y = new Vector4(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4 Z = new Vector4(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4 W = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4 Zero = new Vector4(0.0f, 0.0f, 0.0f, 0.0f);

    public Vector4() {
    }

    public Vector4(float f2, float f3, float f4, float f5) {
        this.set(f2, f3, f4, f5);
    }

    public Vector4(Vector4 vector4) {
        this.set(vector4.x, vector4.y, vector4.z, vector4.w);
    }

    public Vector4(float[] fArray) {
        this.set(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public Vector4(Vector2 vector2, float f2, float f3) {
        this.set(vector2.x, vector2.y, f2, f3);
    }

    public Vector4(Vector3 vector3, float f2) {
        this.set(vector3.x, vector3.y, vector3.z, f2);
    }

    public Vector4 set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
        return this;
    }

    @Override
    public Vector4 set(Vector4 vector4) {
        return this.set(vector4.x, vector4.y, vector4.z, vector4.w);
    }

    @Override
    public Vector4 set(float[] fArray) {
        return this.set(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public Vector4 set(Vector2 vector2, float f2, float f3) {
        return this.set(vector2.x, vector2.y, f2, f3);
    }

    public Vector4 set(Vector3 vector3, float f2) {
        return this.set(vector3.x, vector3.y, vector3.z, f2);
    }

    @Override
    public Vector4 setToRandomDirection() {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        do {
            f5 = (MathUtils.random() - 0.5f) * 2.0f;
            f4 = (MathUtils.random() - 0.5f) * 2.0f;
            f7 = f5;
            f6 = f4;
        } while ((f8 = f7 * f7 + f6 * f6) >= 1.0f || f8 == 0.0f);
        f8 = (float)Math.sqrt(-2.0 * Math.log(f8) / (double)f8);
        this.x = f5 * f8;
        this.y = f4 * f8;
        do {
            f5 = (MathUtils.random() - 0.5f) * 2.0f;
            f4 = (MathUtils.random() - 0.5f) * 2.0f;
            f3 = f5;
            f2 = f4;
        } while ((f8 = f3 * f3 + f2 * f2) >= 1.0f || f8 == 0.0f);
        f8 = (float)Math.sqrt(-2.0 * Math.log(f8) / (double)f8);
        this.z = f5 * f8;
        this.w = f4 * f8;
        return this.nor();
    }

    @Override
    public Vector4 cpy() {
        return new Vector4(this);
    }

    @Override
    public Vector4 add(Vector4 vector4) {
        return this.add(vector4.x, vector4.y, vector4.z, vector4.w);
    }

    public Vector4 add(float f2, float f3, float f4, float f5) {
        Vector4 vector4 = this;
        return vector4.set(vector4.x + f2, this.y + f3, this.z + f4, this.w + f5);
    }

    @Override
    public Vector4 add(float f2) {
        Vector4 vector4 = this;
        return vector4.set(vector4.x + f2, this.y + f2, this.z + f2, this.w + f2);
    }

    @Override
    public Vector4 sub(Vector4 vector4) {
        return this.sub(vector4.x, vector4.y, vector4.z, vector4.w);
    }

    public Vector4 sub(float f2, float f3, float f4, float f5) {
        Vector4 vector4 = this;
        return vector4.set(vector4.x - f2, this.y - f3, this.z - f4, this.w - f5);
    }

    @Override
    public Vector4 sub(float f2) {
        Vector4 vector4 = this;
        return vector4.set(vector4.x - f2, this.y - f2, this.z - f2, this.w - f2);
    }

    @Override
    public Vector4 scl(float f2) {
        Vector4 vector4 = this;
        return vector4.set(vector4.x * f2, this.y * f2, this.z * f2, this.w * f2);
    }

    @Override
    public Vector4 scl(Vector4 vector4) {
        Vector4 vector42 = this;
        return vector42.set(vector42.x * vector4.x, this.y * vector4.y, this.z * vector4.z, this.w * vector4.w);
    }

    public Vector4 scl(float f2, float f3, float f4, float f5) {
        Vector4 vector4 = this;
        return vector4.set(vector4.x * f2, this.y * f3, this.z * f4, this.w * f5);
    }

    @Override
    public Vector4 mulAdd(Vector4 vector4, float f2) {
        this.x += vector4.x * f2;
        this.y += vector4.y * f2;
        this.z += vector4.z * f2;
        this.w += vector4.w * f2;
        return this;
    }

    @Override
    public Vector4 mulAdd(Vector4 vector4, Vector4 vector42) {
        this.x += vector4.x * vector42.x;
        this.y += vector4.y * vector42.y;
        this.z += vector4.z * vector42.z;
        this.w += vector4.w * vector42.w;
        return this;
    }

    public static float len(float f2, float f3, float f4, float f5) {
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8 + f9 * f9);
    }

    @Override
    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public static float len2(float f2, float f3, float f4, float f5) {
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return f6 * f6 + f7 * f7 + f8 * f8 + f9 * f9;
    }

    @Override
    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public boolean idt(Vector4 vector4) {
        return this.x == vector4.x && this.y == vector4.y && this.z == vector4.z && this.w == vector4.w;
    }

    public static float dst(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        f2 = f6 - f2;
        f3 = f7 - f3;
        f4 = f8 - f4;
        f5 = f9 - f5;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        float f13 = f5;
        return (float)Math.sqrt(f10 * f10 + f11 * f11 + f12 * f12 + f13 * f13);
    }

    @Override
    public float dst(Vector4 vector4) {
        float f2 = vector4.x - this.x;
        float f3 = vector4.y - this.y;
        float f4 = vector4.z - this.z;
        float f5 = vector4.w - this.w;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8 + f9 * f9);
    }

    public float dst(float f2, float f3, float f4, float f5) {
        float f6 = f2 -= this.x;
        float f7 = f3 -= this.y;
        float f8 = f4 -= this.z;
        float f9 = f5 -= this.w;
        return (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8 + f9 * f9);
    }

    public static float dst2(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        f2 = f6 - f2;
        f3 = f7 - f3;
        f4 = f8 - f4;
        f5 = f9 - f5;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        float f13 = f5;
        return f10 * f10 + f11 * f11 + f12 * f12 + f13 * f13;
    }

    @Override
    public float dst2(Vector4 vector4) {
        float f2 = vector4.x - this.x;
        float f3 = vector4.y - this.y;
        float f4 = vector4.z - this.z;
        float f5 = vector4.w - this.w;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return f6 * f6 + f7 * f7 + f8 * f8 + f9 * f9;
    }

    public float dst2(float f2, float f3, float f4, float f5) {
        float f6 = f2 -= this.x;
        float f7 = f3 -= this.y;
        float f8 = f4 -= this.z;
        float f9 = f5 -= this.w;
        return f6 * f6 + f7 * f7 + f8 * f8 + f9 * f9;
    }

    @Override
    public Vector4 nor() {
        float f2 = this.len2();
        if (f2 == 0.0f || f2 == 1.0f) {
            return this;
        }
        return this.scl(1.0f / (float)Math.sqrt(f2));
    }

    public static float dot(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return f2 * f6 + f3 * f7 + f4 * f8 + f5 * f9;
    }

    @Override
    public float dot(Vector4 vector4) {
        return this.x * vector4.x + this.y * vector4.y + this.z * vector4.z + this.w * vector4.w;
    }

    public float dot(float f2, float f3, float f4, float f5) {
        return this.x * f2 + this.y * f3 + this.z * f4 + this.w * f5;
    }

    @Override
    public boolean isUnit() {
        return this.isUnit(1.0E-9f);
    }

    @Override
    public boolean isUnit(float f2) {
        return Math.abs(this.len2() - 1.0f) < f2;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f && this.w == 0.0f;
    }

    @Override
    public boolean isZero(float f2) {
        return this.len2() < f2;
    }

    @Override
    public boolean isOnLine(Vector4 vector4, float f2) {
        int n2 = 0;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (MathUtils.isZero(this.x, f2)) {
            if (!MathUtils.isZero(vector4.x, f2)) {
                return false;
            }
        } else {
            f3 = this.x / vector4.x;
            n2 = 1;
        }
        if (MathUtils.isZero(this.y, f2)) {
            if (!MathUtils.isZero(vector4.y, f2)) {
                return false;
            }
        } else {
            f4 = this.y / vector4.y;
            n2 |= 2;
        }
        if (MathUtils.isZero(this.z, f2)) {
            if (!MathUtils.isZero(vector4.z, f2)) {
                return false;
            }
        } else {
            f5 = this.z / vector4.z;
            n2 |= 4;
        }
        if (MathUtils.isZero(this.w, f2)) {
            if (!MathUtils.isZero(vector4.w, f2)) {
                return false;
            }
        } else {
            f6 = this.w / vector4.w;
            n2 |= 8;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 3: {
                return MathUtils.isEqual(f3, f4, f2);
            }
            case 5: {
                return MathUtils.isEqual(f3, f5, f2);
            }
            case 9: {
                return MathUtils.isEqual(f3, f6, f2);
            }
            case 6: {
                return MathUtils.isEqual(f4, f5, f2);
            }
            case 10: {
                return MathUtils.isEqual(f4, f6, f2);
            }
            case 12: {
                return MathUtils.isEqual(f5, f6, f2);
            }
            case 7: {
                return MathUtils.isEqual(f3, f4, f2) && MathUtils.isEqual(f3, f5, f2);
            }
            case 11: {
                return MathUtils.isEqual(f3, f4, f2) && MathUtils.isEqual(f3, f6, f2);
            }
            case 13: {
                return MathUtils.isEqual(f3, f5, f2) && MathUtils.isEqual(f3, f6, f2);
            }
            case 14: {
                return MathUtils.isEqual(f4, f5, f2) && MathUtils.isEqual(f4, f6, f2);
            }
        }
        return MathUtils.isEqual(f3, f4, f2) && MathUtils.isEqual(f3, f5, f2) && MathUtils.isEqual(f3, f6, f2);
    }

    @Override
    public boolean isOnLine(Vector4 vector4) {
        return this.isOnLine(vector4, 1.0E-6f);
    }

    @Override
    public boolean isCollinear(Vector4 vector4, float f2) {
        return this.isOnLine(vector4, f2) && this.hasSameDirection(vector4);
    }

    @Override
    public boolean isCollinear(Vector4 vector4) {
        return this.isOnLine(vector4) && this.hasSameDirection(vector4);
    }

    @Override
    public boolean isCollinearOpposite(Vector4 vector4, float f2) {
        return this.isOnLine(vector4, f2) && this.hasOppositeDirection(vector4);
    }

    @Override
    public boolean isCollinearOpposite(Vector4 vector4) {
        return this.isOnLine(vector4) && this.hasOppositeDirection(vector4);
    }

    @Override
    public boolean isPerpendicular(Vector4 vector4) {
        return MathUtils.isZero(this.dot(vector4));
    }

    @Override
    public boolean isPerpendicular(Vector4 vector4, float f2) {
        return MathUtils.isZero(this.dot(vector4), f2);
    }

    @Override
    public boolean hasSameDirection(Vector4 vector4) {
        return this.dot(vector4) > 0.0f;
    }

    @Override
    public boolean hasOppositeDirection(Vector4 vector4) {
        return this.dot(vector4) < 0.0f;
    }

    @Override
    public Vector4 lerp(Vector4 vector4, float f2) {
        this.x += f2 * (vector4.x - this.x);
        this.y += f2 * (vector4.y - this.y);
        this.z += f2 * (vector4.z - this.z);
        this.w += f2 * (vector4.w - this.w);
        return this;
    }

    @Override
    public Vector4 interpolate(Vector4 vector4, float f2, Interpolation interpolation) {
        return this.lerp(vector4, interpolation.apply(f2));
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + ")";
    }

    public Vector4 fromString(String string) {
        int n2 = string.indexOf(44, 1);
        int n3 = string.indexOf(44, n2 + 1);
        int n4 = string.indexOf(44, n3 + 1);
        if (n2 != -1 && n3 != -1 && string.charAt(0) == '(') {
            String string2 = string;
            if (string2.charAt(string2.length() - 1) == ')') {
                try {
                    float f2 = Float.parseFloat(string.substring(1, n2));
                    float f3 = Float.parseFloat(string.substring(n2 + 1, n3));
                    float f4 = Float.parseFloat(string.substring(n3 + 1, n4));
                    float f5 = Float.parseFloat(string.substring(n4 + 1, string.length() - 1));
                    return this.set(f2, f3, f4, f5);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        throw new GdxRuntimeException("Malformed Vector4: " + string);
    }

    @Override
    public Vector4 limit(float f2) {
        float f3 = f2;
        return this.limit2(f3 * f3);
    }

    @Override
    public Vector4 limit2(float f2) {
        float f3;
        float f4 = this.len2();
        if (f3 > f2) {
            this.scl((float)Math.sqrt(f2 / f4));
        }
        return this;
    }

    @Override
    public Vector4 setLength(float f2) {
        float f3 = f2;
        return this.setLength2(f3 * f3);
    }

    @Override
    public Vector4 setLength2(float f2) {
        float f3 = this.len2();
        if (f3 == 0.0f || f3 == f2) {
            return this;
        }
        return this.scl((float)Math.sqrt(f2 / f3));
    }

    @Override
    public Vector4 clamp(float f2, float f3) {
        float f4 = this.len2();
        if (f4 == 0.0f) {
            return this;
        }
        float f5 = f3;
        f3 = f5 * f5;
        if (f4 > f3) {
            return this.scl((float)Math.sqrt(f3 / f4));
        }
        float f6 = f2;
        f2 = f6 * f6;
        if (f4 < f2) {
            return this.scl((float)Math.sqrt(f2 / f4));
        }
        return this;
    }

    public int hashCode() {
        int n2 = 31 + NumberUtils.floatToIntBits(this.x);
        n2 = n2 * 31 + NumberUtils.floatToIntBits(this.y);
        n2 = n2 * 31 + NumberUtils.floatToIntBits(this.z);
        n2 = n2 * 31 + NumberUtils.floatToIntBits(this.w);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector4)object;
        if (NumberUtils.floatToIntBits(this.x) != NumberUtils.floatToIntBits(((Vector4)object).x)) {
            return false;
        }
        if (NumberUtils.floatToIntBits(this.y) != NumberUtils.floatToIntBits(((Vector4)object).y)) {
            return false;
        }
        if (NumberUtils.floatToIntBits(this.z) != NumberUtils.floatToIntBits(((Vector4)object).z)) {
            return false;
        }
        return NumberUtils.floatToIntBits(this.w) == NumberUtils.floatToIntBits(((Vector4)object).w);
    }

    @Override
    public boolean epsilonEquals(Vector4 vector4, float f2) {
        if (vector4 == null) {
            return false;
        }
        if (Math.abs(vector4.x - this.x) > f2) {
            return false;
        }
        if (Math.abs(vector4.y - this.y) > f2) {
            return false;
        }
        if (Math.abs(vector4.z - this.z) > f2) {
            return false;
        }
        return !(Math.abs(vector4.w - this.w) > f2);
    }

    public boolean epsilonEquals(float f2, float f3, float f4, float f5, float f6) {
        if (Math.abs(f2 - this.x) > f6) {
            return false;
        }
        if (Math.abs(f3 - this.y) > f6) {
            return false;
        }
        if (Math.abs(f4 - this.z) > f6) {
            return false;
        }
        return !(Math.abs(f5 - this.w) > f6);
    }

    public boolean epsilonEquals(Vector4 vector4) {
        return this.epsilonEquals(vector4, 1.0E-6f);
    }

    public boolean epsilonEquals(float f2, float f3, float f4, float f5) {
        return this.epsilonEquals(f2, f3, f4, f5, 1.0E-6f);
    }

    @Override
    public Vector4 setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
        return this;
    }
}

