/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.io.Serializable;

public class OrientedBoundingBox
implements Serializable {
    private static final long serialVersionUID = 3864065514676250557L;
    private static final Vector3[] tempAxes;
    private static final Vector3[] tempVertices;
    private static final Vector3[] tmpVectors;
    private final BoundingBox bounds = new BoundingBox();
    public final Matrix4 transform = new Matrix4();
    private final Matrix4 inverseTransform = new Matrix4();
    private final Vector3[] axes = new Vector3[3];
    private final Vector3[] vertices = new Vector3[8];

    public OrientedBoundingBox() {
        this.bounds.clr();
        this.init();
    }

    public OrientedBoundingBox(BoundingBox boundingBox) {
        this.bounds.set(boundingBox.min, boundingBox.max);
        this.init();
    }

    public OrientedBoundingBox(BoundingBox boundingBox, Matrix4 matrix4) {
        this.bounds.set(boundingBox.min, boundingBox.max);
        this.transform.set(matrix4);
        this.init();
    }

    private void init() {
        int n2;
        for (n2 = 0; n2 < this.axes.length; ++n2) {
            this.axes[n2] = new Vector3();
        }
        for (n2 = 0; n2 < this.vertices.length; ++n2) {
            this.vertices[n2] = new Vector3();
        }
        this.update();
    }

    public Vector3[] getVertices() {
        return this.vertices;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setBounds(BoundingBox boundingBox) {
        this.bounds.set(boundingBox);
        boundingBox.getCorner000(this.vertices[0]).mul(this.transform);
        boundingBox.getCorner001(this.vertices[1]).mul(this.transform);
        boundingBox.getCorner010(this.vertices[2]).mul(this.transform);
        boundingBox.getCorner011(this.vertices[3]).mul(this.transform);
        boundingBox.getCorner100(this.vertices[4]).mul(this.transform);
        boundingBox.getCorner101(this.vertices[5]).mul(this.transform);
        boundingBox.getCorner110(this.vertices[6]).mul(this.transform);
        boundingBox.getCorner111(this.vertices[7]).mul(this.transform);
    }

    public Matrix4 getTransform() {
        return this.transform;
    }

    public void setTransform(Matrix4 matrix4) {
        this.transform.set(matrix4);
        this.update();
    }

    public OrientedBoundingBox set(BoundingBox boundingBox, Matrix4 matrix4) {
        this.setBounds(boundingBox);
        this.setTransform(matrix4);
        return this;
    }

    public Vector3 getCorner000(Vector3 vector3) {
        return vector3.set(this.vertices[0]);
    }

    public Vector3 getCorner001(Vector3 vector3) {
        return vector3.set(this.vertices[1]);
    }

    public Vector3 getCorner010(Vector3 vector3) {
        return vector3.set(this.vertices[2]);
    }

    public Vector3 getCorner011(Vector3 vector3) {
        return vector3.set(this.vertices[3]);
    }

    public Vector3 getCorner100(Vector3 vector3) {
        return vector3.set(this.vertices[4]);
    }

    public Vector3 getCorner101(Vector3 vector3) {
        return vector3.set(this.vertices[5]);
    }

    public Vector3 getCorner110(Vector3 vector3) {
        return vector3.set(this.vertices[6]);
    }

    public Vector3 getCorner111(Vector3 vector3) {
        return vector3.set(this.vertices[7]);
    }

    public boolean contains(Vector3 vector3) {
        return this.contains(vector3, this.inverseTransform);
    }

    private boolean contains(Vector3 vector3, Matrix4 matrix4) {
        vector3 = tmpVectors[0].set(vector3).mul(matrix4);
        return this.bounds.contains(vector3);
    }

    public boolean contains(BoundingBox boundingBox) {
        Vector3 vector3 = tmpVectors[0];
        return this.contains(boundingBox.getCorner000(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner001(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner010(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner011(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner100(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner101(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner110(vector3), this.inverseTransform) && this.contains(boundingBox.getCorner111(vector3), this.inverseTransform);
    }

    public boolean contains(OrientedBoundingBox orientedBoundingBox) {
        return this.contains(orientedBoundingBox.getCorner000(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner001(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner010(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner011(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner100(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner101(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner110(tmpVectors[0]), this.inverseTransform) && this.contains(orientedBoundingBox.getCorner111(tmpVectors[0]), this.inverseTransform);
    }

    public boolean intersects(BoundingBox vector3Array) {
        Vector3[] vector3Array2 = this.axes;
        OrientedBoundingBox.tempAxes[0] = vector3Array2[0];
        OrientedBoundingBox.tempAxes[1] = vector3Array2[1];
        OrientedBoundingBox.tempAxes[2] = vector3Array2[2];
        OrientedBoundingBox.tempAxes[3] = Vector3.X;
        OrientedBoundingBox.tempAxes[4] = Vector3.Y;
        OrientedBoundingBox.tempAxes[5] = Vector3.Z;
        OrientedBoundingBox.tempAxes[6] = tmpVectors[0].set(vector3Array2[0]).crs(Vector3.X);
        OrientedBoundingBox.tempAxes[7] = tmpVectors[1].set(vector3Array2[0]).crs(Vector3.Y);
        OrientedBoundingBox.tempAxes[8] = tmpVectors[2].set(vector3Array2[0]).crs(Vector3.Z);
        OrientedBoundingBox.tempAxes[9] = tmpVectors[3].set(vector3Array2[1]).crs(Vector3.X);
        OrientedBoundingBox.tempAxes[10] = tmpVectors[4].set(vector3Array2[1]).crs(Vector3.Y);
        OrientedBoundingBox.tempAxes[11] = tmpVectors[5].set(vector3Array2[1]).crs(Vector3.Z);
        OrientedBoundingBox.tempAxes[12] = tmpVectors[6].set(vector3Array2[2]).crs(Vector3.X);
        OrientedBoundingBox.tempAxes[13] = tmpVectors[7].set(vector3Array2[2]).crs(Vector3.Y);
        OrientedBoundingBox.tempAxes[14] = tmpVectors[8].set(vector3Array2[2]).crs(Vector3.Z);
        vector3Array2 = this.getVertices();
        vector3Array = this.getVertices((BoundingBox)vector3Array);
        return Intersector.hasOverlap(tempAxes, vector3Array2, vector3Array);
    }

    public boolean intersects(OrientedBoundingBox orientedBoundingBox) {
        Vector3[] vector3Array = this.axes;
        Vector3[] vector3Array2 = orientedBoundingBox.axes;
        OrientedBoundingBox.tempAxes[0] = vector3Array[0];
        OrientedBoundingBox.tempAxes[1] = vector3Array[1];
        OrientedBoundingBox.tempAxes[2] = vector3Array[2];
        OrientedBoundingBox.tempAxes[3] = vector3Array2[0];
        OrientedBoundingBox.tempAxes[4] = vector3Array2[1];
        OrientedBoundingBox.tempAxes[5] = vector3Array2[2];
        OrientedBoundingBox.tempAxes[6] = tmpVectors[0].set(vector3Array[0]).crs(vector3Array2[0]);
        OrientedBoundingBox.tempAxes[7] = tmpVectors[1].set(vector3Array[0]).crs(vector3Array2[1]);
        OrientedBoundingBox.tempAxes[8] = tmpVectors[2].set(vector3Array[0]).crs(vector3Array2[2]);
        OrientedBoundingBox.tempAxes[9] = tmpVectors[3].set(vector3Array[1]).crs(vector3Array2[0]);
        OrientedBoundingBox.tempAxes[10] = tmpVectors[4].set(vector3Array[1]).crs(vector3Array2[1]);
        OrientedBoundingBox.tempAxes[11] = tmpVectors[5].set(vector3Array[1]).crs(vector3Array2[2]);
        OrientedBoundingBox.tempAxes[12] = tmpVectors[6].set(vector3Array[2]).crs(vector3Array2[0]);
        OrientedBoundingBox.tempAxes[13] = tmpVectors[7].set(vector3Array[2]).crs(vector3Array2[1]);
        OrientedBoundingBox.tempAxes[14] = tmpVectors[8].set(vector3Array[2]).crs(vector3Array2[2]);
        return Intersector.hasOverlap(tempAxes, this.vertices, orientedBoundingBox.vertices);
    }

    private Vector3[] getVertices(BoundingBox boundingBox) {
        boundingBox.getCorner000(tempVertices[0]);
        boundingBox.getCorner001(tempVertices[1]);
        boundingBox.getCorner010(tempVertices[2]);
        boundingBox.getCorner011(tempVertices[3]);
        boundingBox.getCorner100(tempVertices[4]);
        boundingBox.getCorner101(tempVertices[5]);
        boundingBox.getCorner110(tempVertices[6]);
        boundingBox.getCorner111(tempVertices[7]);
        return tempVertices;
    }

    public void mul(Matrix4 matrix4) {
        this.transform.mul(matrix4);
        this.update();
    }

    private void update() {
        this.bounds.getCorner000(this.vertices[0]).mul(this.transform);
        this.bounds.getCorner001(this.vertices[1]).mul(this.transform);
        this.bounds.getCorner010(this.vertices[2]).mul(this.transform);
        this.bounds.getCorner011(this.vertices[3]).mul(this.transform);
        this.bounds.getCorner100(this.vertices[4]).mul(this.transform);
        this.bounds.getCorner101(this.vertices[5]).mul(this.transform);
        this.bounds.getCorner110(this.vertices[6]).mul(this.transform);
        this.bounds.getCorner111(this.vertices[7]).mul(this.transform);
        this.axes[0].set(this.transform.val[0], this.transform.val[1], this.transform.val[2]).nor();
        this.axes[1].set(this.transform.val[4], this.transform.val[5], this.transform.val[6]).nor();
        this.axes[2].set(this.transform.val[8], this.transform.val[9], this.transform.val[10]).nor();
        this.inverseTransform.set(this.transform).inv();
    }

    static {
        int n2;
        tempAxes = new Vector3[15];
        tempVertices = new Vector3[8];
        tmpVectors = new Vector3[9];
        for (n2 = 0; n2 < tmpVectors.length; ++n2) {
            OrientedBoundingBox.tmpVectors[n2] = new Vector3();
        }
        for (n2 = 0; n2 < tempVertices.length; ++n2) {
            OrientedBoundingBox.tempVertices[n2] = new Vector3();
        }
    }
}

