/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public final class HttpParametersUtils {
    public static String defaultEncoding = "UTF-8";
    public static String nameValueSeparator = "=";
    public static String parameterSeparator = "&";

    private HttpParametersUtils() {
    }

    public static String convertHttpParameters(Map<String, String> map) {
        Object object = map.keySet();
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuilder.append(HttpParametersUtils.encode(string, defaultEncoding));
            stringBuilder.append(nameValueSeparator);
            stringBuilder.append(HttpParametersUtils.encode(map.get(string), defaultEncoding));
            stringBuilder.append(parameterSeparator);
        }
        if (stringBuilder.length() > 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static String encode(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }
}

