/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net$HttpResponse;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

class NetJavaImpl$HttpClientResponse
implements Net$HttpResponse {
    private final HttpURLConnection connection;
    private HttpStatus status;

    public NetJavaImpl$HttpClientResponse(HttpURLConnection httpURLConnection) {
        this.connection = httpURLConnection;
        try {
            this.status = new HttpStatus(httpURLConnection.getResponseCode());
            return;
        }
        catch (IOException iOException) {
            this.status = new HttpStatus(-1);
            return;
        }
    }

    @Override
    public byte[] getResult() {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return StreamUtils.EMPTY_BYTES;
        }
        try {
            byte[] byArray = StreamUtils.copyStreamToByteArray(inputStream, this.connection.getContentLength());
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = StreamUtils.EMPTY_BYTES;
            return byArray;
        }
        finally {
            StreamUtils.closeQuietly(inputStream);
        }
    }

    @Override
    public String getResultAsString() {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return "";
        }
        try {
            String string = StreamUtils.copyStreamToString(inputStream, this.connection.getContentLength(), "UTF8");
            return string;
        }
        catch (IOException iOException) {
            String string = "";
            return string;
        }
        finally {
            StreamUtils.closeQuietly(inputStream);
        }
    }

    @Override
    public InputStream getResultAsStream() {
        return this.getInputStream();
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public String getHeader(String string) {
        return this.connection.getHeaderField(string);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.connection.getHeaderFields();
    }

    private InputStream getInputStream() {
        try {
            return this.connection.getInputStream();
        }
        catch (IOException iOException) {
            return this.connection.getErrorStream();
        }
    }
}

