/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net$HttpRequest;
import com.badlogic.gdx.Net$HttpResponseListener;
import com.badlogic.gdx.net.NetJavaImpl$1;
import com.badlogic.gdx.net.NetJavaImpl$2;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NetJavaImpl {
    private final ThreadPoolExecutor executorService;
    final ObjectMap<Net$HttpRequest, HttpURLConnection> connections;
    final ObjectMap<Net$HttpRequest, Net$HttpResponseListener> listeners;
    final ObjectMap<Net$HttpRequest, Future<?>> tasks;

    public NetJavaImpl() {
        this(Integer.MAX_VALUE);
    }

    public NetJavaImpl(int n2) {
        boolean bl = n2 == Integer.MAX_VALUE;
        this.executorService = new ThreadPoolExecutor(bl ? 0 : n2, n2, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((BlockingQueue)((Object)(bl ? new SynchronousQueue() : new LinkedBlockingQueue()))), new NetJavaImpl$1(this));
        this.executorService.allowCoreThreadTimeOut(!bl);
        this.connections = new ObjectMap();
        this.listeners = new ObjectMap();
        this.tasks = new ObjectMap();
    }

    public void sendHttpRequest(Net$HttpRequest net$HttpRequest, Net$HttpResponseListener net$HttpResponseListener) {
        if (net$HttpRequest.getUrl() == null) {
            net$HttpResponseListener.failed(new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            Object object;
            boolean bl;
            String object22 = net$HttpRequest.getMethod();
            boolean bl2 = !object22.equalsIgnoreCase("HEAD");
            boolean bl3 = bl = object22.equalsIgnoreCase("POST") || object22.equalsIgnoreCase("PUT") || object22.equalsIgnoreCase("PATCH");
            if (object22.equalsIgnoreCase("GET") || object22.equalsIgnoreCase("HEAD")) {
                object = "";
                String string = net$HttpRequest.getContent();
                if (string != null && !"".equals(string)) {
                    object = "?" + (String)string;
                }
                object = new URL(net$HttpRequest.getUrl() + (String)object);
            } else {
                object = new URL(net$HttpRequest.getUrl());
            }
            object = (HttpURLConnection)((URL)object).openConnection();
            ((URLConnection)object).setDoOutput(bl);
            ((URLConnection)object).setDoInput(bl2);
            ((HttpURLConnection)object).setRequestMethod(object22);
            HttpURLConnection.setFollowRedirects(net$HttpRequest.getFollowRedirects());
            this.putIntoConnectionsAndListeners(net$HttpRequest, net$HttpResponseListener, (HttpURLConnection)object);
            for (Map.Entry entry : net$HttpRequest.getHeaders().entrySet()) {
                ((URLConnection)object).addRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            ((URLConnection)object).setConnectTimeout(net$HttpRequest.getTimeOut());
            ((URLConnection)object).setReadTimeout(net$HttpRequest.getTimeOut());
            this.tasks.put(net$HttpRequest, this.executorService.submit(new NetJavaImpl$2(this, bl, net$HttpRequest, (HttpURLConnection)object, net$HttpResponseListener)));
            return;
        }
        catch (Exception exception) {
            try {
                net$HttpResponseListener.failed(exception);
                return;
            }
            finally {
                this.removeFromConnectionsAndListeners(net$HttpRequest);
            }
        }
    }

    public void cancelHttpRequest(Net$HttpRequest net$HttpRequest) {
        Net$HttpResponseListener net$HttpResponseListener = this.getFromListeners(net$HttpRequest);
        if (net$HttpResponseListener != null) {
            net$HttpResponseListener.cancelled();
            this.cancelTask(net$HttpRequest);
            this.removeFromConnectionsAndListeners(net$HttpRequest);
        }
    }

    public boolean isHttpRequestPending(Net$HttpRequest net$HttpRequest) {
        return this.getFromListeners(net$HttpRequest) != null;
    }

    private void cancelTask(Net$HttpRequest object) {
        if ((object = this.tasks.get(object)) != null) {
            object.cancel(false);
        }
    }

    synchronized void removeFromConnectionsAndListeners(Net$HttpRequest net$HttpRequest) {
        this.connections.remove(net$HttpRequest);
        this.listeners.remove(net$HttpRequest);
        this.tasks.remove(net$HttpRequest);
    }

    synchronized void putIntoConnectionsAndListeners(Net$HttpRequest net$HttpRequest, Net$HttpResponseListener net$HttpResponseListener, HttpURLConnection httpURLConnection) {
        this.connections.put(net$HttpRequest, httpURLConnection);
        this.listeners.put(net$HttpRequest, net$HttpResponseListener);
    }

    synchronized Net$HttpResponseListener getFromListeners(Net$HttpRequest object) {
        object = this.listeners.get(object);
        return object;
    }
}

