/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.Application$ApplicationType;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputEvent$Type;
import com.badlogic.gdx.scenes.scene2d.Stage$TouchFocus;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Table$Debug;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener$FocusEvent;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener$FocusEvent$Type;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.SnapshotArray;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class Stage
extends InputAdapter
implements Disposable {
    static boolean debug;
    private Viewport viewport;
    private final Batch batch;
    private boolean ownsBatch;
    private Group root;
    private final Vector2 tempCoords = new Vector2();
    private final Actor[] pointerOverActors = new Actor[20];
    private final boolean[] pointerTouched = new boolean[20];
    private final int[] pointerScreenX = new int[20];
    private final int[] pointerScreenY = new int[20];
    private int mouseScreenX;
    private int mouseScreenY;
    @Null
    private Actor mouseOverActor;
    @Null
    private Actor keyboardFocus;
    @Null
    private Actor scrollFocus;
    final SnapshotArray<Stage$TouchFocus> touchFocuses = new SnapshotArray(true, 4, Stage$TouchFocus.class);
    private boolean actionsRequestRendering = true;
    private ShapeRenderer debugShapes;
    private boolean debugInvisible;
    private boolean debugAll;
    private boolean debugUnderMouse;
    private boolean debugParentUnderMouse;
    private Table$Debug debugTableUnderMouse = Table$Debug.none;
    private final Color debugColor = new Color(0.0f, 1.0f, 0.0f, 0.85f);

    public Stage() {
        this(new ScalingViewport(Scaling.stretch, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), new OrthographicCamera()), new SpriteBatch());
        this.ownsBatch = true;
    }

    public Stage(Viewport viewport) {
        this(viewport, new SpriteBatch());
        this.ownsBatch = true;
    }

    public Stage(Viewport viewport, Batch batch) {
        if (viewport == null) {
            throw new IllegalArgumentException("viewport cannot be null.");
        }
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        this.viewport = viewport;
        this.batch = batch;
        this.root = new Group();
        ((Actor)this.root).setStage(this);
        viewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
    }

    public void draw() {
        Camera camera = this.viewport.getCamera();
        camera.update();
        if (!this.root.isVisible()) {
            return;
        }
        Batch batch = this.batch;
        batch.setProjectionMatrix(camera.combined);
        batch.begin();
        ((Actor)this.root).draw(batch, 1.0f);
        batch.end();
        if (debug) {
            this.drawDebug();
        }
    }

    private void drawDebug() {
        if (this.debugShapes == null) {
            this.debugShapes = new ShapeRenderer();
            this.debugShapes.setAutoShapeType(true);
        }
        if (this.debugUnderMouse || this.debugParentUnderMouse || this.debugTableUnderMouse != Table$Debug.none) {
            Stage stage = this;
            stage.screenToStageCoordinates(stage.tempCoords.set(Gdx.input.getX(), Gdx.input.getY()));
            Stage stage2 = this;
            Actor actor = stage2.hit(stage2.tempCoords.x, this.tempCoords.y, true);
            if (actor == null) {
                return;
            }
            if (this.debugParentUnderMouse && actor.parent != null) {
                actor = actor.parent;
            }
            if (this.debugTableUnderMouse == Table$Debug.none) {
                actor.setDebug(true);
            } else {
                while (actor != null && !(actor instanceof Table)) {
                    actor = actor.parent;
                }
                if (actor == null) {
                    return;
                }
                ((Table)actor).debug(this.debugTableUnderMouse);
            }
            if (this.debugAll && actor instanceof Group) {
                ((Group)actor).debugAll();
            }
            Stage stage3 = this;
            stage3.disableDebug(stage3.root, actor);
        } else if (this.debugAll) {
            this.root.debugAll();
        }
        Gdx.gl.glEnable(3042);
        this.debugShapes.setProjectionMatrix(this.viewport.getCamera().combined);
        this.debugShapes.begin();
        ((Actor)this.root).drawDebug(this.debugShapes);
        this.debugShapes.end();
        Gdx.gl.glDisable(3042);
    }

    private void disableDebug(Actor object, Actor actor) {
        if (object == actor) {
            return;
        }
        ((Actor)object).setDebug(false);
        if (object instanceof Group) {
            object = ((Group)object).children;
            int n2 = ((Array)object).size;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.disableDebug((Actor)((Array)object).get(i2), actor);
            }
        }
    }

    public void act() {
        this.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
    }

    public void act(float f2) {
        int n2 = this.pointerOverActors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Actor actor = this.pointerOverActors[i2];
            if (this.pointerTouched[i2]) {
                this.pointerOverActors[i2] = this.fireEnterAndExit(actor, this.pointerScreenX[i2], this.pointerScreenY[i2], i2);
                continue;
            }
            if (actor == null) continue;
            this.pointerOverActors[i2] = null;
            this.fireExit(actor, this.pointerScreenX[i2], this.pointerScreenY[i2], i2);
        }
        Application$ApplicationType application$ApplicationType = Gdx.app.getType();
        if (application$ApplicationType == Application$ApplicationType.Desktop || application$ApplicationType == Application$ApplicationType.Applet || application$ApplicationType == Application$ApplicationType.WebGL) {
            this.mouseOverActor = this.fireEnterAndExit(this.mouseOverActor, this.mouseScreenX, this.mouseScreenY, -1);
        }
        ((Actor)this.root).act(f2);
    }

    @Null
    private Actor fireEnterAndExit(@Null Actor actor, int n2, int n3, int n4) {
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(n2, n3));
        Stage stage2 = this;
        Actor actor2 = stage2.hit(stage2.tempCoords.x, this.tempCoords.y, true);
        if (actor2 == actor) {
            return actor;
        }
        if (actor != null) {
            InputEvent inputEvent = Pools.obtain(InputEvent.class);
            inputEvent.setType(InputEvent$Type.exit);
            inputEvent.setStage(this);
            inputEvent.setStageX(this.tempCoords.x);
            inputEvent.setStageY(this.tempCoords.y);
            inputEvent.setPointer(n4);
            inputEvent.setRelatedActor(actor2);
            actor.fire(inputEvent);
            Pools.free(inputEvent);
        }
        if (actor2 != null) {
            InputEvent inputEvent = Pools.obtain(InputEvent.class);
            inputEvent.setType(InputEvent$Type.enter);
            inputEvent.setStage(this);
            inputEvent.setStageX(this.tempCoords.x);
            inputEvent.setStageY(this.tempCoords.y);
            inputEvent.setPointer(n4);
            inputEvent.setRelatedActor(actor);
            actor2.fire(inputEvent);
            Pools.free(inputEvent);
        }
        return actor2;
    }

    private void fireExit(Actor actor, int n2, int n3, int n4) {
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(n2, n3));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.exit);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n4);
        inputEvent.setRelatedActor(actor);
        actor.fire(inputEvent);
        Pools.free(inputEvent);
    }

    @Override
    public boolean touchDown(int n2, int n3, int n4, int n5) {
        if (!this.isInsideViewport(n2, n3)) {
            return false;
        }
        this.pointerTouched[n4] = true;
        this.pointerScreenX[n4] = n2;
        this.pointerScreenY[n4] = n3;
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(n2, n3));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.touchDown);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n4);
        inputEvent.setButton(n5);
        Stage stage2 = this;
        Actor actor = stage2.hit(stage2.tempCoords.x, this.tempCoords.y, true);
        if (actor == null) {
            if (this.root.getTouchable() == Touchable.enabled) {
                this.root.fire(inputEvent);
            }
        } else {
            actor.fire(inputEvent);
        }
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean touchDragged(int n2, int n3, int n4) {
        char n5;
        this.pointerScreenX[n4] = n2;
        this.pointerScreenY[n4] = n3;
        this.mouseScreenX = n2;
        this.mouseScreenY = n3;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(n2, n3));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.touchDragged);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n4);
        SnapshotArray<Stage$TouchFocus> snapshotArray = this.touchFocuses;
        Stage$TouchFocus[] stage$TouchFocusArray = snapshotArray.begin();
        char n6 = snapshotArray.size;
        for (n5 = '\u0000'; n5 < n6; n5 += 1) {
            Stage$TouchFocus stage$TouchFocus = stage$TouchFocusArray[n5];
            if (stage$TouchFocus.pointer != n4 || !snapshotArray.contains(stage$TouchFocus, true)) continue;
            inputEvent.setTarget(stage$TouchFocus.target);
            inputEvent.setListenerActor(stage$TouchFocus.listenerActor);
            if (!stage$TouchFocus.listener.handle(inputEvent)) continue;
            inputEvent.handle();
        }
        snapshotArray.end();
        n5 = inputEvent.isHandled() ? '\u0001' : '\u0000';
        Pools.free(inputEvent);
        return n5 != '\u0000';
    }

    @Override
    public boolean touchUp(int n2, int n3, int n4, int n5) {
        char n6;
        this.pointerTouched[n4] = false;
        this.pointerScreenX[n4] = n2;
        this.pointerScreenY[n4] = n3;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(n2, n3));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.touchUp);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n4);
        inputEvent.setButton(n5);
        SnapshotArray<Stage$TouchFocus> snapshotArray = this.touchFocuses;
        Stage$TouchFocus[] stage$TouchFocusArray = snapshotArray.begin();
        char n7 = snapshotArray.size;
        for (n6 = '\u0000'; n6 < n7; n6 += 1) {
            Stage$TouchFocus stage$TouchFocus = stage$TouchFocusArray[n6];
            if (stage$TouchFocus.pointer != n4 || stage$TouchFocus.button != n5 || !((Array)snapshotArray).removeValue(stage$TouchFocus, true)) continue;
            inputEvent.setTarget(stage$TouchFocus.target);
            inputEvent.setListenerActor(stage$TouchFocus.listenerActor);
            if (stage$TouchFocus.listener.handle(inputEvent)) {
                inputEvent.handle();
            }
            Pools.free(stage$TouchFocus);
        }
        snapshotArray.end();
        n6 = inputEvent.isHandled() ? '\u0001' : '\u0000';
        Pools.free(inputEvent);
        return n6 != '\u0000';
    }

    @Override
    public boolean touchCancelled(int n2, int n3, int n4, int n5) {
        this.cancelTouchFocus();
        return false;
    }

    @Override
    public boolean mouseMoved(int n2, int n3) {
        this.mouseScreenX = n2;
        this.mouseScreenY = n3;
        if (!this.isInsideViewport(n2, n3)) {
            return false;
        }
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(n2, n3));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.mouseMoved);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        Stage stage2 = this;
        Actor actor = stage2.hit(stage2.tempCoords.x, this.tempCoords.y, true);
        if (actor == null) {
            actor = this.root;
        }
        actor.fire(inputEvent);
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean scrolled(float f2, float f3) {
        Actor actor = this.scrollFocus == null ? this.root : this.scrollFocus;
        Stage stage = this;
        stage.screenToStageCoordinates(stage.tempCoords.set(this.mouseScreenX, this.mouseScreenY));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.scrolled);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setScrollAmountX(f2);
        inputEvent.setScrollAmountY(f3);
        actor.fire(inputEvent);
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean keyDown(int n2) {
        Actor actor = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.keyDown);
        inputEvent.setStage(this);
        inputEvent.setKeyCode(n2);
        actor.fire(inputEvent);
        n2 = inputEvent.isHandled() ? '\u0001' : '\u0000';
        Pools.free(inputEvent);
        return n2 != '\u0000';
    }

    @Override
    public boolean keyUp(int n2) {
        Actor actor = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.keyUp);
        inputEvent.setStage(this);
        inputEvent.setKeyCode(n2);
        actor.fire(inputEvent);
        n2 = inputEvent.isHandled() ? '\u0001' : '\u0000';
        Pools.free(inputEvent);
        return n2 != '\u0000';
    }

    @Override
    public boolean keyTyped(char c2) {
        Actor actor = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.keyTyped);
        inputEvent.setStage(this);
        inputEvent.setCharacter(c2);
        actor.fire(inputEvent);
        c2 = inputEvent.isHandled() ? '\u0001' : '\u0000';
        Pools.free(inputEvent);
        return c2 != '\u0000';
    }

    public void addTouchFocus(EventListener eventListener, Actor actor, Actor actor2, int n2, int n3) {
        Stage$TouchFocus stage$TouchFocus = Pools.obtain(Stage$TouchFocus.class);
        Pools.obtain(Stage$TouchFocus.class).listenerActor = actor;
        stage$TouchFocus.target = actor2;
        stage$TouchFocus.listener = eventListener;
        stage$TouchFocus.pointer = n2;
        stage$TouchFocus.button = n3;
        this.touchFocuses.add(stage$TouchFocus);
    }

    public void removeTouchFocus(EventListener eventListener, Actor actor, Actor actor2, int n2, int n3) {
        SnapshotArray<Stage$TouchFocus> snapshotArray = this.touchFocuses;
        for (int i2 = snapshotArray.size - 1; i2 >= 0; --i2) {
            Stage$TouchFocus stage$TouchFocus = (Stage$TouchFocus)snapshotArray.get(i2);
            if (stage$TouchFocus.listener != eventListener || stage$TouchFocus.listenerActor != actor || stage$TouchFocus.target != actor2 || stage$TouchFocus.pointer != n2 || stage$TouchFocus.button != n3) continue;
            ((Array)snapshotArray).removeIndex(i2);
            Pools.free(stage$TouchFocus);
        }
    }

    public void cancelTouchFocus(Actor actor) {
        Event event = null;
        SnapshotArray<Stage$TouchFocus> snapshotArray = this.touchFocuses;
        Stage$TouchFocus[] stage$TouchFocusArray = snapshotArray.begin();
        int n2 = snapshotArray.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Stage$TouchFocus stage$TouchFocus = stage$TouchFocusArray[i2];
            if (stage$TouchFocus.listenerActor != actor || !((Array)snapshotArray).removeValue(stage$TouchFocus, true)) continue;
            if (event == null) {
                event = Pools.obtain(InputEvent.class);
                ((InputEvent)event).setType(InputEvent$Type.touchUp);
                event.setStage(this);
                ((InputEvent)event).setStageX(-2.1474836E9f);
                ((InputEvent)event).setStageY(-2.1474836E9f);
            }
            event.setTarget(stage$TouchFocus.target);
            event.setListenerActor(stage$TouchFocus.listenerActor);
            ((InputEvent)event).setPointer(stage$TouchFocus.pointer);
            ((InputEvent)event).setButton(stage$TouchFocus.button);
            stage$TouchFocus.listener.handle(event);
        }
        snapshotArray.end();
        if (event != null) {
            Pools.free(event);
        }
    }

    public void cancelTouchFocus() {
        this.cancelTouchFocusExcept(null, null);
    }

    public void cancelTouchFocusExcept(@Null EventListener eventListener, @Null Actor actor) {
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent$Type.touchUp);
        inputEvent.setStage(this);
        inputEvent.setStageX(-2.1474836E9f);
        inputEvent.setStageY(-2.1474836E9f);
        SnapshotArray<Stage$TouchFocus> snapshotArray = this.touchFocuses;
        Stage$TouchFocus[] stage$TouchFocusArray = snapshotArray.begin();
        int n2 = snapshotArray.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Stage$TouchFocus stage$TouchFocus = stage$TouchFocusArray[i2];
            if (stage$TouchFocus.listener == eventListener && stage$TouchFocus.listenerActor == actor || !((Array)snapshotArray).removeValue(stage$TouchFocus, true)) continue;
            inputEvent.setTarget(stage$TouchFocus.target);
            inputEvent.setListenerActor(stage$TouchFocus.listenerActor);
            inputEvent.setPointer(stage$TouchFocus.pointer);
            inputEvent.setButton(stage$TouchFocus.button);
            stage$TouchFocus.listener.handle(inputEvent);
        }
        snapshotArray.end();
        Pools.free(inputEvent);
    }

    public void addActor(Actor actor) {
        this.root.addActor(actor);
    }

    public void addAction(Action action) {
        this.root.addAction(action);
    }

    public Array<Actor> getActors() {
        return this.root.children;
    }

    public boolean addListener(EventListener eventListener) {
        return this.root.addListener(eventListener);
    }

    public boolean removeListener(EventListener eventListener) {
        return this.root.removeListener(eventListener);
    }

    public boolean addCaptureListener(EventListener eventListener) {
        return this.root.addCaptureListener(eventListener);
    }

    public boolean removeCaptureListener(EventListener eventListener) {
        return this.root.removeCaptureListener(eventListener);
    }

    protected void actorRemoved(Actor actor) {
        int n2 = this.pointerOverActors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (actor != this.pointerOverActors[i2]) continue;
            this.pointerOverActors[i2] = null;
            this.fireExit(actor, this.pointerScreenX[i2], this.pointerScreenY[i2], i2);
        }
        if (actor == this.mouseOverActor) {
            this.mouseOverActor = null;
            this.fireExit(actor, this.mouseScreenX, this.mouseScreenY, -1);
        }
    }

    public void clear() {
        this.unfocusAll();
        ((Actor)this.root).clear();
    }

    public void unfocusAll() {
        this.setScrollFocus(null);
        this.setKeyboardFocus(null);
        this.cancelTouchFocus();
    }

    public void unfocus(Actor actor) {
        this.cancelTouchFocus(actor);
        if (this.scrollFocus != null && this.scrollFocus.isDescendantOf(actor)) {
            this.setScrollFocus(null);
        }
        if (this.keyboardFocus != null && this.keyboardFocus.isDescendantOf(actor)) {
            this.setKeyboardFocus(null);
        }
    }

    public boolean setKeyboardFocus(@Null Actor actor) {
        boolean bl;
        if (this.keyboardFocus == actor) {
            return true;
        }
        FocusListener$FocusEvent focusListener$FocusEvent = Pools.obtain(FocusListener$FocusEvent.class);
        focusListener$FocusEvent.setStage(this);
        focusListener$FocusEvent.setType(FocusListener$FocusEvent$Type.keyboard);
        Actor actor2 = this.keyboardFocus;
        if (actor2 != null) {
            focusListener$FocusEvent.setFocused(false);
            focusListener$FocusEvent.setRelatedActor(actor);
            actor2.fire(focusListener$FocusEvent);
        }
        if (bl = !focusListener$FocusEvent.isCancelled()) {
            this.keyboardFocus = actor;
            if (actor != null) {
                focusListener$FocusEvent.setFocused(true);
                focusListener$FocusEvent.setRelatedActor(actor2);
                actor.fire(focusListener$FocusEvent);
                bl = !focusListener$FocusEvent.isCancelled();
                if (!bl) {
                    this.keyboardFocus = actor2;
                }
            }
        }
        Pools.free(focusListener$FocusEvent);
        return bl;
    }

    @Null
    public Actor getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public boolean setScrollFocus(@Null Actor actor) {
        boolean bl;
        if (this.scrollFocus == actor) {
            return true;
        }
        FocusListener$FocusEvent focusListener$FocusEvent = Pools.obtain(FocusListener$FocusEvent.class);
        focusListener$FocusEvent.setStage(this);
        focusListener$FocusEvent.setType(FocusListener$FocusEvent$Type.scroll);
        Actor actor2 = this.scrollFocus;
        if (actor2 != null) {
            focusListener$FocusEvent.setFocused(false);
            focusListener$FocusEvent.setRelatedActor(actor);
            actor2.fire(focusListener$FocusEvent);
        }
        if (bl = !focusListener$FocusEvent.isCancelled()) {
            this.scrollFocus = actor;
            if (actor != null) {
                focusListener$FocusEvent.setFocused(true);
                focusListener$FocusEvent.setRelatedActor(actor2);
                actor.fire(focusListener$FocusEvent);
                bl = !focusListener$FocusEvent.isCancelled();
                if (!bl) {
                    this.scrollFocus = actor2;
                }
            }
        }
        Pools.free(focusListener$FocusEvent);
        return bl;
    }

    @Null
    public Actor getScrollFocus() {
        return this.scrollFocus;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public float getWidth() {
        return this.viewport.getWorldWidth();
    }

    public float getHeight() {
        return this.viewport.getWorldHeight();
    }

    public Camera getCamera() {
        return this.viewport.getCamera();
    }

    public Group getRoot() {
        return this.root;
    }

    public void setRoot(Group group) {
        if (group.parent != null) {
            group.parent.removeActor(group, false);
        }
        this.root = group;
        group.setParent(null);
        ((Actor)group).setStage(this);
    }

    @Null
    public Actor hit(float f2, float f3, boolean bl) {
        this.root.parentToLocalCoordinates(this.tempCoords.set(f2, f3));
        return ((Actor)this.root).hit(this.tempCoords.x, this.tempCoords.y, bl);
    }

    public Vector2 screenToStageCoordinates(Vector2 vector2) {
        this.viewport.unproject(vector2);
        return vector2;
    }

    public Vector2 stageToScreenCoordinates(Vector2 vector2) {
        this.viewport.project(vector2);
        vector2.y = (float)Gdx.graphics.getHeight() - vector2.y;
        return vector2;
    }

    public Vector2 toScreenCoordinates(Vector2 vector2, Matrix4 matrix4) {
        return this.viewport.toScreenCoordinates(vector2, matrix4);
    }

    public void calculateScissors(Rectangle rectangle, Rectangle rectangle2) {
        Matrix4 matrix4 = this.debugShapes != null && this.debugShapes.isDrawing() ? this.debugShapes.getTransformMatrix() : this.batch.getTransformMatrix();
        this.viewport.calculateScissors(matrix4, rectangle, rectangle2);
    }

    public void setActionsRequestRendering(boolean bl) {
        this.actionsRequestRendering = bl;
    }

    public boolean getActionsRequestRendering() {
        return this.actionsRequestRendering;
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public void setDebugInvisible(boolean bl) {
        this.debugInvisible = bl;
    }

    public void setDebugAll(boolean bl) {
        if (this.debugAll == bl) {
            return;
        }
        this.debugAll = bl;
        if (bl) {
            debug = true;
            return;
        }
        this.root.setDebug(false, true);
    }

    public boolean isDebugAll() {
        return this.debugAll;
    }

    public void setDebugUnderMouse(boolean bl) {
        if (this.debugUnderMouse == bl) {
            return;
        }
        this.debugUnderMouse = bl;
        if (bl) {
            debug = true;
            return;
        }
        this.root.setDebug(false, true);
    }

    public void setDebugParentUnderMouse(boolean bl) {
        if (this.debugParentUnderMouse == bl) {
            return;
        }
        this.debugParentUnderMouse = bl;
        if (bl) {
            debug = true;
            return;
        }
        this.root.setDebug(false, true);
    }

    public void setDebugTableUnderMouse(@Null Table$Debug table$Debug) {
        if (table$Debug == null) {
            table$Debug = Table$Debug.none;
        }
        if (this.debugTableUnderMouse == table$Debug) {
            return;
        }
        this.debugTableUnderMouse = table$Debug;
        if (table$Debug != Table$Debug.none) {
            debug = true;
            return;
        }
        this.root.setDebug(false, true);
    }

    public void setDebugTableUnderMouse(boolean bl) {
        this.setDebugTableUnderMouse(bl ? Table$Debug.all : Table$Debug.none);
    }

    @Override
    public void dispose() {
        this.clear();
        if (this.ownsBatch) {
            this.batch.dispose();
        }
        if (this.debugShapes != null) {
            this.debugShapes.dispose();
        }
    }

    protected boolean isInsideViewport(int n2, int n3) {
        int n4 = this.viewport.getScreenX();
        int n5 = n4 + this.viewport.getScreenWidth();
        int n6 = this.viewport.getScreenY();
        int n7 = n6 + this.viewport.getScreenHeight();
        n3 = Gdx.graphics.getHeight() - 1 - n3;
        return n2 >= n4 && n2 < n5 && n3 >= n6 && n3 < n7;
    }
}

