/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;

public abstract class TemporalAction
extends Action {
    private float duration;
    private float time;
    @Null
    private Interpolation interpolation;
    private boolean reverse;
    private boolean began;
    private boolean complete;

    public TemporalAction() {
    }

    public TemporalAction(float f2) {
        this.duration = f2;
    }

    public TemporalAction(float f2, @Null Interpolation interpolation) {
        this.duration = f2;
        this.interpolation = interpolation;
    }

    @Override
    public boolean act(float f2) {
        if (this.complete) {
            return true;
        }
        Pool pool = this.getPool();
        this.setPool(null);
        try {
            TemporalAction temporalAction;
            if (!this.began) {
                this.begin();
                this.began = true;
            }
            this.time += f2;
            this.complete = temporalAction.time >= this.duration;
            float f3 = f2 = this.complete ? 1.0f : this.time / this.duration;
            if (this.interpolation != null) {
                f2 = this.interpolation.apply(f2);
            }
            TemporalAction temporalAction2 = this;
            temporalAction2.update(temporalAction2.reverse ? 1.0f - f2 : f2);
            if (this.complete) {
                this.end();
            }
            boolean bl = this.complete;
            return bl;
        }
        finally {
            this.setPool(pool);
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected abstract void update(float var1);

    public void finish() {
        this.time = this.duration;
    }

    @Override
    public void restart() {
        this.time = 0.0f;
        this.began = false;
        this.complete = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.reverse = false;
        this.interpolation = null;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float f2) {
        this.time = f2;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float f2) {
        this.duration = f2;
    }

    @Null
    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(@Null Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

