/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button$1;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener$ChangeEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

public class Button
extends Table
implements Disableable {
    private Button$ButtonStyle style;
    boolean isChecked;
    boolean isDisabled;
    ButtonGroup buttonGroup;
    private ClickListener clickListener;
    private boolean programmaticChangeEvents = true;

    public Button(Skin skin) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(Button$ButtonStyle.class));
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button(Skin skin, String string) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(string, Button$ButtonStyle.class));
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button(Actor actor, Skin skin, String string) {
        this(actor, skin.get(string, Button$ButtonStyle.class));
        this.setSkin(skin);
    }

    public Button(Actor actor, Button$ButtonStyle button$ButtonStyle) {
        this.initialize();
        this.add(actor);
        this.setStyle(button$ButtonStyle);
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button(Button$ButtonStyle button$ButtonStyle) {
        this.initialize();
        this.setStyle(button$ButtonStyle);
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button() {
        this.initialize();
    }

    private void initialize() {
        this.setTouchable(Touchable.enabled);
        this.clickListener = new Button$1(this);
        this.addListener(this.clickListener);
    }

    public Button(@Null Drawable drawable) {
        this(new Button$ButtonStyle(drawable, null, null));
    }

    public Button(@Null Drawable drawable, @Null Drawable drawable2) {
        this(new Button$ButtonStyle(drawable, drawable2, null));
    }

    public Button(@Null Drawable drawable, @Null Drawable drawable2, @Null Drawable drawable3) {
        this(new Button$ButtonStyle(drawable, drawable2, drawable3));
    }

    public Button(Actor actor, Skin skin) {
        this(actor, skin.get(Button$ButtonStyle.class));
    }

    public void setChecked(boolean bl) {
        this.setChecked(bl, this.programmaticChangeEvents);
    }

    void setChecked(boolean bl, boolean bl2) {
        if (this.isChecked == bl) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, bl)) {
            return;
        }
        this.isChecked = bl;
        if (bl2) {
            ChangeListener$ChangeEvent changeListener$ChangeEvent = Pools.obtain(ChangeListener$ChangeEvent.class);
            if (this.fire(changeListener$ChangeEvent)) {
                this.isChecked = !bl;
            }
            Pools.free(changeListener$ChangeEvent);
        }
    }

    public void toggle() {
        Button button = this;
        button.setChecked(!button.isChecked);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isPressed() {
        return this.clickListener.isVisualPressed();
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean bl) {
        this.isDisabled = bl;
    }

    public void setProgrammaticChangeEvents(boolean bl) {
        this.programmaticChangeEvents = bl;
    }

    public void setStyle(Button$ButtonStyle button$ButtonStyle) {
        if (button$ButtonStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = button$ButtonStyle;
        Button button = this;
        button.setBackground(button.getBackgroundDrawable());
    }

    public Button$ButtonStyle getStyle() {
        return this.style;
    }

    @Null
    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        if (this.isDisabled() && this.style.disabled != null) {
            return this.style.disabled;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDown != null) {
                return this.style.checkedDown;
            }
            if (this.style.down != null) {
                return this.style.down;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOver != null) {
                    return this.style.checkedOver;
                }
            } else if (this.style.over != null) {
                return this.style.over;
            }
        }
        boolean bl = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (bl && this.style.checkedFocused != null) {
                return this.style.checkedFocused;
            }
            if (this.style.checked != null) {
                return this.style.checked;
            }
            if (this.isOver() && this.style.over != null) {
                return this.style.over;
            }
        }
        if (bl && this.style.focused != null) {
            return this.style.focused;
        }
        return this.style.up;
    }

    @Override
    public void draw(Batch batch, float f2) {
        Stage stage;
        int n2;
        float f3;
        float f4;
        this.validate();
        Button button = this;
        button.setBackground(button.getBackgroundDrawable());
        if (this.isPressed() && !this.isDisabled()) {
            f4 = this.style.pressedOffsetX;
            f3 = this.style.pressedOffsetY;
        } else if (this.isChecked() && !this.isDisabled()) {
            f4 = this.style.checkedOffsetX;
            f3 = this.style.checkedOffsetY;
        } else {
            f4 = this.style.unpressedOffsetX;
            f3 = this.style.unpressedOffsetY;
        }
        boolean bl = f4 != 0.0f || f3 != 0.0f;
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        if (bl) {
            for (n2 = 0; n2 < snapshotArray.size; ++n2) {
                ((Actor)snapshotArray.get(n2)).moveBy(f4, f3);
            }
        }
        super.draw(batch, f2);
        if (bl) {
            for (n2 = 0; n2 < snapshotArray.size; ++n2) {
                ((Actor)snapshotArray.get(n2)).moveBy(-f4, -f3);
            }
        }
        if ((stage = this.getStage()) != null && stage.getActionsRequestRendering() && this.isPressed() != this.clickListener.isPressed()) {
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    public float getPrefWidth() {
        float f2 = super.getPrefWidth();
        if (this.style.up != null) {
            f2 = Math.max(f2, this.style.up.getMinWidth());
        }
        if (this.style.down != null) {
            f2 = Math.max(f2, this.style.down.getMinWidth());
        }
        if (this.style.checked != null) {
            f2 = Math.max(f2, this.style.checked.getMinWidth());
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        float f2 = super.getPrefHeight();
        if (this.style.up != null) {
            f2 = Math.max(f2, this.style.up.getMinHeight());
        }
        if (this.style.down != null) {
            f2 = Math.max(f2, this.style.down.getMinHeight());
        }
        if (this.style.checked != null) {
            f2 = Math.max(f2, this.style.checked.getMinHeight());
        }
        return f2;
    }

    @Override
    public float getMinWidth() {
        return ((WidgetGroup)this).getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return ((WidgetGroup)this).getPrefHeight();
    }
}

