/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.StringBuilder;

public class Label
extends Widget {
    private static final Color tempColor = new Color();
    private static final GlyphLayout prefSizeLayout = new GlyphLayout();
    private Label$LabelStyle style;
    private final GlyphLayout layout = new GlyphLayout();
    private float prefWidth;
    private float prefHeight;
    private final StringBuilder text = new StringBuilder();
    private int intValue = Integer.MIN_VALUE;
    private BitmapFontCache cache;
    private int labelAlign = 8;
    private int lineAlign = 8;
    private boolean wrap;
    private float lastPrefHeight;
    private boolean prefSizeInvalid = true;
    private float fontScaleX = 1.0f;
    private float fontScaleY = 1.0f;
    private boolean fontScaleChanged = false;
    @Null
    private String ellipsis;

    public Label(@Null CharSequence charSequence, Skin skin) {
        this(charSequence, skin.get(Label$LabelStyle.class));
    }

    public Label(@Null CharSequence charSequence, Skin skin, String string) {
        this(charSequence, skin.get(string, Label$LabelStyle.class));
    }

    public Label(@Null CharSequence charSequence, Skin skin, String string, Color color) {
        this(charSequence, new Label$LabelStyle(skin.getFont(string), color));
    }

    public Label(@Null CharSequence charSequence, Skin skin, String string, String string2) {
        this(charSequence, new Label$LabelStyle(skin.getFont(string), skin.getColor(string2)));
    }

    public Label(@Null CharSequence charSequence, Label$LabelStyle label$LabelStyle) {
        if (charSequence != null) {
            this.text.append(charSequence);
        }
        this.setStyle(label$LabelStyle);
        if (charSequence != null && charSequence.length() > 0) {
            Label label = this;
            label.setSize(((Widget)label).getPrefWidth(), ((Widget)this).getPrefHeight());
        }
    }

    public void setStyle(Label$LabelStyle label$LabelStyle) {
        if (label$LabelStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        if (label$LabelStyle.font == null) {
            throw new IllegalArgumentException("Missing LabelStyle font.");
        }
        this.style = label$LabelStyle;
        this.cache = label$LabelStyle.font.newFontCache();
        this.invalidateHierarchy();
    }

    public Label$LabelStyle getStyle() {
        return this.style;
    }

    public boolean setText(int n2) {
        if (this.intValue == n2) {
            return false;
        }
        this.text.clear();
        this.text.append(n2);
        this.intValue = n2;
        this.invalidateHierarchy();
        return true;
    }

    public void setText(@Null CharSequence charSequence) {
        if (charSequence == null) {
            if (this.text.length == 0) {
                return;
            }
            this.text.clear();
        } else if (charSequence instanceof StringBuilder) {
            if (this.text.equals(charSequence)) {
                return;
            }
            this.text.clear();
            this.text.append((StringBuilder)charSequence);
        } else {
            if (this.textEquals(charSequence)) {
                return;
            }
            this.text.clear();
            this.text.append(charSequence);
        }
        this.intValue = Integer.MIN_VALUE;
        this.invalidateHierarchy();
    }

    public boolean textEquals(CharSequence charSequence) {
        int n2 = this.text.length;
        char[] cArray = this.text.chars;
        if (n2 != charSequence.length()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == charSequence.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public StringBuilder getText() {
        return this.text;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.prefSizeInvalid = true;
    }

    private void scaleAndComputePrefSize() {
        BitmapFont bitmapFont = this.cache.getFont();
        float f2 = bitmapFont.getScaleX();
        float f3 = bitmapFont.getScaleY();
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        this.computePrefSize(prefSizeLayout);
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(f2, f3);
        }
    }

    protected void computePrefSize(GlyphLayout glyphLayout) {
        this.prefSizeInvalid = false;
        if (this.wrap && this.ellipsis == null) {
            float f2 = this.getWidth();
            if (this.style.background != null) {
                f2 = Math.max(f2, this.style.background.getMinWidth()) - this.style.background.getLeftWidth() - this.style.background.getRightWidth();
            }
            glyphLayout.setText(this.cache.getFont(), this.text, Color.WHITE, f2, 8, true);
        } else {
            glyphLayout.setText(this.cache.getFont(), this.text);
        }
        this.prefWidth = glyphLayout.width;
        this.prefHeight = glyphLayout.height;
    }

    @Override
    public void layout() {
        float f2;
        float f3;
        float f4;
        boolean bl;
        BitmapFont bitmapFont = this.cache.getFont();
        float f5 = bitmapFont.getScaleX();
        float f6 = bitmapFont.getScaleY();
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        if ((bl = this.wrap && this.ellipsis == null) && (f4 = ((Widget)this).getPrefHeight()) != this.lastPrefHeight) {
            this.lastPrefHeight = f4;
            this.invalidateHierarchy();
        }
        f4 = this.getWidth();
        float f7 = this.getHeight();
        Object object = this.style.background;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (object != null) {
            f8 = object.getLeftWidth();
            f9 = object.getBottomHeight();
            f4 -= object.getLeftWidth() + object.getRightWidth();
            f7 -= object.getBottomHeight() + object.getTopHeight();
        }
        object = this.layout;
        if (bl || this.text.indexOf("\n") != -1) {
            ((GlyphLayout)object).setText(bitmapFont, this.text, 0, this.text.length, Color.WHITE, f4, this.lineAlign, bl, this.ellipsis);
            f3 = ((GlyphLayout)object).width;
            f2 = ((GlyphLayout)object).height;
            if ((this.labelAlign & 8) == 0) {
                f8 = (this.labelAlign & 0x10) != 0 ? (f8 += f4 - f3) : (f8 += (f4 - f3) / 2.0f);
            }
        } else {
            f3 = f4;
            f2 = bitmapFont.getData().capHeight;
        }
        if ((this.labelAlign & 2) != 0) {
            f9 += this.cache.getFont().isFlipped() ? 0.0f : f7 - f2;
            f9 += this.style.font.getDescent();
        } else if ((this.labelAlign & 4) != 0) {
            f9 += this.cache.getFont().isFlipped() ? f7 - f2 : 0.0f;
            f9 -= this.style.font.getDescent();
        } else {
            f9 += (f7 - f2) / 2.0f;
        }
        if (!this.cache.getFont().isFlipped()) {
            f9 += f2;
        }
        ((GlyphLayout)object).setText(bitmapFont, this.text, 0, this.text.length, Color.WHITE, f3, this.lineAlign, bl, this.ellipsis);
        this.cache.setText((GlyphLayout)object, f8, f9);
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(f5, f6);
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        Color color = tempColor.set(this.getColor());
        color.a *= f2;
        if (this.style.background != null) {
            batch.setColor(color.r, color.g, color.b, color.a);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.style.fontColor != null) {
            color.mul(this.style.fontColor);
        }
        this.cache.tint(color);
        this.cache.setPosition(this.getX(), this.getY());
        this.cache.draw(batch);
    }

    @Override
    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float f2 = this.prefWidth;
        Drawable drawable = this.style.background;
        if (drawable != null) {
            f2 = Math.max(f2 + drawable.getLeftWidth() + drawable.getRightWidth(), drawable.getMinWidth());
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float f2 = 1.0f;
        if (this.fontScaleChanged) {
            f2 = this.fontScaleY / this.style.font.getScaleY();
        }
        f2 = this.prefHeight - this.style.font.getDescent() * f2 * 2.0f;
        Drawable drawable = this.style.background;
        if (drawable != null) {
            f2 = Math.max(f2 + drawable.getTopHeight() + drawable.getBottomHeight(), drawable.getMinHeight());
        }
        return f2;
    }

    public GlyphLayout getGlyphLayout() {
        return this.layout;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
        this.invalidateHierarchy();
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public int getLabelAlign() {
        return this.labelAlign;
    }

    public int getLineAlign() {
        return this.lineAlign;
    }

    public void setAlignment(int n2) {
        int n3 = n2;
        this.setAlignment(n3, n3);
    }

    public void setAlignment(int n2, int n3) {
        this.labelAlign = n2;
        this.lineAlign = (n3 & 8) != 0 ? 8 : ((n3 & 0x10) != 0 ? 16 : 1);
        ((Widget)this).invalidate();
    }

    public void setFontScale(float f2) {
        float f3 = f2;
        this.setFontScale(f3, f3);
    }

    public void setFontScale(float f2, float f3) {
        this.fontScaleChanged = true;
        this.fontScaleX = f2;
        this.fontScaleY = f3;
        this.invalidateHierarchy();
    }

    public float getFontScaleX() {
        return this.fontScaleX;
    }

    public void setFontScaleX(float f2) {
        this.setFontScale(f2, this.fontScaleY);
    }

    public float getFontScaleY() {
        return this.fontScaleY;
    }

    public void setFontScaleY(float f2) {
        Label label = this;
        label.setFontScale(label.fontScaleX, f2);
    }

    public void setEllipsis(@Null String string) {
        this.ellipsis = string;
    }

    public void setEllipsis(boolean bl) {
        if (bl) {
            this.ellipsis = "...";
            return;
        }
        this.ellipsis = null;
    }

    protected BitmapFontCache getBitmapFontCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return (string.indexOf(36) != -1 ? "Label " : "") + string + ": " + this.text;
    }
}

