/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.List$1;
import com.badlogic.gdx.scenes.scene2d.ui.List$2;
import com.badlogic.gdx.scenes.scene2d.ui.List$ListStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class List<T>
extends Widget
implements Cullable {
    List$ListStyle style;
    final Array<T> items = new Array();
    ArraySelection<T> selection = new ArraySelection<T>(this.items);
    private Rectangle cullingArea;
    private float prefWidth;
    private float prefHeight;
    float itemHeight;
    private int alignment = 8;
    int pressedIndex = -1;
    int overIndex = -1;
    private InputListener keyListener;
    boolean typeToSelect;

    public List(Skin skin) {
        this(skin.get(List$ListStyle.class));
    }

    public List(Skin skin, String string) {
        this(skin.get(string, List$ListStyle.class));
    }

    public List(List$ListStyle list$ListStyle) {
        this.selection.setActor(this);
        this.selection.setRequired(true);
        this.setStyle(list$ListStyle);
        List list = this;
        list.setSize(((Widget)list).getPrefWidth(), ((Widget)this).getPrefHeight());
        this.keyListener = new List$1(this);
        this.addListener(this.keyListener);
        this.addListener(new List$2(this));
    }

    public void setStyle(List$ListStyle list$ListStyle) {
        if (list$ListStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = list$ListStyle;
        this.invalidateHierarchy();
    }

    public List$ListStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        BitmapFont bitmapFont = this.style.font;
        Drawable drawable = this.style.selection;
        this.itemHeight = bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
        this.itemHeight += drawable.getTopHeight() + drawable.getBottomHeight();
        this.prefWidth = 0.0f;
        Pool<GlyphLayout> pool = Pools.get(GlyphLayout.class);
        GlyphLayout glyphLayout = pool.obtain();
        for (int i2 = 0; i2 < this.items.size; ++i2) {
            List list = this;
            glyphLayout.setText(bitmapFont, list.toString(list.items.get(i2)));
            this.prefWidth = Math.max(glyphLayout.width, this.prefWidth);
        }
        pool.free(glyphLayout);
        this.prefWidth += drawable.getLeftWidth() + drawable.getRightWidth();
        this.prefHeight = (float)this.items.size * this.itemHeight;
        Drawable drawable2 = this.style.background;
        if (drawable2 != null) {
            this.prefWidth = Math.max(this.prefWidth + drawable2.getLeftWidth() + drawable2.getRightWidth(), drawable2.getMinWidth());
            this.prefHeight = Math.max(this.prefHeight + drawable2.getTopHeight() + drawable2.getBottomHeight(), drawable2.getMinHeight());
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        float f3;
        float f4;
        this.validate();
        this.drawBackground(batch, f2);
        BitmapFont bitmapFont = this.style.font;
        Drawable drawable = this.style.selection;
        Color color = this.style.fontColorSelected;
        Color color2 = this.style.fontColorUnselected;
        Color color3 = this.getColor();
        batch.setColor(color3.r, color3.g, color3.b, color3.a * f2);
        float f5 = this.getX();
        float f6 = this.getY();
        float f7 = this.getWidth();
        float f8 = f4 = this.getHeight();
        Drawable drawable2 = this.style.background;
        if (drawable2 != null) {
            f3 = drawable2.getLeftWidth();
            f5 += f3;
            f8 = f4 - drawable2.getTopHeight();
            f7 -= f3 + drawable2.getRightWidth();
        }
        f3 = drawable.getLeftWidth();
        f4 = f7 - f3 - drawable.getRightWidth();
        float f9 = drawable.getTopHeight() - bitmapFont.getDescent();
        bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * f2);
        for (int i2 = 0; i2 < this.items.size; ++i2) {
            if (this.cullingArea == null || f8 - this.itemHeight <= this.cullingArea.y + this.cullingArea.height && f8 >= this.cullingArea.y) {
                T t2 = this.items.get(i2);
                boolean bl = this.selection.contains(t2);
                Drawable drawable3 = null;
                if (this.pressedIndex == i2 && this.style.down != null) {
                    drawable3 = this.style.down;
                } else if (bl) {
                    drawable3 = drawable;
                    bitmapFont.setColor(color.r, color.g, color.b, color.a * f2);
                } else if (this.overIndex == i2 && this.style.over != null) {
                    drawable3 = this.style.over;
                }
                this.drawSelection(batch, drawable3, f5, f6 + f8 - this.itemHeight, f7, this.itemHeight);
                this.drawItem(batch, bitmapFont, i2, t2, f5 + f3, f6 + f8 - f9, f4);
                if (bl) {
                    bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * f2);
                }
            } else if (f8 < this.cullingArea.y) break;
            f8 -= this.itemHeight;
        }
    }

    protected void drawSelection(Batch batch, @Null Drawable drawable, float f2, float f3, float f4, float f5) {
        if (drawable != null) {
            drawable.draw(batch, f2, f3, f4, f5);
        }
    }

    protected void drawBackground(Batch batch, float f2) {
        if (this.style.background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * f2);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected GlyphLayout drawItem(Batch batch, BitmapFont bitmapFont, int n2, T t2, float f2, float f3, float f4) {
        String string = this.toString(t2);
        return bitmapFont.draw(batch, string, f2, f3, 0, string.length(), f4, this.alignment, false, "...");
    }

    public ArraySelection<T> getSelection() {
        return this.selection;
    }

    public void setSelection(ArraySelection<T> arraySelection) {
        this.selection = arraySelection;
    }

    @Null
    public T getSelected() {
        return this.selection.first();
    }

    public void setSelected(@Null T t2) {
        if (this.items.contains(t2, false)) {
            this.selection.set(t2);
            return;
        }
        if (this.selection.getRequired() && this.items.size > 0) {
            this.selection.set(this.items.first());
            return;
        }
        this.selection.clear();
    }

    public int getSelectedIndex() {
        OrderedSet orderedSet = this.selection.items();
        if (orderedSet.size == 0) {
            return -1;
        }
        return this.items.indexOf(orderedSet.first(), false);
    }

    public void setSelectedIndex(int n2) {
        if (n2 < -1 || n2 >= this.items.size) {
            throw new IllegalArgumentException("index must be >= -1 and < " + this.items.size + ": " + n2);
        }
        if (n2 == -1) {
            this.selection.clear();
            return;
        }
        this.selection.set(this.items.get(n2));
    }

    public T getOverItem() {
        if (this.overIndex == -1) {
            return null;
        }
        return this.items.get(this.overIndex);
    }

    public T getPressedItem() {
        if (this.pressedIndex == -1) {
            return null;
        }
        return this.items.get(this.pressedIndex);
    }

    @Null
    public T getItemAt(float f2) {
        int n2 = this.getItemIndexAt(f2);
        if (n2 == -1) {
            return null;
        }
        return this.items.get(n2);
    }

    public int getItemIndexAt(float f2) {
        int n2;
        float f3 = this.getHeight();
        Drawable drawable = this.style.background;
        if (drawable != null) {
            f3 -= drawable.getTopHeight() + drawable.getBottomHeight();
            f2 -= drawable.getBottomHeight();
        }
        if ((n2 = (int)((f3 - f2) / this.itemHeight)) < 0 || n2 >= this.items.size) {
            return -1;
        }
        return n2;
    }

    public void setItems(T ... TArray) {
        if (TArray == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        float f3 = ((Widget)this).getPrefHeight();
        this.items.clear();
        this.items.addAll(TArray);
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.validate();
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth() || f3 != ((Widget)this).getPrefHeight()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(Array array) {
        if (array == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        float f3 = ((Widget)this).getPrefHeight();
        if (array != this.items) {
            this.items.clear();
            this.items.addAll(array);
        }
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.validate();
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth() || f3 != ((Widget)this).getPrefHeight()) {
            this.invalidateHierarchy();
        }
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.clear();
        this.invalidateHierarchy();
    }

    public Array<T> getItems() {
        return this.items;
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    public String toString(T t2) {
        return t2.toString();
    }

    @Override
    public void setCullingArea(@Null Rectangle rectangle) {
        this.cullingArea = rectangle;
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setTypeToSelect(boolean bl) {
        this.typeToSelect = bl;
    }

    public InputListener getKeyListener() {
        return this.keyListener;
    }
}

