/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$1;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$2;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$3;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$ScrollPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Null;

public class ScrollPane
extends WidgetGroup {
    private ScrollPane$ScrollPaneStyle style;
    private Actor actor;
    final Rectangle actorArea = new Rectangle();
    final Rectangle hScrollBounds = new Rectangle();
    final Rectangle hKnobBounds = new Rectangle();
    final Rectangle vScrollBounds = new Rectangle();
    final Rectangle vKnobBounds = new Rectangle();
    private final Rectangle actorCullingArea = new Rectangle();
    private ActorGestureListener flickScrollListener;
    boolean scrollX;
    boolean scrollY;
    boolean vScrollOnRight = true;
    boolean hScrollOnBottom = true;
    float amountX;
    float amountY;
    float visualAmountX;
    float visualAmountY;
    float maxX;
    float maxY;
    boolean touchScrollH;
    boolean touchScrollV;
    final Vector2 lastPoint = new Vector2();
    boolean fadeScrollBars = true;
    boolean smoothScrolling = true;
    boolean scrollBarTouch = true;
    float fadeAlpha;
    float fadeAlphaSeconds = 1.0f;
    float fadeDelay;
    float fadeDelaySeconds = 1.0f;
    boolean cancelTouchFocus = true;
    boolean flickScroll = true;
    float flingTime = 1.0f;
    float flingTimer;
    float velocityX;
    float velocityY;
    private boolean overscrollX = true;
    private boolean overscrollY = true;
    private float overscrollDistance = 50.0f;
    private float overscrollSpeedMin = 30.0f;
    private float overscrollSpeedMax = 200.0f;
    private boolean forceScrollX;
    private boolean forceScrollY;
    boolean disableX;
    boolean disableY;
    private boolean clamp = true;
    private boolean scrollbarsOnTop;
    private boolean variableSizeKnobs = true;
    int draggingPointer = -1;

    public ScrollPane(@Null Actor actor) {
        this(actor, new ScrollPane$ScrollPaneStyle());
    }

    public ScrollPane(@Null Actor actor, Skin skin) {
        this(actor, skin.get(ScrollPane$ScrollPaneStyle.class));
    }

    public ScrollPane(@Null Actor actor, Skin skin, String string) {
        this(actor, skin.get(string, ScrollPane$ScrollPaneStyle.class));
    }

    public ScrollPane(@Null Actor actor, ScrollPane$ScrollPaneStyle scrollPane$ScrollPaneStyle) {
        if (scrollPane$ScrollPaneStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = scrollPane$ScrollPaneStyle;
        this.setActor(actor);
        this.setSize(150.0f, 150.0f);
        this.addCaptureListener();
        this.flickScrollListener = this.getFlickScrollListener();
        ScrollPane scrollPane = this;
        scrollPane.addListener(scrollPane.flickScrollListener);
        this.addScrollListener();
    }

    protected void addCaptureListener() {
        this.addCaptureListener(new ScrollPane$1(this));
    }

    protected ActorGestureListener getFlickScrollListener() {
        return new ScrollPane$2(this);
    }

    protected void addScrollListener() {
        this.addListener(new ScrollPane$3(this));
    }

    public void setScrollbarsVisible(boolean bl) {
        if (bl) {
            this.fadeAlpha = this.fadeAlphaSeconds;
            this.fadeDelay = this.fadeDelaySeconds;
            return;
        }
        this.fadeAlpha = 0.0f;
        this.fadeDelay = 0.0f;
    }

    public void cancelTouchFocus() {
        Stage stage = this.getStage();
        if (stage != null) {
            stage.cancelTouchFocusExcept(this.flickScrollListener, this);
        }
    }

    public void cancel() {
        this.draggingPointer = -1;
        this.touchScrollH = false;
        this.touchScrollV = false;
        this.flickScrollListener.getGestureDetector().cancel();
    }

    void clamp() {
        if (!this.clamp) {
            return;
        }
        ScrollPane scrollPane = this;
        scrollPane.scrollX(scrollPane.overscrollX ? MathUtils.clamp(this.amountX, -this.overscrollDistance, this.maxX + this.overscrollDistance) : MathUtils.clamp(this.amountX, 0.0f, this.maxX));
        ScrollPane scrollPane2 = this;
        scrollPane2.scrollY(scrollPane2.overscrollY ? MathUtils.clamp(this.amountY, -this.overscrollDistance, this.maxY + this.overscrollDistance) : MathUtils.clamp(this.amountY, 0.0f, this.maxY));
    }

    public void setStyle(ScrollPane$ScrollPaneStyle scrollPane$ScrollPaneStyle) {
        if (scrollPane$ScrollPaneStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = scrollPane$ScrollPaneStyle;
        this.invalidateHierarchy();
    }

    public ScrollPane$ScrollPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void act(float f2) {
        Stage stage;
        super.act(f2);
        boolean bl = this.flickScrollListener.getGestureDetector().isPanning();
        boolean bl2 = false;
        if (this.fadeAlpha > 0.0f && this.fadeScrollBars && !bl && !this.touchScrollH && !this.touchScrollV) {
            this.fadeDelay -= f2;
            if (this.fadeDelay <= 0.0f) {
                this.fadeAlpha = Math.max(0.0f, this.fadeAlpha - f2);
            }
            bl2 = true;
        }
        if (this.flingTimer > 0.0f) {
            this.setScrollbarsVisible(true);
            float f3 = this.flingTimer / this.flingTime;
            this.amountX -= this.velocityX * f3 * f2;
            this.amountY -= this.velocityY * f3 * f2;
            this.clamp();
            if (this.amountX == -this.overscrollDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountX >= this.maxX + this.overscrollDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountY == -this.overscrollDistance) {
                this.velocityY = 0.0f;
            }
            if (this.amountY >= this.maxY + this.overscrollDistance) {
                this.velocityY = 0.0f;
            }
            this.flingTimer -= f2;
            if (this.flingTimer <= 0.0f) {
                this.velocityX = 0.0f;
                this.velocityY = 0.0f;
            }
            bl2 = true;
        }
        if (this.smoothScrolling && this.flingTimer <= 0.0f && !bl && (!this.touchScrollH || this.scrollX && this.maxX / (this.hScrollBounds.width - this.hKnobBounds.width) > this.actorArea.width * 0.1f) && (!this.touchScrollV || this.scrollY && this.maxY / (this.vScrollBounds.height - this.vKnobBounds.height) > this.actorArea.height * 0.1f)) {
            if (this.visualAmountX != this.amountX) {
                if (this.visualAmountX < this.amountX) {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollX(Math.min(scrollPane.amountX, this.visualAmountX + Math.max(200.0f * f2, (this.amountX - this.visualAmountX) * 7.0f * f2)));
                } else {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollX(Math.max(scrollPane.amountX, this.visualAmountX - Math.max(200.0f * f2, (this.visualAmountX - this.amountX) * 7.0f * f2)));
                }
                bl2 = true;
            }
            if (this.visualAmountY != this.amountY) {
                if (this.visualAmountY < this.amountY) {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollY(Math.min(scrollPane.amountY, this.visualAmountY + Math.max(200.0f * f2, (this.amountY - this.visualAmountY) * 7.0f * f2)));
                } else {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollY(Math.max(scrollPane.amountY, this.visualAmountY - Math.max(200.0f * f2, (this.visualAmountY - this.amountY) * 7.0f * f2)));
                }
                bl2 = true;
            }
        } else {
            if (this.visualAmountX != this.amountX) {
                ScrollPane scrollPane = this;
                scrollPane.visualScrollX(scrollPane.amountX);
            }
            if (this.visualAmountY != this.amountY) {
                ScrollPane scrollPane = this;
                scrollPane.visualScrollY(scrollPane.amountY);
            }
        }
        if (!bl) {
            if (this.overscrollX && this.scrollX) {
                if (this.amountX < 0.0f) {
                    this.setScrollbarsVisible(true);
                    this.amountX += (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -this.amountX / this.overscrollDistance) * f2;
                    if (this.amountX > 0.0f) {
                        this.scrollX(0.0f);
                    }
                    bl2 = true;
                } else if (this.amountX > this.maxX) {
                    this.setScrollbarsVisible(true);
                    this.amountX -= (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -(this.maxX - this.amountX) / this.overscrollDistance) * f2;
                    if (this.amountX < this.maxX) {
                        ScrollPane scrollPane = this;
                        scrollPane.scrollX(scrollPane.maxX);
                    }
                    bl2 = true;
                }
            }
            if (this.overscrollY && this.scrollY) {
                if (this.amountY < 0.0f) {
                    this.setScrollbarsVisible(true);
                    this.amountY += (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -this.amountY / this.overscrollDistance) * f2;
                    if (this.amountY > 0.0f) {
                        this.scrollY(0.0f);
                    }
                    bl2 = true;
                } else if (this.amountY > this.maxY) {
                    this.setScrollbarsVisible(true);
                    this.amountY -= (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -(this.maxY - this.amountY) / this.overscrollDistance) * f2;
                    if (this.amountY < this.maxY) {
                        ScrollPane scrollPane = this;
                        scrollPane.scrollY(scrollPane.maxY);
                    }
                    bl2 = true;
                }
            }
        }
        if (bl2 && (stage = this.getStage()) != null && stage.getActionsRequestRendering()) {
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    public void layout() {
        float f2;
        float f3;
        Drawable drawable = this.style.background;
        Drawable drawable2 = this.style.hScrollKnob;
        Drawable drawable3 = this.style.vScrollKnob;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (drawable != null) {
            f4 = drawable.getLeftWidth();
            f5 = drawable.getRightWidth();
            f6 = drawable.getTopHeight();
            f7 = drawable.getBottomHeight();
        }
        float f8 = this.getWidth();
        float f9 = this.getHeight();
        this.actorArea.set(f4, f7, f8 - f4 - f5, f9 - f6 - f7);
        if (this.actor == null) {
            return;
        }
        float f10 = 0.0f;
        float f11 = 0.0f;
        if (drawable2 != null) {
            f10 = drawable2.getMinHeight();
        }
        if (this.style.hScroll != null) {
            f10 = Math.max(f10, this.style.hScroll.getMinHeight());
        }
        if (drawable3 != null) {
            f11 = drawable3.getMinWidth();
        }
        if (this.style.vScroll != null) {
            f11 = Math.max(f11, this.style.vScroll.getMinWidth());
        }
        if (this.actor instanceof Layout) {
            Layout layout = (Layout)((Object)this.actor);
            f3 = layout.getPrefWidth();
            f2 = layout.getPrefHeight();
        } else {
            f3 = this.actor.getWidth();
            f2 = this.actor.getHeight();
        }
        this.scrollX = this.forceScrollX || f3 > this.actorArea.width && !this.disableX;
        boolean bl = this.scrollY = this.forceScrollY || f2 > this.actorArea.height && !this.disableY;
        if (!this.scrollbarsOnTop) {
            if (this.scrollY) {
                this.actorArea.width -= f11;
                if (!this.vScrollOnRight) {
                    this.actorArea.x += f11;
                }
                if (!this.scrollX && f3 > this.actorArea.width && !this.disableX) {
                    this.scrollX = true;
                }
            }
            if (this.scrollX) {
                this.actorArea.height -= f10;
                if (this.hScrollOnBottom) {
                    this.actorArea.y += f10;
                }
                if (!this.scrollY && f2 > this.actorArea.height && !this.disableY) {
                    this.scrollY = true;
                    this.actorArea.width -= f11;
                    if (!this.vScrollOnRight) {
                        this.actorArea.x += f11;
                    }
                }
            }
        }
        f3 = this.disableX ? this.actorArea.width : Math.max(this.actorArea.width, f3);
        f2 = this.disableY ? this.actorArea.height : Math.max(this.actorArea.height, f2);
        this.maxX = f3 - this.actorArea.width;
        this.maxY = f2 - this.actorArea.height;
        ScrollPane scrollPane = this;
        scrollPane.scrollX(MathUtils.clamp(scrollPane.amountX, 0.0f, this.maxX));
        ScrollPane scrollPane2 = this;
        scrollPane2.scrollY(MathUtils.clamp(scrollPane2.amountY, 0.0f, this.maxY));
        if (this.scrollX) {
            if (drawable2 != null) {
                float f12 = this.scrollbarsOnTop ? f4 : this.actorArea.x;
                f6 = this.hScrollOnBottom ? f7 : f9 - f6 - f10;
                this.hScrollBounds.set(f12, f6, this.actorArea.width, f10);
                if (this.scrollY && this.scrollbarsOnTop) {
                    this.hScrollBounds.width -= f11;
                    if (!this.vScrollOnRight) {
                        this.hScrollBounds.x += f11;
                    }
                }
                this.hKnobBounds.width = this.variableSizeKnobs ? Math.max(drawable2.getMinWidth(), (float)((int)(this.hScrollBounds.width * this.actorArea.width / f3))) : drawable2.getMinWidth();
                if (this.hKnobBounds.width > f3) {
                    this.hKnobBounds.width = 0.0f;
                }
                this.hKnobBounds.height = drawable2.getMinHeight();
                this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getScrollPercentX()));
                this.hKnobBounds.y = this.hScrollBounds.y;
            } else {
                this.hScrollBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.hKnobBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.scrollY) {
            if (drawable3 != null) {
                float f13 = this.vScrollOnRight ? f8 - f5 - f11 : f4;
                f6 = this.scrollbarsOnTop ? f7 : this.actorArea.y;
                this.vScrollBounds.set(f13, f6, f11, this.actorArea.height);
                if (this.scrollX && this.scrollbarsOnTop) {
                    this.vScrollBounds.height -= f10;
                    if (this.hScrollOnBottom) {
                        this.vScrollBounds.y += f10;
                    }
                }
                this.vKnobBounds.width = drawable3.getMinWidth();
                this.vKnobBounds.height = this.variableSizeKnobs ? Math.max(drawable3.getMinHeight(), (float)((int)(this.vScrollBounds.height * this.actorArea.height / f2))) : drawable3.getMinHeight();
                if (this.vKnobBounds.height > f2) {
                    this.vKnobBounds.height = 0.0f;
                }
                this.vKnobBounds.x = this.vScrollOnRight ? f8 - f5 - drawable3.getMinWidth() : f4;
                this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getScrollPercentY())));
            } else {
                this.vScrollBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.vKnobBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        this.updateActorPosition();
        if (this.actor instanceof Layout) {
            this.actor.setSize(f3, f2);
            ((Layout)((Object)this.actor)).validate();
        }
    }

    private void updateActorPosition() {
        float f2 = this.actorArea.x - (float)(this.scrollX ? (int)this.visualAmountX : 0);
        float f3 = this.actorArea.y - (float)((int)(this.scrollY ? this.maxY - this.visualAmountY : this.maxY));
        this.actor.setPosition(f2, f3);
        if (this.actor instanceof Cullable) {
            this.actorCullingArea.x = this.actorArea.x - f2;
            this.actorCullingArea.y = this.actorArea.y - f3;
            this.actorCullingArea.width = this.actorArea.width;
            this.actorCullingArea.height = this.actorArea.height;
            ((Cullable)((Object)this.actor)).setCullingArea(this.actorCullingArea);
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        if (this.actor == null) {
            return;
        }
        this.validate();
        this.applyTransform(batch, this.computeTransform());
        if (this.scrollX) {
            this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getVisualScrollPercentX()));
        }
        if (this.scrollY) {
            this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getVisualScrollPercentY())));
        }
        this.updateActorPosition();
        Color color = this.getColor();
        float f3 = color.a * f2;
        if (this.style.background != null) {
            batch.setColor(color.r, color.g, color.b, f3);
            this.style.background.draw(batch, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        batch.flush();
        ScrollPane scrollPane = this;
        if (scrollPane.clipBegin(scrollPane.actorArea.x, this.actorArea.y, this.actorArea.width, this.actorArea.height)) {
            this.drawChildren(batch, f2);
            batch.flush();
            this.clipEnd();
        }
        batch.setColor(color.r, color.g, color.b, f3);
        if (this.fadeScrollBars) {
            f3 *= Interpolation.fade.apply(this.fadeAlpha / this.fadeAlphaSeconds);
        }
        this.drawScrollBars(batch, color.r, color.g, color.b, f3);
        this.resetTransform(batch);
    }

    protected void drawScrollBars(Batch batch, float f2, float f3, float f4, float f5) {
        boolean bl;
        if (f5 <= 0.0f) {
            return;
        }
        batch.setColor(f2, f3, f4, f5);
        boolean bl2 = this.scrollX && this.hKnobBounds.width > 0.0f;
        boolean bl3 = bl = this.scrollY && this.vKnobBounds.height > 0.0f;
        if (bl2) {
            if (bl && this.style.corner != null) {
                this.style.corner.draw(batch, this.hScrollBounds.x + this.hScrollBounds.width, this.hScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.y);
            }
            if (this.style.hScroll != null) {
                this.style.hScroll.draw(batch, this.hScrollBounds.x, this.hScrollBounds.y, this.hScrollBounds.width, this.hScrollBounds.height);
            }
            if (this.style.hScrollKnob != null) {
                this.style.hScrollKnob.draw(batch, this.hKnobBounds.x, this.hKnobBounds.y, this.hKnobBounds.width, this.hKnobBounds.height);
            }
        }
        if (bl) {
            if (this.style.vScroll != null) {
                this.style.vScroll.draw(batch, this.vScrollBounds.x, this.vScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.height);
            }
            if (this.style.vScrollKnob != null) {
                this.style.vScrollKnob.draw(batch, this.vKnobBounds.x, this.vKnobBounds.y, this.vKnobBounds.width, this.vKnobBounds.height);
            }
        }
    }

    public void fling(float f2, float f3, float f4) {
        this.flingTimer = f2;
        this.velocityX = f3;
        this.velocityY = f4;
    }

    @Override
    public float getPrefWidth() {
        float f2 = 0.0f;
        if (this.actor instanceof Layout) {
            f2 = ((Layout)((Object)this.actor)).getPrefWidth();
        } else if (this.actor != null) {
            f2 = this.actor.getWidth();
        }
        Drawable drawable = this.style.background;
        if (drawable != null) {
            f2 = Math.max(f2 + drawable.getLeftWidth() + drawable.getRightWidth(), drawable.getMinWidth());
        }
        if (this.scrollY) {
            float f3 = 0.0f;
            if (this.style.vScrollKnob != null) {
                f3 = this.style.vScrollKnob.getMinWidth();
            }
            if (this.style.vScroll != null) {
                f3 = Math.max(f3, this.style.vScroll.getMinWidth());
            }
            f2 += f3;
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        float f2 = 0.0f;
        if (this.actor instanceof Layout) {
            f2 = ((Layout)((Object)this.actor)).getPrefHeight();
        } else if (this.actor != null) {
            f2 = this.actor.getHeight();
        }
        Drawable drawable = this.style.background;
        if (drawable != null) {
            f2 = Math.max(f2 + drawable.getTopHeight() + drawable.getBottomHeight(), drawable.getMinHeight());
        }
        if (this.scrollX) {
            float f3 = 0.0f;
            if (this.style.hScrollKnob != null) {
                f3 = this.style.hScrollKnob.getMinHeight();
            }
            if (this.style.hScroll != null) {
                f3 = Math.max(f3, this.style.hScroll.getMinHeight());
            }
            f2 += f3;
        }
        return f2;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setActor(@Null Actor actor) {
        if (this.actor == this) {
            throw new IllegalArgumentException("actor cannot be the ScrollPane.");
        }
        if (this.actor != null) {
            ScrollPane scrollPane = this;
            super.removeActor(scrollPane.actor);
        }
        this.actor = actor;
        if (actor != null) {
            super.addActor(actor);
        }
    }

    @Null
    public Actor getActor() {
        return this.actor;
    }

    @Deprecated
    public void setWidget(@Null Actor actor) {
        this.setActor(actor);
    }

    @Deprecated
    @Null
    public Actor getWidget() {
        return this.actor;
    }

    @Override
    @Deprecated
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    @Deprecated
    public void addActorAt(int n2, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    @Deprecated
    public void addActorBefore(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    @Deprecated
    public void addActorAfter(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor != this.actor) {
            return false;
        }
        this.setActor(null);
        return true;
    }

    @Override
    public boolean removeActor(Actor actor, boolean bl) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor != this.actor) {
            return false;
        }
        this.actor = null;
        return super.removeActor(actor, bl);
    }

    @Override
    public Actor removeActorAt(int n2, boolean bl) {
        Actor actor = super.removeActorAt(n2, bl);
        if (actor == this.actor) {
            this.actor = null;
        }
        return actor;
    }

    @Override
    @Null
    public Actor hit(float f2, float f3, boolean bl) {
        if (f2 < 0.0f || f2 >= this.getWidth() || f3 < 0.0f || f3 >= this.getHeight()) {
            return null;
        }
        if (bl && this.getTouchable() == Touchable.enabled && this.isVisible()) {
            if (this.scrollX && this.touchScrollH && this.hScrollBounds.contains(f2, f3)) {
                return this;
            }
            if (this.scrollY && this.touchScrollV && this.vScrollBounds.contains(f2, f3)) {
                return this;
            }
        }
        return super.hit(f2, f3, bl);
    }

    protected void scrollX(float f2) {
        this.amountX = f2;
    }

    protected void scrollY(float f2) {
        this.amountY = f2;
    }

    protected void visualScrollX(float f2) {
        this.visualAmountX = f2;
    }

    protected void visualScrollY(float f2) {
        this.visualAmountY = f2;
    }

    protected float getMouseWheelX() {
        return Math.min(this.actorArea.width, Math.max(this.actorArea.width * 0.9f, this.maxX * 0.1f) / 4.0f);
    }

    protected float getMouseWheelY() {
        return Math.min(this.actorArea.height, Math.max(this.actorArea.height * 0.9f, this.maxY * 0.1f) / 4.0f);
    }

    public void setScrollX(float f2) {
        this.scrollX(MathUtils.clamp(f2, 0.0f, this.maxX));
    }

    public float getScrollX() {
        return this.amountX;
    }

    public void setScrollY(float f2) {
        this.scrollY(MathUtils.clamp(f2, 0.0f, this.maxY));
    }

    public float getScrollY() {
        return this.amountY;
    }

    public void updateVisualScroll() {
        this.visualAmountX = this.amountX;
        this.visualAmountY = this.amountY;
    }

    public float getVisualScrollX() {
        if (!this.scrollX) {
            return 0.0f;
        }
        return this.visualAmountX;
    }

    public float getVisualScrollY() {
        if (!this.scrollY) {
            return 0.0f;
        }
        return this.visualAmountY;
    }

    public float getVisualScrollPercentX() {
        if (this.maxX == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.visualAmountX / this.maxX, 0.0f, 1.0f);
    }

    public float getVisualScrollPercentY() {
        if (this.maxY == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.visualAmountY / this.maxY, 0.0f, 1.0f);
    }

    public float getScrollPercentX() {
        if (this.maxX == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.amountX / this.maxX, 0.0f, 1.0f);
    }

    public void setScrollPercentX(float f2) {
        ScrollPane scrollPane = this;
        scrollPane.scrollX(scrollPane.maxX * MathUtils.clamp(f2, 0.0f, 1.0f));
    }

    public float getScrollPercentY() {
        if (this.maxY == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.amountY / this.maxY, 0.0f, 1.0f);
    }

    public void setScrollPercentY(float f2) {
        ScrollPane scrollPane = this;
        scrollPane.scrollY(scrollPane.maxY * MathUtils.clamp(f2, 0.0f, 1.0f));
    }

    public void setFlickScroll(boolean bl) {
        if (this.flickScroll == bl) {
            return;
        }
        this.flickScroll = bl;
        if (bl) {
            ScrollPane scrollPane = this;
            scrollPane.addListener(scrollPane.flickScrollListener);
        } else {
            ScrollPane scrollPane = this;
            scrollPane.removeListener(scrollPane.flickScrollListener);
        }
        this.invalidate();
    }

    public void setFlickScrollTapSquareSize(float f2) {
        this.flickScrollListener.getGestureDetector().setTapSquareSize(f2);
    }

    public void scrollTo(float f2, float f3, float f4, float f5) {
        this.scrollTo(f2, f3, f4, f5, false, false);
    }

    public void scrollTo(float f2, float f3, float f4, float f5, boolean bl, boolean bl2) {
        this.validate();
        float f6 = this.amountX;
        if (bl) {
            f6 = f2 + (f4 - this.actorArea.width) / 2.0f;
        } else {
            float f7 = f2;
            f6 = MathUtils.clamp(f6, f7, f7 + f4 - this.actorArea.width);
        }
        this.scrollX(MathUtils.clamp(f6, 0.0f, this.maxX));
        f2 = this.amountY;
        f3 = this.maxY - f3;
        f2 = bl2 ? f3 + (this.actorArea.height + f5) / 2.0f : MathUtils.clamp(f2, f3 + f5, f3 + this.actorArea.height);
        this.scrollY(MathUtils.clamp(f2, 0.0f, this.maxY));
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getScrollBarHeight() {
        if (!this.scrollX) {
            return 0.0f;
        }
        float f2 = 0.0f;
        if (this.style.hScrollKnob != null) {
            f2 = this.style.hScrollKnob.getMinHeight();
        }
        if (this.style.hScroll != null) {
            f2 = Math.max(f2, this.style.hScroll.getMinHeight());
        }
        return f2;
    }

    public float getScrollBarWidth() {
        if (!this.scrollY) {
            return 0.0f;
        }
        float f2 = 0.0f;
        if (this.style.vScrollKnob != null) {
            f2 = this.style.vScrollKnob.getMinWidth();
        }
        if (this.style.vScroll != null) {
            f2 = Math.max(f2, this.style.vScroll.getMinWidth());
        }
        return f2;
    }

    public float getScrollWidth() {
        return this.actorArea.width;
    }

    public float getScrollHeight() {
        return this.actorArea.height;
    }

    public boolean isScrollX() {
        return this.scrollX;
    }

    public boolean isScrollY() {
        return this.scrollY;
    }

    public void setScrollingDisabled(boolean bl, boolean bl2) {
        if (bl == this.disableX && bl2 == this.disableY) {
            return;
        }
        this.disableX = bl;
        this.disableY = bl2;
        this.invalidate();
    }

    public boolean isScrollingDisabledX() {
        return this.disableX;
    }

    public boolean isScrollingDisabledY() {
        return this.disableY;
    }

    public boolean isLeftEdge() {
        return !this.scrollX || this.amountX <= 0.0f;
    }

    public boolean isRightEdge() {
        return !this.scrollX || this.amountX >= this.maxX;
    }

    public boolean isTopEdge() {
        return !this.scrollY || this.amountY <= 0.0f;
    }

    public boolean isBottomEdge() {
        return !this.scrollY || this.amountY >= this.maxY;
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public boolean isPanning() {
        return this.flickScrollListener.getGestureDetector().isPanning();
    }

    public boolean isFlinging() {
        return this.flingTimer > 0.0f;
    }

    public void setVelocityX(float f2) {
        this.velocityX = f2;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public void setVelocityY(float f2) {
        this.velocityY = f2;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public void setOverscroll(boolean bl, boolean bl2) {
        this.overscrollX = bl;
        this.overscrollY = bl2;
    }

    public void setupOverscroll(float f2, float f3, float f4) {
        this.overscrollDistance = f2;
        this.overscrollSpeedMin = f3;
        this.overscrollSpeedMax = f4;
    }

    public float getOverscrollDistance() {
        return this.overscrollDistance;
    }

    public void setForceScroll(boolean bl, boolean bl2) {
        this.forceScrollX = bl;
        this.forceScrollY = bl2;
    }

    public boolean isForceScrollX() {
        return this.forceScrollX;
    }

    public boolean isForceScrollY() {
        return this.forceScrollY;
    }

    public void setFlingTime(float f2) {
        this.flingTime = f2;
    }

    public void setClamp(boolean bl) {
        this.clamp = bl;
    }

    public void setScrollBarPositions(boolean bl, boolean bl2) {
        this.hScrollOnBottom = bl;
        this.vScrollOnRight = bl2;
    }

    public void setFadeScrollBars(boolean bl) {
        if (this.fadeScrollBars == bl) {
            return;
        }
        this.fadeScrollBars = bl;
        if (!bl) {
            this.fadeAlpha = this.fadeAlphaSeconds;
        }
        this.invalidate();
    }

    public void setupFadeScrollBars(float f2, float f3) {
        this.fadeAlphaSeconds = f2;
        this.fadeDelaySeconds = f3;
    }

    public boolean getFadeScrollBars() {
        return this.fadeScrollBars;
    }

    public void setScrollBarTouch(boolean bl) {
        this.scrollBarTouch = bl;
    }

    public void setSmoothScrolling(boolean bl) {
        this.smoothScrolling = bl;
    }

    public void setScrollbarsOnTop(boolean bl) {
        this.scrollbarsOnTop = bl;
        this.invalidate();
    }

    public boolean getVariableSizeKnobs() {
        return this.variableSizeKnobs;
    }

    public void setVariableSizeKnobs(boolean bl) {
        this.variableSizeKnobs = bl;
    }

    public void setCancelTouchFocus(boolean bl) {
        this.cancelTouchFocus = bl;
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
        this.applyTransform(shapeRenderer, this.computeTransform());
        ScrollPane scrollPane = this;
        if (scrollPane.clipBegin(scrollPane.actorArea.x, this.actorArea.y, this.actorArea.width, this.actorArea.height)) {
            this.drawDebugChildren(shapeRenderer);
            shapeRenderer.flush();
            this.clipEnd();
        }
        this.resetTransform(shapeRenderer);
    }
}

