/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxScrollPane$1;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxScrollPane$2;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxScrollPane$3;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxScrollPane$4;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class SelectBox$SelectBoxScrollPane<T>
extends ScrollPane {
    final SelectBox<T> selectBox;
    int maxListCount;
    private final Vector2 stagePosition = new Vector2();
    final List<T> list;
    private InputListener hideListener;
    private Actor previousScrollFocus;

    public SelectBox$SelectBoxScrollPane(SelectBox<T> selectBox) {
        super(null, selectBox.style.scrollStyle);
        this.selectBox = selectBox;
        this.setOverscroll(false, false);
        this.setFadeScrollBars(false);
        this.setScrollingDisabled(true, false);
        this.list = this.newList();
        this.list.setTouchable(Touchable.disabled);
        this.list.setTypeToSelect(true);
        SelectBox$SelectBoxScrollPane selectBox$SelectBoxScrollPane = this;
        selectBox$SelectBoxScrollPane.setActor(selectBox$SelectBoxScrollPane.list);
        this.list.addListener(new SelectBox$SelectBoxScrollPane$1(this, selectBox));
        this.addListener(new SelectBox$SelectBoxScrollPane$2(this, selectBox));
        this.hideListener = new SelectBox$SelectBoxScrollPane$3(this, selectBox);
    }

    protected List<T> newList() {
        SelectBox$SelectBoxScrollPane selectBox$SelectBoxScrollPane = this;
        return new SelectBox$SelectBoxScrollPane$4(selectBox$SelectBoxScrollPane, selectBox$SelectBoxScrollPane.selectBox.style.listStyle);
    }

    public void show(Stage stage) {
        float f2;
        if (this.list.isTouchable()) {
            return;
        }
        stage.addActor(this);
        stage.addCaptureListener(this.hideListener);
        stage.addListener(this.list.getKeyListener());
        this.selectBox.localToStageCoordinates(this.stagePosition.set(0.0f, 0.0f));
        float f3 = this.list.getItemHeight();
        float f4 = f3 * (float)(this.maxListCount <= 0 ? this.selectBox.items.size : Math.min(this.maxListCount, this.selectBox.items.size));
        Drawable drawable = this.getStyle().background;
        if (drawable != null) {
            f4 += drawable.getTopHeight() + drawable.getBottomHeight();
        }
        if ((drawable = this.list.getStyle().background) != null) {
            f4 += drawable.getTopHeight() + drawable.getBottomHeight();
        }
        float f5 = this.stagePosition.y;
        float f6 = stage.getHeight() - f5 - this.selectBox.getHeight();
        boolean bl = true;
        if (f4 > f5) {
            if (f6 > f5) {
                bl = false;
                f4 = Math.min(f4, f6);
            } else {
                f4 = f5;
            }
        }
        if (bl) {
            SelectBox$SelectBoxScrollPane selectBox$SelectBoxScrollPane = this;
            selectBox$SelectBoxScrollPane.setY(selectBox$SelectBoxScrollPane.stagePosition.y - f4);
        } else {
            SelectBox$SelectBoxScrollPane selectBox$SelectBoxScrollPane = this;
            selectBox$SelectBoxScrollPane.setY(selectBox$SelectBoxScrollPane.stagePosition.y + this.selectBox.getHeight());
        }
        this.setHeight(f4);
        this.validate();
        f4 = Math.max(((WidgetGroup)this).getPrefWidth(), this.selectBox.getWidth());
        this.setWidth(f4);
        f5 = this.stagePosition.x;
        if (f2 + f4 > stage.getWidth()) {
            float f7;
            f5 -= this.getWidth() - this.selectBox.getWidth() - 1.0f;
            if (f7 < 0.0f) {
                f5 = 0.0f;
            }
        }
        this.setX(f5);
        this.validate();
        this.scrollTo(0.0f, this.list.getHeight() - (float)this.selectBox.getSelectedIndex() * f3 - f3 / 2.0f, 0.0f, 0.0f, true, true);
        this.updateVisualScroll();
        this.previousScrollFocus = null;
        Actor actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousScrollFocus = actor;
        }
        stage.setScrollFocus(this);
        this.list.selection.set(this.selectBox.getSelected());
        this.list.setTouchable(Touchable.enabled);
        this.clearActions();
        this.selectBox.onShow(this, bl);
    }

    public void hide() {
        if (!this.list.isTouchable() || !this.hasParent()) {
            return;
        }
        this.list.setTouchable(Touchable.disabled);
        Stage stage = this.getStage();
        if (stage != null) {
            Actor actor;
            stage.removeCaptureListener(this.hideListener);
            stage.removeListener(this.list.getKeyListener());
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || this.isAscendantOf(actor)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        this.clearActions();
        this.selectBox.onHide(this);
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.selectBox.localToStageCoordinates(SelectBox.temp.set(0.0f, 0.0f));
        if (!SelectBox.temp.equals(this.stagePosition)) {
            this.hide();
        }
        super.draw(batch, f2);
    }

    @Override
    public void act(float f2) {
        super.act(f2);
        this.toFront();
    }

    @Override
    public void setStage(Stage stage) {
        Stage stage2 = this.getStage();
        if (stage2 != null) {
            stage2.removeCaptureListener(this.hideListener);
            stage2.removeListener(this.list.getKeyListener());
        }
        super.setStage(stage);
    }

    public List<T> getList() {
        return this.list;
    }

    public SelectBox<T> getSelectBox() {
        return this.selectBox;
    }
}

