/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.List$ListStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$ScrollPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$1;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$2;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class SelectBox<T>
extends Widget
implements Disableable {
    static final Vector2 temp = new Vector2();
    SelectBox$SelectBoxStyle style;
    final Array<T> items = new Array();
    SelectBox$SelectBoxScrollPane<T> scrollPane;
    private float prefWidth;
    private float prefHeight;
    private ClickListener clickListener;
    boolean disabled;
    private int alignment = 8;
    boolean selectedPrefWidth;
    final ArraySelection<T> selection;

    public SelectBox(Skin skin) {
        this(skin.get(SelectBox$SelectBoxStyle.class));
    }

    public SelectBox(Skin skin, String string) {
        this(skin.get(string, SelectBox$SelectBoxStyle.class));
    }

    public SelectBox(SelectBox$SelectBoxStyle selectBox$SelectBoxStyle) {
        SelectBox selectBox = this;
        this.selection = new SelectBox$1(selectBox, selectBox.items);
        this.setStyle(selectBox$SelectBoxStyle);
        SelectBox selectBox2 = this;
        selectBox2.setSize(((Widget)selectBox2).getPrefWidth(), ((Widget)this).getPrefHeight());
        this.selection.setActor(this);
        this.selection.setRequired(true);
        this.scrollPane = this.newScrollPane();
        this.clickListener = new SelectBox$2(this);
        this.addListener(this.clickListener);
    }

    protected SelectBox$SelectBoxScrollPane<T> newScrollPane() {
        return new SelectBox$SelectBoxScrollPane(this);
    }

    public void setMaxListCount(int n2) {
        this.scrollPane.maxListCount = n2;
    }

    public int getMaxListCount() {
        return this.scrollPane.maxListCount;
    }

    @Override
    public void setStage(Stage stage) {
        if (stage == null) {
            this.scrollPane.hide();
        }
        super.setStage(stage);
    }

    public void setStyle(SelectBox$SelectBoxStyle selectBox$SelectBoxStyle) {
        if (selectBox$SelectBoxStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = selectBox$SelectBoxStyle;
        if (this.scrollPane != null) {
            this.scrollPane.setStyle(selectBox$SelectBoxStyle.scrollStyle);
            this.scrollPane.list.setStyle(selectBox$SelectBoxStyle.listStyle);
        }
        this.invalidateHierarchy();
    }

    public SelectBox$SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItems(T ... TArray) {
        if (TArray == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        this.items.clear();
        this.items.addAll(TArray);
        this.selection.validate();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(Array<T> array) {
        if (array == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        if (array != this.items) {
            this.items.clear();
            this.items.addAll(array);
        }
        this.selection.validate();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.selection.clear();
        this.scrollPane.list.clearItems();
        this.invalidateHierarchy();
    }

    public Array<T> getItems() {
        return this.items;
    }

    @Override
    public void layout() {
        Object object = this.style.background;
        BitmapFont bitmapFont = this.style.font;
        this.prefHeight = object != null ? Math.max(object.getTopHeight() + object.getBottomHeight() + bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f, object.getMinHeight()) : bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
        Pool<GlyphLayout> pool = Pools.get(GlyphLayout.class);
        GlyphLayout glyphLayout = pool.obtain();
        if (this.selectedPrefWidth) {
            T t2;
            this.prefWidth = 0.0f;
            if (object != null) {
                this.prefWidth = object.getLeftWidth() + object.getRightWidth();
            }
            if ((t2 = this.getSelected()) != null) {
                glyphLayout.setText(bitmapFont, this.toString(t2));
                this.prefWidth += glyphLayout.width;
            }
        } else {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < this.items.size; ++i2) {
                SelectBox selectBox = this;
                glyphLayout.setText(bitmapFont, selectBox.toString(selectBox.items.get(i2)));
                f2 = Math.max(glyphLayout.width, f2);
            }
            this.prefWidth = f2;
            if (object != null) {
                this.prefWidth = Math.max(this.prefWidth + object.getLeftWidth() + object.getRightWidth(), object.getMinWidth());
            }
            List$ListStyle list$ListStyle = this.style.listStyle;
            object = this.style.scrollStyle;
            float f3 = f2 + list$ListStyle.selection.getLeftWidth() + list$ListStyle.selection.getRightWidth();
            object = ((ScrollPane$ScrollPaneStyle)object).background;
            if (object != null) {
                f3 = Math.max(f3 + object.getLeftWidth() + object.getRightWidth(), object.getMinWidth());
            }
            if (this.scrollPane == null || !this.scrollPane.disableY) {
                f3 += Math.max(this.style.scrollStyle.vScroll != null ? this.style.scrollStyle.vScroll.getMinWidth() : 0.0f, this.style.scrollStyle.vScrollKnob != null ? this.style.scrollStyle.vScrollKnob.getMinWidth() : 0.0f);
            }
            this.prefWidth = Math.max(this.prefWidth, f3);
        }
        pool.free(glyphLayout);
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        if (this.isDisabled() && this.style.backgroundDisabled != null) {
            return this.style.backgroundDisabled;
        }
        if (this.scrollPane.hasParent() && this.style.backgroundOpen != null) {
            return this.style.backgroundOpen;
        }
        if (this.isOver() && this.style.backgroundOver != null) {
            return this.style.backgroundOver;
        }
        return this.style.background;
    }

    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.style.overFontColor != null && (this.isOver() || this.scrollPane.hasParent())) {
            return this.style.overFontColor;
        }
        return this.style.fontColor;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        Drawable drawable = this.getBackgroundDrawable();
        Color color = this.getFontColor();
        BitmapFont bitmapFont = this.style.font;
        Color color2 = this.getColor();
        float f3 = this.getX();
        float f4 = this.getY();
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f2);
        if (drawable != null) {
            drawable.draw(batch, f3, f4, f5, f6);
        }
        if ((color2 = this.selection.first()) != null) {
            if (drawable != null) {
                f5 -= drawable.getLeftWidth() + drawable.getRightWidth();
                f3 += drawable.getLeftWidth();
                f4 += (float)((int)((f6 -= drawable.getBottomHeight() + drawable.getTopHeight()) / 2.0f + drawable.getBottomHeight() + bitmapFont.getData().capHeight / 2.0f));
            } else {
                f4 += (float)((int)(f6 / 2.0f + bitmapFont.getData().capHeight / 2.0f));
            }
            bitmapFont.setColor(color.r, color.g, color.b, color.a * f2);
            this.drawItem(batch, bitmapFont, color2, f3, f4, f5);
        }
    }

    protected GlyphLayout drawItem(Batch batch, BitmapFont bitmapFont, T object, float f2, float f3, float f4) {
        object = this.toString(object);
        return bitmapFont.draw(batch, (CharSequence)object, f2, f3, 0, ((String)object).length(), f4, this.alignment, false, "...");
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public ArraySelection<T> getSelection() {
        return this.selection;
    }

    @Null
    public T getSelected() {
        return this.selection.first();
    }

    public void setSelected(@Null T t2) {
        if (this.items.contains(t2, false)) {
            this.selection.set(t2);
            return;
        }
        if (this.items.size > 0) {
            this.selection.set(this.items.first());
            return;
        }
        this.selection.clear();
    }

    public int getSelectedIndex() {
        OrderedSet orderedSet = this.selection.items();
        if (orderedSet.size == 0) {
            return -1;
        }
        return this.items.indexOf(orderedSet.first(), false);
    }

    public void setSelectedIndex(int n2) {
        this.selection.set(this.items.get(n2));
    }

    public void setSelectedPrefWidth(boolean bl) {
        this.selectedPrefWidth = bl;
    }

    public boolean getSelectedPrefWidth() {
        return this.selectedPrefWidth;
    }

    public float getMaxSelectedPrefWidth() {
        Object object = Pools.get(GlyphLayout.class);
        object = ((Pool)object).obtain();
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.items.size; ++i2) {
            SelectBox selectBox = this;
            ((GlyphLayout)object).setText(this.style.font, selectBox.toString(selectBox.items.get(i2)));
            f2 = Math.max(((GlyphLayout)object).width, f2);
        }
        Drawable drawable = this.style.background;
        if (drawable != null) {
            f2 = Math.max(f2 + drawable.getLeftWidth() + drawable.getRightWidth(), drawable.getMinWidth());
        }
        return f2;
    }

    @Override
    public void setDisabled(boolean bl) {
        if (bl && !this.disabled) {
            this.hideScrollPane();
        }
        this.disabled = bl;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    protected String toString(T t2) {
        return t2.toString();
    }

    @Deprecated
    public void showList() {
        this.showScrollPane();
    }

    public void showScrollPane() {
        if (this.items.size == 0) {
            return;
        }
        if (this.getStage() != null) {
            this.scrollPane.show(this.getStage());
        }
    }

    @Deprecated
    public void hideList() {
        this.hideScrollPane();
    }

    public void hideScrollPane() {
        this.scrollPane.hide();
    }

    public List<T> getList() {
        return this.scrollPane.list;
    }

    public void setScrollingDisabled(boolean bl) {
        this.scrollPane.setScrollingDisabled(true, bl);
        this.invalidateHierarchy();
    }

    public SelectBox$SelectBoxScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    protected void onShow(Actor actor, boolean bl) {
        actor.getColor().a = 0.0f;
        actor.addAction(Actions.fadeIn(0.3f, Interpolation.fade));
    }

    protected void onHide(Actor actor) {
        actor.getColor().a = 1.0f;
        actor.addAction(Actions.sequence((Action)Actions.fadeOut(0.15f, Interpolation.fade), (Action)Actions.removeActor()));
    }
}

