/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasRegion;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasSprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox$CheckBoxStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton$ImageButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton$ImageTextButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.List$ListStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar$ProgressBarStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$ScrollPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin$1;
import com.badlogic.gdx.scenes.scene2d.ui.Skin$2;
import com.badlogic.gdx.scenes.scene2d.ui.Skin$3;
import com.badlogic.gdx.scenes.scene2d.ui.Skin$4;
import com.badlogic.gdx.scenes.scene2d.ui.Skin$5;
import com.badlogic.gdx.scenes.scene2d.ui.Skin$TintedDrawable;
import com.badlogic.gdx.scenes.scene2d.ui.Slider$SliderStyle;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton$TextButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$TextFieldStyle;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.ui.Window$WindowStyle;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;

public class Skin
implements Disposable {
    ObjectMap<Class, ObjectMap<String, Object>> resources = new ObjectMap();
    TextureAtlas atlas;
    float scale = 1.0f;
    private final ObjectMap<String, Class> jsonClassTags = new ObjectMap(defaultTagClasses.length);
    private static final Class[] defaultTagClasses = new Class[]{BitmapFont.class, Color.class, Skin$TintedDrawable.class, NinePatchDrawable.class, SpriteDrawable.class, TextureRegionDrawable.class, TiledDrawable.class, Button$ButtonStyle.class, CheckBox$CheckBoxStyle.class, ImageButton$ImageButtonStyle.class, ImageTextButton$ImageTextButtonStyle.class, Label$LabelStyle.class, List$ListStyle.class, ProgressBar$ProgressBarStyle.class, ScrollPane$ScrollPaneStyle.class, SelectBox$SelectBoxStyle.class, Slider$SliderStyle.class, SplitPane.SplitPaneStyle.class, TextButton$TextButtonStyle.class, TextField$TextFieldStyle.class, TextTooltip.TextTooltipStyle.class, Touchpad.TouchpadStyle.class, Tree.TreeStyle.class, Window$WindowStyle.class};

    public Skin() {
        Class[] classArray = defaultTagClasses;
        int n2 = defaultTagClasses.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz = classArray[i2];
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
    }

    public Skin(FileHandle fileHandle) {
        Object object = defaultTagClasses;
        int n2 = defaultTagClasses.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz = object[i2];
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
        object = fileHandle.sibling(fileHandle.nameWithoutExtension() + ".atlas");
        if (object.exists()) {
            this.atlas = new TextureAtlas((FileHandle)object);
            Skin skin = this;
            skin.addRegions(skin.atlas);
        }
        this.load(fileHandle);
    }

    public Skin(FileHandle fileHandle, TextureAtlas textureAtlas) {
        Class[] classArray = defaultTagClasses;
        int n2 = defaultTagClasses.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz = classArray[i2];
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
        this.atlas = textureAtlas;
        this.addRegions(textureAtlas);
        this.load(fileHandle);
    }

    public Skin(TextureAtlas textureAtlas) {
        Class[] classArray = defaultTagClasses;
        int n2 = defaultTagClasses.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz = classArray[i2];
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
        this.atlas = textureAtlas;
        this.addRegions(textureAtlas);
    }

    public void load(FileHandle fileHandle) {
        try {
            this.getJsonLoader(fileHandle).fromJson(Skin.class, fileHandle);
            return;
        }
        catch (SerializationException serializationException) {
            throw new SerializationException("Error reading file: " + fileHandle, serializationException);
        }
    }

    public void addRegions(TextureAtlas object) {
        object = ((TextureAtlas)object).getRegions();
        int n2 = ((Array)object).size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)((Array)object).get(i2);
            String string = textureAtlas$AtlasRegion.name;
            if (textureAtlas$AtlasRegion.index != -1) {
                string = string + "_" + textureAtlas$AtlasRegion.index;
            }
            this.add(string, textureAtlas$AtlasRegion, TextureRegion.class);
        }
    }

    public void add(String string, Object object) {
        Object object2 = object;
        this.add(string, object2, object2.getClass());
    }

    public void add(String string, Object object, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        ObjectMap<String, Object> objectMap = this.resources.get(clazz);
        if (objectMap == null) {
            objectMap = new ObjectMap(clazz == TextureRegion.class || clazz == Drawable.class || clazz == Sprite.class ? 256 : 64);
            this.resources.put(clazz, objectMap);
        }
        objectMap.put(string, object);
    }

    public void remove(String string, Class object) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        object = this.resources.get(object);
        ((ObjectMap)object).remove((String)string);
    }

    public <T> T get(Class<T> clazz) {
        return this.get("default", clazz);
    }

    public <T> T get(String string, Class<T> clazz) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (clazz == Drawable.class) {
            return (T)this.getDrawable(string);
        }
        if (clazz == TextureRegion.class) {
            return (T)this.getRegion(string);
        }
        if (clazz == NinePatch.class) {
            return (T)this.getPatch(string);
        }
        if (clazz == Sprite.class) {
            return (T)this.getSprite(string);
        }
        ObjectMap<String, Object> objectMap = this.resources.get(clazz);
        if (objectMap == null) {
            throw new GdxRuntimeException("No " + clazz.getName() + " registered with name: " + string);
        }
        if ((objectMap = objectMap.get(string)) == null) {
            throw new GdxRuntimeException("No " + clazz.getName() + " registered with name: " + string);
        }
        return (T)objectMap;
    }

    @Null
    public <T> T optional(String string, Class<T> object) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if ((object = this.resources.get(object)) == null) {
            return null;
        }
        return (T)((ObjectMap)object).get(string);
    }

    public boolean has(String string, Class object) {
        if ((object = this.resources.get(object)) == null) {
            return false;
        }
        return ((ObjectMap)object).containsKey(string);
    }

    @Null
    public <T> ObjectMap<String, T> getAll(Class<T> clazz) {
        return this.resources.get(clazz);
    }

    public Color getColor(String string) {
        return this.get(string, Color.class);
    }

    public BitmapFont getFont(String string) {
        return this.get(string, BitmapFont.class);
    }

    public TextureRegion getRegion(String string) {
        Object object = this.optional(string, TextureRegion.class);
        if (object != null) {
            return object;
        }
        object = this.optional(string, Texture.class);
        if (object == null) {
            throw new GdxRuntimeException("No TextureRegion or Texture registered with name: " + string);
        }
        object = new TextureRegion((Texture)object);
        this.add(string, object, TextureRegion.class);
        return object;
    }

    @Null
    public Array<TextureRegion> getRegions(String string) {
        Array<TextureRegion> array = null;
        int n2 = 0;
        ++n2;
        TextureRegion textureRegion = this.optional(string + "_" + 0, TextureRegion.class);
        if (textureRegion != null) {
            array = new Array<TextureRegion>();
            while (textureRegion != null) {
                array.add(textureRegion);
                textureRegion = this.optional(string + "_" + n2++, TextureRegion.class);
            }
        }
        return array;
    }

    public TiledDrawable getTiledDrawable(String string) {
        TiledDrawable tiledDrawable = this.optional(string, TiledDrawable.class);
        if (tiledDrawable != null) {
            return tiledDrawable;
        }
        tiledDrawable = new TiledDrawable(this.getRegion(string));
        tiledDrawable.setName(string);
        if (this.scale != 1.0f) {
            this.scale(tiledDrawable);
            tiledDrawable.setScale(this.scale);
        }
        this.add(string, tiledDrawable, TiledDrawable.class);
        return tiledDrawable;
    }

    public NinePatch getPatch(String string) {
        NinePatch ninePatch = this.optional(string, NinePatch.class);
        if (ninePatch != null) {
            return ninePatch;
        }
        try {
            int[] nArray;
            TextureRegion textureRegion = this.getRegion(string);
            if (textureRegion instanceof TextureAtlas$AtlasRegion && (nArray = ((TextureAtlas$AtlasRegion)textureRegion).findValue("split")) != null) {
                ninePatch = new NinePatch(textureRegion, nArray[0], nArray[1], nArray[2], nArray[3]);
                nArray = ((TextureAtlas$AtlasRegion)textureRegion).findValue("pad");
                if (nArray != null) {
                    ninePatch.setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
                }
            }
            if (ninePatch == null) {
                ninePatch = new NinePatch(textureRegion);
            }
            if (this.scale != 1.0f) {
                ninePatch.scale(this.scale, this.scale);
            }
            this.add(string, ninePatch, NinePatch.class);
            return ninePatch;
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            throw new GdxRuntimeException("No NinePatch, TextureRegion, or Texture registered with name: " + string);
        }
    }

    public Sprite getSprite(String string) {
        Sprite sprite = this.optional(string, Sprite.class);
        if (sprite != null) {
            return sprite;
        }
        try {
            TextureRegion textureRegion = this.getRegion(string);
            if (textureRegion instanceof TextureAtlas$AtlasRegion) {
                TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = (TextureAtlas$AtlasRegion)textureRegion;
                if (textureAtlas$AtlasRegion.rotate || textureAtlas$AtlasRegion.packedWidth != textureAtlas$AtlasRegion.originalWidth || textureAtlas$AtlasRegion.packedHeight != textureAtlas$AtlasRegion.originalHeight) {
                    sprite = new TextureAtlas$AtlasSprite(textureAtlas$AtlasRegion);
                }
            }
            if (sprite == null) {
                sprite = new Sprite(textureRegion);
            }
            if (this.scale != 1.0f) {
                Sprite sprite2 = sprite;
                sprite2.setSize(sprite2.getWidth() * this.scale, sprite.getHeight() * this.scale);
            }
            this.add(string, sprite, Sprite.class);
            return sprite;
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            throw new GdxRuntimeException("No NinePatch, TextureRegion, or Texture registered with name: " + string);
        }
    }

    public Drawable getDrawable(String string) {
        TextureRegion textureRegion;
        Object object;
        Drawable drawable = this.optional(string, Drawable.class);
        if (drawable != null) {
            return drawable;
        }
        try {
            object = this.getRegion(string);
            if (object instanceof TextureAtlas$AtlasRegion) {
                textureRegion = (TextureAtlas$AtlasRegion)object;
                if (textureRegion.findValue("split") != null) {
                    drawable = new NinePatchDrawable(this.getPatch(string));
                } else if (textureRegion.rotate || textureRegion.packedWidth != textureRegion.originalWidth || textureRegion.packedHeight != textureRegion.originalHeight) {
                    drawable = new SpriteDrawable(this.getSprite(string));
                }
            }
            if (drawable == null) {
                drawable = new TextureRegionDrawable((TextureRegion)object);
                if (this.scale != 1.0f) {
                    this.scale(drawable);
                }
            }
        }
        catch (GdxRuntimeException gdxRuntimeException) {}
        if (drawable == null) {
            object = this.optional(string, NinePatch.class);
            if (object != null) {
                drawable = new NinePatchDrawable((NinePatch)object);
            } else {
                textureRegion = this.optional(string, Sprite.class);
                if (textureRegion != null) {
                    drawable = new SpriteDrawable((Sprite)textureRegion);
                } else {
                    throw new GdxRuntimeException("No Drawable, NinePatch, TextureRegion, Texture, or Sprite registered with name: " + string);
                }
            }
        }
        if (drawable instanceof BaseDrawable) {
            ((BaseDrawable)drawable).setName(string);
        }
        this.add(string, drawable, Drawable.class);
        return drawable;
    }

    @Null
    public String find(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        ObjectMap<String, Object> objectMap = this.resources.get(object.getClass());
        if (objectMap == null) {
            return null;
        }
        return objectMap.findKey(object, true);
    }

    public Drawable newDrawable(String string) {
        Skin skin = this;
        return skin.newDrawable(skin.getDrawable(string));
    }

    public Drawable newDrawable(String string, float f2, float f3, float f4, float f5) {
        Skin skin = this;
        return skin.newDrawable(skin.getDrawable(string), new Color(f2, f3, f4, f5));
    }

    public Drawable newDrawable(String string, Color color) {
        Skin skin = this;
        return skin.newDrawable(skin.getDrawable(string), color);
    }

    public Drawable newDrawable(Drawable drawable) {
        if (drawable instanceof TiledDrawable) {
            return new TiledDrawable((TiledDrawable)drawable);
        }
        if (drawable instanceof TextureRegionDrawable) {
            return new TextureRegionDrawable((TextureRegionDrawable)drawable);
        }
        if (drawable instanceof NinePatchDrawable) {
            return new NinePatchDrawable((NinePatchDrawable)drawable);
        }
        if (drawable instanceof SpriteDrawable) {
            return new SpriteDrawable((SpriteDrawable)drawable);
        }
        throw new GdxRuntimeException("Unable to copy, unknown drawable type: " + drawable.getClass());
    }

    public Drawable newDrawable(Drawable drawable, float f2, float f3, float f4, float f5) {
        return this.newDrawable(drawable, new Color(f2, f3, f4, f5));
    }

    public Drawable newDrawable(Drawable drawable, Color color) {
        Drawable drawable2;
        if (drawable instanceof TextureRegionDrawable) {
            drawable2 = ((TextureRegionDrawable)drawable).tint(color);
        } else if (drawable instanceof NinePatchDrawable) {
            drawable2 = ((NinePatchDrawable)drawable).tint(color);
        } else if (drawable instanceof SpriteDrawable) {
            drawable2 = ((SpriteDrawable)drawable).tint(color);
        } else {
            throw new GdxRuntimeException("Unable to copy, unknown drawable type: " + drawable.getClass());
        }
        if (drawable2 instanceof BaseDrawable) {
            BaseDrawable baseDrawable = (BaseDrawable)drawable2;
            if (drawable instanceof BaseDrawable) {
                baseDrawable.setName(((BaseDrawable)drawable).getName() + " (" + color + ")");
            } else {
                baseDrawable.setName(" (" + color + ")");
            }
        }
        return drawable2;
    }

    public void scale(Drawable drawable) {
        Drawable drawable2 = drawable;
        drawable2.setLeftWidth(drawable2.getLeftWidth() * this.scale);
        Drawable drawable3 = drawable;
        drawable3.setRightWidth(drawable3.getRightWidth() * this.scale);
        Drawable drawable4 = drawable;
        drawable4.setBottomHeight(drawable4.getBottomHeight() * this.scale);
        Drawable drawable5 = drawable;
        drawable5.setTopHeight(drawable5.getTopHeight() * this.scale);
        Drawable drawable6 = drawable;
        drawable6.setMinWidth(drawable6.getMinWidth() * this.scale);
        Drawable drawable7 = drawable;
        drawable7.setMinHeight(drawable7.getMinHeight() * this.scale);
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public void setEnabled(Actor actor, boolean bl) {
        Object object;
        Object object2 = Skin.findMethod(actor.getClass(), "getStyle");
        if (object2 == null) {
            return;
        }
        try {
            object = ((Method)object2).invoke(actor, new Object[0]);
        }
        catch (Exception exception) {
            return;
        }
        object2 = this.find(object);
        if (object2 == null) {
            return;
        }
        object2 = ((String)object2).replace("-disabled", "") + (bl ? "" : "-disabled");
        object = this.get((String)object2, object.getClass());
        object2 = Skin.findMethod(actor.getClass(), "setStyle");
        if (object2 == null) {
            return;
        }
        try {
            ((Method)object2).invoke(actor, object);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Null
    public TextureAtlas getAtlas() {
        return this.atlas;
    }

    @Override
    public void dispose() {
        if (this.atlas != null) {
            this.atlas.dispose();
        }
        for (ObjectMap objectMap : this.resources.values()) {
            for (Object e2 : objectMap.values()) {
                if (!(e2 instanceof Disposable)) continue;
                ((Disposable)e2).dispose();
            }
        }
    }

    protected Json getJsonLoader(FileHandle object) {
        Skin object22 = this;
        Skin$1 skin$1 = new Skin$1(this);
        skin$1.setTypeName(null);
        skin$1.setUsePrototypes(false);
        skin$1.setSerializer(Skin.class, new Skin$2(this, object22));
        skin$1.setSerializer(BitmapFont.class, new Skin$3(this, (FileHandle)object, object22));
        skin$1.setSerializer(Color.class, new Skin$4(this));
        skin$1.setSerializer(Skin$TintedDrawable.class, new Skin$5(this));
        for (ObjectMap$Entry objectMap$Entry : this.jsonClassTags) {
            skin$1.addClassTag((String)objectMap$Entry.key, (Class)objectMap$Entry.value);
        }
        return skin$1;
    }

    public ObjectMap<String, Class> getJsonClassTags() {
        return this.jsonClassTags;
    }

    @Null
    private static Method findMethod(Class methodArray, String string) {
        for (Method method : ClassReflection.getMethods((Class)methodArray)) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }
}

