/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar$ProgressBarStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider$1;
import com.badlogic.gdx.scenes.scene2d.ui.Slider$SliderStyle;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;

public class Slider
extends ProgressBar {
    int button = -1;
    int draggingPointer = -1;
    boolean mouseOver;
    private Interpolation visualInterpolationInverse = Interpolation.linear;
    private float[] snapValues;
    private float threshold;

    public Slider(float f2, float f3, float f4, boolean bl, Skin skin) {
        this(f2, f3, f4, bl, skin.get("default-" + (bl ? "vertical" : "horizontal"), Slider$SliderStyle.class));
    }

    public Slider(float f2, float f3, float f4, boolean bl, Skin skin, String string) {
        this(f2, f3, f4, bl, skin.get(string, Slider$SliderStyle.class));
    }

    public Slider(float f2, float f3, float f4, boolean bl, Slider$SliderStyle slider$SliderStyle) {
        super(f2, f3, f4, bl, slider$SliderStyle);
        this.addListener(new Slider$1(this));
    }

    @Override
    public Slider$SliderStyle getStyle() {
        return (Slider$SliderStyle)super.getStyle();
    }

    public boolean isOver() {
        return this.mouseOver;
    }

    @Override
    @Null
    protected Drawable getBackgroundDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledBackground != null) {
            return slider$SliderStyle.disabledBackground;
        }
        if (this.isDragging() && slider$SliderStyle.backgroundDown != null) {
            return slider$SliderStyle.backgroundDown;
        }
        if (this.mouseOver && slider$SliderStyle.backgroundOver != null) {
            return slider$SliderStyle.backgroundOver;
        }
        return slider$SliderStyle.background;
    }

    @Override
    @Null
    protected Drawable getKnobDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledKnob != null) {
            return slider$SliderStyle.disabledKnob;
        }
        if (this.isDragging() && slider$SliderStyle.knobDown != null) {
            return slider$SliderStyle.knobDown;
        }
        if (this.mouseOver && slider$SliderStyle.knobOver != null) {
            return slider$SliderStyle.knobOver;
        }
        return slider$SliderStyle.knob;
    }

    @Override
    protected Drawable getKnobBeforeDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledKnobBefore != null) {
            return slider$SliderStyle.disabledKnobBefore;
        }
        if (this.isDragging() && slider$SliderStyle.knobBeforeDown != null) {
            return slider$SliderStyle.knobBeforeDown;
        }
        if (this.mouseOver && slider$SliderStyle.knobBeforeOver != null) {
            return slider$SliderStyle.knobBeforeOver;
        }
        return slider$SliderStyle.knobBefore;
    }

    @Override
    protected Drawable getKnobAfterDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledKnobAfter != null) {
            return slider$SliderStyle.disabledKnobAfter;
        }
        if (this.isDragging() && slider$SliderStyle.knobAfterDown != null) {
            return slider$SliderStyle.knobAfterDown;
        }
        if (this.mouseOver && slider$SliderStyle.knobAfterOver != null) {
            return slider$SliderStyle.knobAfterOver;
        }
        return slider$SliderStyle.knobAfter;
    }

    boolean calculatePositionAndValue(float f2, float f3) {
        float f4;
        float f5;
        Object object = this.getStyle();
        object = ((ProgressBar$ProgressBarStyle)object).knob;
        Drawable drawable = this.getBackgroundDrawable();
        float f6 = this.position;
        float f7 = this.getMinValue();
        float f8 = this.getMaxValue();
        if (this.vertical) {
            f5 = this.getHeight() - drawable.getTopHeight() - drawable.getBottomHeight();
            f4 = object == null ? 0.0f : object.getMinHeight();
            this.position = f3 - drawable.getBottomHeight() - f4 * 0.5f;
            f2 = f7 + (f8 - f7) * this.visualInterpolationInverse.apply(this.position / (f5 - f4));
            this.position = Math.max(Math.min(0.0f, drawable.getBottomHeight()), this.position);
            this.position = Math.min(f5 - f4, this.position);
        } else {
            f5 = this.getWidth() - drawable.getLeftWidth() - drawable.getRightWidth();
            f4 = object == null ? 0.0f : object.getMinWidth();
            this.position = f2 - drawable.getLeftWidth() - f4 * 0.5f;
            f2 = f7 + (f8 - f7) * this.visualInterpolationInverse.apply(this.position / (f5 - f4));
            this.position = Math.max(Math.min(0.0f, drawable.getLeftWidth()), this.position);
            this.position = Math.min(f5 - f4, this.position);
        }
        f5 = f2;
        if (!Gdx.input.isKeyPressed(59) && !Gdx.input.isKeyPressed(60)) {
            f2 = this.snap(f2);
        }
        boolean bl = this.setValue(f2);
        if (f2 == f5) {
            this.position = f6;
        }
        return bl;
    }

    protected float snap(float f2) {
        if (this.snapValues == null || this.snapValues.length == 0) {
            return f2;
        }
        float f3 = -1.0f;
        float f4 = 0.0f;
        for (int i2 = 0; i2 < this.snapValues.length; ++i2) {
            float f5;
            float f6 = this.snapValues[i2];
            float f7 = Math.abs(f2 - f6);
            if (!(f5 <= this.threshold) || f3 != -1.0f && !(f7 < f3)) continue;
            f3 = f7;
            f4 = f6;
        }
        if (f3 == -1.0f) {
            return f2;
        }
        return f4;
    }

    public void setSnapToValues(float f2, float ... fArray) {
        if (fArray != null && fArray.length == 0) {
            throw new IllegalArgumentException("values cannot be empty.");
        }
        this.snapValues = fArray;
        this.threshold = f2;
    }

    @Deprecated
    public void setSnapToValues(@Null float[] fArray, float f2) {
        this.setSnapToValues(f2, fArray);
    }

    @Null
    public float[] getSnapToValues() {
        return this.snapValues;
    }

    public float getSnapToValuesThreshold() {
        return this.threshold;
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public void setButton(int n2) {
        this.button = n2;
    }

    public void setVisualInterpolationInverse(Interpolation interpolation) {
        this.visualInterpolationInverse = interpolation;
    }

    public void setVisualPercent(float f2) {
        Slider slider = this;
        slider.setValue(slider.min + (this.max - this.min) * this.visualInterpolationInverse.apply(f2));
    }
}

