/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane$1;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane$SplitPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;

public class SplitPane
extends WidgetGroup {
    SplitPane$SplitPaneStyle style;
    @Null
    private Actor firstWidget;
    @Null
    private Actor secondWidget;
    boolean vertical;
    float splitAmount = 0.5f;
    float minAmount;
    float maxAmount = 1.0f;
    private final Rectangle firstWidgetBounds = new Rectangle();
    private final Rectangle secondWidgetBounds = new Rectangle();
    final Rectangle handleBounds = new Rectangle();
    boolean cursorOverHandle;
    private final Rectangle tempScissors = new Rectangle();
    Vector2 lastPoint = new Vector2();
    Vector2 handlePosition = new Vector2();

    public SplitPane(@Null Actor actor, @Null Actor actor2, boolean bl, Skin skin) {
        this(actor, actor2, bl, skin, "default-" + (bl ? "vertical" : "horizontal"));
    }

    public SplitPane(@Null Actor actor, @Null Actor actor2, boolean bl, Skin skin, String string) {
        this(actor, actor2, bl, skin.get(string, SplitPane$SplitPaneStyle.class));
    }

    public SplitPane(@Null Actor actor, @Null Actor actor2, boolean bl, SplitPane$SplitPaneStyle splitPane$SplitPaneStyle) {
        this.vertical = bl;
        this.setStyle(splitPane$SplitPaneStyle);
        this.setFirstWidget(actor);
        this.setSecondWidget(actor2);
        SplitPane splitPane = this;
        splitPane.setSize(((WidgetGroup)splitPane).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
        this.initialize();
    }

    private void initialize() {
        this.addListener(new SplitPane$1(this));
    }

    public void setStyle(SplitPane$SplitPaneStyle splitPane$SplitPaneStyle) {
        this.style = splitPane$SplitPaneStyle;
        this.invalidateHierarchy();
    }

    public SplitPane$SplitPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        Object object;
        this.clampSplitAmount();
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        Object object2 = this.firstWidget;
        if (object2 != null) {
            object = this.firstWidgetBounds;
            ((Actor)object2).setBounds(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            if (object2 instanceof Layout) {
                ((Layout)object2).validate();
            }
        }
        if ((object = this.secondWidget) != null) {
            object2 = this.secondWidgetBounds;
            ((Actor)object).setBounds(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            if (object instanceof Layout) {
                ((Layout)object).validate();
            }
        }
    }

    @Override
    public float getPrefWidth() {
        float f2;
        float f3;
        float f4 = this.firstWidget == null ? 0.0f : (f3 = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefWidth() : this.firstWidget.getWidth());
        float f5 = this.secondWidget == null ? 0.0f : (f2 = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefWidth() : this.secondWidget.getWidth());
        if (this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.getMinWidth() + f2;
    }

    @Override
    public float getPrefHeight() {
        float f2;
        float f3;
        float f4 = this.firstWidget == null ? 0.0f : (f3 = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefHeight() : this.firstWidget.getHeight());
        float f5 = this.secondWidget == null ? 0.0f : (f2 = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefHeight() : this.secondWidget.getHeight());
        if (!this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.getMinHeight() + f2;
    }

    @Override
    public float getMinWidth() {
        float f2;
        float f3 = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getMinWidth() : 0.0f;
        float f4 = f2 = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getMinWidth() : 0.0f;
        if (this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.getMinWidth() + f2;
    }

    @Override
    public float getMinHeight() {
        float f2;
        float f3 = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getMinHeight() : 0.0f;
        float f4 = f2 = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getMinHeight() : 0.0f;
        if (!this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.getMinHeight() + f2;
    }

    public void setVertical(boolean bl) {
        if (this.vertical == bl) {
            return;
        }
        this.vertical = bl;
        this.invalidateHierarchy();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    private void calculateHorizBoundsAndPositions() {
        Drawable drawable = this.style.handle;
        float f2 = this.getHeight();
        float f3 = this.getWidth() - drawable.getMinWidth();
        float f4 = (int)(f3 * this.splitAmount);
        float f5 = drawable.getMinWidth();
        this.firstWidgetBounds.set(0.0f, 0.0f, f4, f2);
        this.secondWidgetBounds.set(f4 + f5, 0.0f, f3 -= f4, f2);
        this.handleBounds.set(f4, 0.0f, f5, f2);
    }

    private void calculateVertBoundsAndPositions() {
        Drawable drawable = this.style.handle;
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = f3 - drawable.getMinHeight();
        float f5 = (int)(f4 * this.splitAmount);
        float f6 = drawable.getMinHeight();
        this.firstWidgetBounds.set(0.0f, f3 - f5, f2, f5);
        this.secondWidgetBounds.set(0.0f, 0.0f, f2, f4 -= f5);
        this.handleBounds.set(0.0f, f4, f2, f6);
    }

    @Override
    public void draw(Batch batch, float f2) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        this.validate();
        Color color = this.getColor();
        f2 = color.a * f2;
        this.applyTransform(batch, this.computeTransform());
        if (this.firstWidget != null && this.firstWidget.isVisible()) {
            batch.flush();
            stage.calculateScissors(this.firstWidgetBounds, this.tempScissors);
            if (ScissorStack.pushScissors(this.tempScissors)) {
                this.firstWidget.draw(batch, f2);
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        if (this.secondWidget != null && this.secondWidget.isVisible()) {
            batch.flush();
            stage.calculateScissors(this.secondWidgetBounds, this.tempScissors);
            if (ScissorStack.pushScissors(this.tempScissors)) {
                this.secondWidget.draw(batch, f2);
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        batch.setColor(color.r, color.g, color.b, f2);
        this.style.handle.draw(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        this.resetTransform(batch);
    }

    public void setSplitAmount(float f2) {
        this.splitAmount = f2;
        this.invalidate();
    }

    public float getSplitAmount() {
        return this.splitAmount;
    }

    protected void clampSplitAmount() {
        float f2 = this.minAmount;
        float f3 = this.maxAmount;
        if (this.vertical) {
            float f4 = this.getHeight() - this.style.handle.getMinHeight();
            if (this.firstWidget instanceof Layout) {
                f2 = Math.max(f2, Math.min(((Layout)((Object)this.firstWidget)).getMinHeight() / f4, 1.0f));
            }
            if (this.secondWidget instanceof Layout) {
                f3 = Math.min(f3, 1.0f - Math.min(((Layout)((Object)this.secondWidget)).getMinHeight() / f4, 1.0f));
            }
        } else {
            float f5 = this.getWidth() - this.style.handle.getMinWidth();
            if (this.firstWidget instanceof Layout) {
                f2 = Math.max(f2, Math.min(((Layout)((Object)this.firstWidget)).getMinWidth() / f5, 1.0f));
            }
            if (this.secondWidget instanceof Layout) {
                f3 = Math.min(f3, 1.0f - Math.min(((Layout)((Object)this.secondWidget)).getMinWidth() / f5, 1.0f));
            }
        }
        if (f2 > f3) {
            this.splitAmount = 0.5f * (f2 + f3);
            return;
        }
        this.splitAmount = Math.max(Math.min(this.splitAmount, f3), f2);
    }

    public float getMinSplitAmount() {
        return this.minAmount;
    }

    public void setMinSplitAmount(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new GdxRuntimeException("minAmount has to be >= 0 and <= 1");
        }
        this.minAmount = f2;
    }

    public float getMaxSplitAmount() {
        return this.maxAmount;
    }

    public void setMaxSplitAmount(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new GdxRuntimeException("maxAmount has to be >= 0 and <= 1");
        }
        this.maxAmount = f2;
    }

    public void setFirstWidget(@Null Actor actor) {
        if (this.firstWidget != null) {
            SplitPane splitPane = this;
            super.removeActor(splitPane.firstWidget);
        }
        this.firstWidget = actor;
        if (actor != null) {
            super.addActor(actor);
        }
        this.invalidate();
    }

    public void setSecondWidget(@Null Actor actor) {
        if (this.secondWidget != null) {
            SplitPane splitPane = this;
            super.removeActor(splitPane.secondWidget);
        }
        this.secondWidget = actor;
        if (actor != null) {
            super.addActor(actor);
        }
        this.invalidate();
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public void addActorAt(int n2, Actor actor) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor == this.firstWidget) {
            this.setFirstWidget(null);
            return true;
        }
        if (actor == this.secondWidget) {
            this.setSecondWidget(null);
            return true;
        }
        return true;
    }

    @Override
    public boolean removeActor(Actor actor, boolean bl) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor == this.firstWidget) {
            super.removeActor(actor, bl);
            this.firstWidget = null;
            this.invalidate();
            return true;
        }
        if (actor == this.secondWidget) {
            super.removeActor(actor, bl);
            this.secondWidget = null;
            this.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public Actor removeActorAt(int n2, boolean bl) {
        Actor actor = super.removeActorAt(n2, bl);
        if (actor == this.firstWidget) {
            super.removeActor(actor, bl);
            this.firstWidget = null;
            this.invalidate();
        } else if (actor == this.secondWidget) {
            super.removeActor(actor, bl);
            this.secondWidget = null;
            this.invalidate();
        }
        return actor;
    }

    public boolean isCursorOverHandle() {
        return this.cursorOverHandle;
    }
}

