/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer$ShapeType;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table$1;
import com.badlogic.gdx.scenes.scene2d.ui.Table$2;
import com.badlogic.gdx.scenes.scene2d.ui.Table$3;
import com.badlogic.gdx.scenes.scene2d.ui.Table$4;
import com.badlogic.gdx.scenes.scene2d.ui.Table$5;
import com.badlogic.gdx.scenes.scene2d.ui.Table$Debug;
import com.badlogic.gdx.scenes.scene2d.ui.Table$DebugRect;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.Value$Fixed;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SnapshotArray;
import java.util.Arrays;

public class Table
extends WidgetGroup {
    public static Color debugTableColor = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static Color debugCellColor = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static Color debugActorColor = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    static final Pool<Cell> cellPool = new Table$1();
    private static float[] columnWeightedWidth;
    private static float[] rowWeightedHeight;
    private int columns;
    private int rows;
    private boolean implicitEndRow;
    private final Array<Cell> cells = new Array(4);
    private final Cell cellDefaults;
    private final Array<Cell> columnDefaults = new Array(2);
    private Cell rowDefaults;
    private boolean sizeInvalid = true;
    private float[] columnMinWidth;
    private float[] rowMinHeight;
    private float[] columnPrefWidth;
    private float[] rowPrefHeight;
    private float tableMinWidth;
    private float tableMinHeight;
    private float tablePrefWidth;
    private float tablePrefHeight;
    private float[] columnWidth;
    private float[] rowHeight;
    private float[] expandWidth;
    private float[] expandHeight;
    Value padTop = backgroundTop;
    Value padLeft = backgroundLeft;
    Value padBottom = backgroundBottom;
    Value padRight = backgroundRight;
    int align = 1;
    Table$Debug debug = Table$Debug.none;
    Array<Table$DebugRect> debugRects;
    @Null
    Drawable background;
    private boolean clip;
    @Null
    private Skin skin;
    boolean round = true;
    public static Value backgroundTop;
    public static Value backgroundLeft;
    public static Value backgroundBottom;
    public static Value backgroundRight;

    public Table() {
        this((Skin)null);
    }

    public Table(@Null Skin skin) {
        this.skin = skin;
        this.cellDefaults = this.obtainCell();
        this.setTransform(false);
        this.setTouchable(Touchable.childrenOnly);
    }

    private Cell obtainCell() {
        Cell cell = cellPool.obtain();
        cell.setTable(this);
        return cell;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, f2, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float f3 = this.padLeft.get(this);
                float f4 = this.padBottom.get(this);
                if (this.clipBegin(f3, f4, this.getWidth() - f3 - this.padRight.get(this), this.getHeight() - f4 - this.padTop.get(this))) {
                    this.drawChildren(batch, f2);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, f2);
            }
            this.resetTransform(batch);
            return;
        }
        this.drawBackground(batch, f2, this.getX(), this.getY());
        super.draw(batch, f2);
    }

    protected void drawBackground(Batch batch, float f2, float f3, float f4) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        this.background.draw(batch, f3, f4, this.getWidth(), this.getHeight());
    }

    public void setBackground(String string) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        Table table = this;
        table.setBackground(table.skin.getDrawable(string));
    }

    public void setBackground(@Null Drawable drawable) {
        if (this.background == drawable) {
            return;
        }
        float f2 = this.getPadTop();
        float f3 = this.getPadLeft();
        float f4 = this.getPadBottom();
        float f5 = this.getPadRight();
        this.background = drawable;
        float f6 = this.getPadTop();
        float f7 = this.getPadLeft();
        float f8 = this.getPadBottom();
        float f9 = this.getPadRight();
        if (f2 + f4 != f6 + f8 || f3 + f5 != f7 + f9) {
            this.invalidateHierarchy();
            return;
        }
        if (f2 != f6 || f3 != f7 || f4 != f8 || f5 != f9) {
            ((WidgetGroup)this).invalidate();
        }
    }

    public Table background(@Null Drawable drawable) {
        this.setBackground(drawable);
        return this;
    }

    public Table background(String string) {
        this.setBackground(string);
        return this;
    }

    @Null
    public Drawable getBackground() {
        return this.background;
    }

    @Override
    @Null
    public Actor hit(float f2, float f3, boolean bl) {
        if (this.clip) {
            if (bl && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (f2 < 0.0f || f2 >= this.getWidth() || f3 < 0.0f || f3 >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(f2, f3, bl);
    }

    public Table clip() {
        this.setClip(true);
        return this;
    }

    public Table clip(boolean bl) {
        this.setClip(bl);
        return this;
    }

    public void setClip(boolean bl) {
        this.clip = bl;
        this.setTransform(bl);
        ((WidgetGroup)this).invalidate();
    }

    public boolean getClip() {
        return this.clip;
    }

    @Override
    public void invalidate() {
        this.sizeInvalid = true;
        super.invalidate();
    }

    public <T extends Actor> Cell<T> add(@Null T t2) {
        Cell cell;
        block10: {
            int n2;
            cell = this.obtainCell();
            this.obtainCell().actor = t2;
            if (this.implicitEndRow) {
                this.implicitEndRow = false;
                --this.rows;
                this.cells.peek().endRow = false;
            }
            if ((n2 = this.cells.size) > 0) {
                T[] TArray = this.cells.peek();
                if (!TArray.endRow) {
                    cell.column = TArray.column + TArray.colspan;
                    cell.row = TArray.row;
                } else {
                    cell.column = 0;
                    cell.row = TArray.row + 1;
                }
                if (cell.row > 0) {
                    TArray = this.cells.items;
                    --n2;
                    while (n2 >= 0) {
                        int n3;
                        Cell cell2 = (Cell)TArray[n2];
                        int n4 = n3 + cell2.colspan;
                        for (n3 = cell2.column; n3 < n4; ++n3) {
                            if (n3 != cell.column) continue;
                            cell.cellAboveIndex = n2;
                            break block10;
                        }
                        --n2;
                    }
                }
            } else {
                cell.column = 0;
                cell.row = 0;
            }
        }
        this.cells.add(cell);
        cell.set(this.cellDefaults);
        if (cell.column < this.columnDefaults.size) {
            cell.merge(this.columnDefaults.get(cell.column));
        }
        cell.merge(this.rowDefaults);
        if (t2 != null) {
            this.addActor(t2);
        }
        return cell;
    }

    public Table add(Actor ... actorArray) {
        int n2 = actorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add((T)actorArray[i2]);
        }
        return this;
    }

    public Cell<Label> add(@Null CharSequence charSequence) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(charSequence, this.skin));
    }

    public Cell<Label> add(@Null CharSequence charSequence, String string) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(charSequence, this.skin.get(string, Label$LabelStyle.class)));
    }

    public Cell<Label> add(@Null CharSequence charSequence, String string, @Null Color color) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(charSequence, new Label$LabelStyle(this.skin.getFont(string), color)));
    }

    public Cell<Label> add(@Null CharSequence charSequence, String string, String string2) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((T)new Label(charSequence, new Label$LabelStyle(this.skin.getFont(string), this.skin.getColor(string2))));
    }

    public Cell add() {
        return this.add((T)null);
    }

    public Cell<Stack> stack(Actor ... actorArray) {
        Stack stack = new Stack();
        if (actorArray != null) {
            int n2 = actorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stack.addActor(actorArray[i2]);
            }
        }
        return this.add((T)stack);
    }

    @Override
    public boolean removeActor(Actor actor) {
        return ((Group)this).removeActor(actor, true);
    }

    @Override
    public boolean removeActor(Actor object, boolean bl) {
        if (!super.removeActor((Actor)object, bl)) {
            return false;
        }
        if ((object = this.getCell(object)) != null) {
            ((Cell)object).actor = null;
        }
        return true;
    }

    @Override
    public Actor removeActorAt(int n2, boolean bl) {
        Actor actor = super.removeActorAt(n2, bl);
        Cell<Actor> cell = this.getCell(actor);
        if (cell != null) {
            cell.actor = null;
        }
        return actor;
    }

    @Override
    public void clearChildren(boolean bl) {
        T[] TArray = this.cells.items;
        for (int i2 = this.cells.size - 1; i2 >= 0; --i2) {
            Object object = (Cell)TArray[i2];
            object = ((Cell)object).actor;
            if (object == null) continue;
            ((Actor)object).remove();
        }
        cellPool.freeAll(this.cells);
        this.cells.clear();
        this.rows = 0;
        this.columns = 0;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = null;
        this.implicitEndRow = false;
        super.clearChildren(bl);
    }

    public void reset() {
        this.clearChildren();
        this.padTop = backgroundTop;
        this.padLeft = backgroundLeft;
        this.padBottom = backgroundBottom;
        this.padRight = backgroundRight;
        this.align = 1;
        this.debug(Table$Debug.none);
        this.cellDefaults.reset();
        int n2 = this.columnDefaults.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cell cell = this.columnDefaults.get(i2);
            if (cell == null) continue;
            cellPool.free(cell);
        }
        this.columnDefaults.clear();
    }

    public Cell row() {
        if (this.cells.size > 0) {
            if (!this.implicitEndRow) {
                if (this.cells.peek().endRow) {
                    return this.rowDefaults;
                }
                this.endRow();
            }
            ((WidgetGroup)this).invalidate();
        }
        this.implicitEndRow = false;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = this.obtainCell();
        this.rowDefaults.clear();
        return this.rowDefaults;
    }

    private void endRow() {
        T[] TArray = this.cells.items;
        int n2 = 0;
        for (int i2 = this.cells.size - 1; i2 >= 0; --i2) {
            Cell cell = (Cell)TArray[i2];
            if (cell.endRow) break;
            n2 += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, n2);
        ++this.rows;
        this.cells.peek().endRow = true;
    }

    public Cell columnDefaults(int n2) {
        Cell cell = this.columnDefaults.size > n2 ? this.columnDefaults.get(n2) : null;
        if (cell == null) {
            cell = this.obtainCell();
            cell.clear();
            if (n2 >= this.columnDefaults.size) {
                for (int i2 = this.columnDefaults.size; i2 < n2; ++i2) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(n2, cell);
            }
        }
        return cell;
    }

    @Null
    public <T extends Actor> Cell<T> getCell(T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        T[] TArray = this.cells.items;
        int n2 = this.cells.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cell cell = (Cell)TArray[i2];
            if (cell.actor != t2) continue;
            return cell;
        }
        return null;
    }

    public Array<Cell> getCells() {
        return this.cells;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f2 = this.tablePrefWidth;
        if (this.background != null) {
            return Math.max(f2, this.background.getMinWidth());
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f2 = this.tablePrefHeight;
        if (this.background != null) {
            return Math.max(f2, this.background.getMinHeight());
        }
        return f2;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public Table pad(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("pad cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value;
        this.padBottom = value;
        this.padRight = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(Value value, Value value2, Value value3, Value value4) {
        if (value == null) {
            throw new IllegalArgumentException("top cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("left cannot be null.");
        }
        if (value3 == null) {
            throw new IllegalArgumentException("bottom cannot be null.");
        }
        if (value4 == null) {
            throw new IllegalArgumentException("right cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value2;
        this.padBottom = value3;
        this.padRight = value4;
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padTop cannot be null.");
        }
        this.padTop = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padLeft cannot be null.");
        }
        this.padLeft = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padBottom cannot be null.");
        }
        this.padBottom = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padRight cannot be null.");
        }
        this.padRight = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(float f2) {
        this.pad(Value$Fixed.valueOf(f2));
        return this;
    }

    public Table pad(float f2, float f3, float f4, float f5) {
        this.padTop = Value$Fixed.valueOf(f2);
        this.padLeft = Value$Fixed.valueOf(f3);
        this.padBottom = Value$Fixed.valueOf(f4);
        this.padRight = Value$Fixed.valueOf(f5);
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(float f2) {
        this.padTop = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(float f2) {
        this.padLeft = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(float f2) {
        this.padBottom = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(float f2) {
        this.padRight = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table align(int n2) {
        this.align = n2;
        return this;
    }

    public Table center() {
        this.align = 1;
        return this;
    }

    public Table top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Table left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Table bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Table right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug(bl ? Table$Debug.all : Table$Debug.none);
    }

    @Override
    public Table debug() {
        super.debug();
        return this;
    }

    @Override
    public Table debugAll() {
        super.debugAll();
        return this;
    }

    public Table debugTable() {
        super.setDebug(true);
        if (this.debug != Table$Debug.table) {
            this.debug = Table$Debug.table;
            ((WidgetGroup)this).invalidate();
        }
        return this;
    }

    public Table debugCell() {
        super.setDebug(true);
        if (this.debug != Table$Debug.cell) {
            this.debug = Table$Debug.cell;
            ((WidgetGroup)this).invalidate();
        }
        return this;
    }

    public Table debugActor() {
        super.setDebug(true);
        if (this.debug != Table$Debug.actor) {
            this.debug = Table$Debug.actor;
            ((WidgetGroup)this).invalidate();
        }
        return this;
    }

    public Table debug(Table$Debug table$Debug) {
        super.setDebug(table$Debug != Table$Debug.none);
        if (this.debug != table$Debug) {
            this.debug = table$Debug;
            if (table$Debug == Table$Debug.none) {
                this.clearDebugRects();
            } else {
                ((WidgetGroup)this).invalidate();
            }
        }
        return this;
    }

    public Table$Debug getTableDebug() {
        return this.debug;
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadTop() {
        return this.padTop.get(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadLeft() {
        return this.padLeft.get(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadBottom() {
        return this.padBottom.get(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadRight() {
        return this.padRight.get(this);
    }

    public float getPadX() {
        return this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadY() {
        return this.padTop.get(this) + this.padBottom.get(this);
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow(float f2) {
        int n2 = this.cells.size;
        if (n2 == 0) {
            return -1;
        }
        f2 += this.getPadTop();
        T[] TArray = this.cells.items;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            Cell cell;
            Cell cell2 = (Cell)TArray[n3++];
            if (cell.actorY + cell2.computedPadTop < f2) {
                return n4;
            }
            if (!cell2.endRow) continue;
            ++n4;
        }
        return -1;
    }

    public void setSkin(@Null Skin skin) {
        this.skin = skin;
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public float getRowHeight(int n2) {
        if (this.rowHeight == null) {
            return 0.0f;
        }
        return this.rowHeight[n2];
    }

    public float getRowMinHeight(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowMinHeight[n2];
    }

    public float getRowPrefHeight(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowPrefHeight[n2];
    }

    public float getColumnWidth(int n2) {
        if (this.columnWidth == null) {
            return 0.0f;
        }
        return this.columnWidth[n2];
    }

    public float getColumnMinWidth(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnMinWidth[n2];
    }

    public float getColumnPrefWidth(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnPrefWidth[n2];
    }

    private float[] ensureSize(float[] fArray, int n2) {
        if (fArray == null || fArray.length < n2) {
            return new float[n2];
        }
        Arrays.fill(fArray, 0, n2, 0.0f);
        return fArray;
    }

    private void computeSize() {
        int n2;
        float f2;
        float f3;
        int n3;
        this.sizeInvalid = false;
        T[] TArray = this.cells.items;
        int n4 = this.cells.size;
        if (n4 > 0 && !((Cell)TArray[n4 - 1]).endRow) {
            this.endRow();
            this.implicitEndRow = true;
        }
        int n5 = this.columns;
        int n6 = this.rows;
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, n5);
        float[] fArray = this.columnMinWidth;
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, n6);
        float[] fArray2 = this.rowMinHeight;
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, n5);
        float[] fArray3 = this.columnPrefWidth;
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, n6);
        float[] fArray4 = this.rowPrefHeight;
        this.columnWidth = this.ensureSize(this.columnWidth, n5);
        this.rowHeight = this.ensureSize(this.rowHeight, n6);
        this.expandWidth = this.ensureSize(this.expandWidth, n5);
        float[] fArray5 = this.expandWidth;
        this.expandHeight = this.ensureSize(this.expandHeight, n6);
        float[] fArray6 = this.expandHeight;
        float f4 = 0.0f;
        for (int i2 = 0; i2 < n4; ++i2) {
            Cell cell = (Cell)TArray[i2];
            int n7 = cell.column;
            int n8 = cell.row;
            n3 = cell.colspan;
            Actor actor = cell.actor;
            if (cell.expandY != 0 && fArray6[n8] == 0.0f) {
                fArray6[n8] = cell.expandY.intValue();
            }
            if (n3 == 1 && cell.expandX != 0 && fArray5[n7] == 0.0f) {
                fArray5[n7] = cell.expandX.intValue();
            }
            cell.computedPadLeft = cell.padLeft.get(actor) + (n7 == 0 ? 0.0f : Math.max(0.0f, cell.spaceLeft.get(actor) - f4));
            cell.computedPadTop = cell.padTop.get(actor);
            if (cell.cellAboveIndex != -1) {
                Cell cell2 = (Cell)TArray[cell.cellAboveIndex];
                cell.computedPadTop += Math.max(0.0f, cell.spaceTop.get(actor) - cell2.spaceBottom.get(actor));
            }
            f4 = cell.spaceRight.get(actor);
            cell.computedPadRight = cell.padRight.get(actor) + (n7 + n3 == n5 ? 0.0f : f4);
            cell.computedPadBottom = cell.padBottom.get(actor) + (n8 == n6 - 1 ? 0.0f : cell.spaceBottom.get(actor));
            float f5 = cell.prefWidth.get(actor);
            float f6 = cell.prefHeight.get(actor);
            float f7 = cell.minWidth.get(actor);
            f3 = cell.minHeight.get(actor);
            f2 = cell.maxWidth.get(actor);
            float f8 = cell.maxHeight.get(actor);
            if (f5 < f7) {
                f5 = f7;
            }
            if (f6 < f3) {
                f6 = f3;
            }
            if (f2 > 0.0f && f5 > f2) {
                f5 = f2;
            }
            if (f8 > 0.0f && f6 > f8) {
                f6 = f8;
            }
            if (this.round) {
                f7 = (float)Math.ceil(f7);
                f3 = (float)Math.ceil(f3);
                f5 = (float)Math.ceil(f5);
                f6 = (float)Math.ceil(f6);
            }
            if (n3 == 1) {
                f2 = cell.computedPadLeft + cell.computedPadRight;
                fArray3[n7] = Math.max(fArray3[n7], f5 + f2);
                fArray[n7] = Math.max(fArray[n7], f7 + f2);
            }
            f2 = cell.computedPadTop + cell.computedPadBottom;
            fArray4[n8] = Math.max(fArray4[n8], f6 + f2);
            fArray2[n8] = Math.max(fArray2[n8], f3 + f2);
        }
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            int n9;
            Cell cell;
            block28: {
                cell = (Cell)TArray[n3];
                n9 = cell.column;
                int n10 = cell.expandX;
                if (n10 != 0) {
                    int n11;
                    int n12 = n9 + cell.colspan;
                    for (n11 = n9; n11 < n12; ++n11) {
                        if (fArray5[n11] == 0.0f) {
                            continue;
                        }
                        break block28;
                    }
                    for (n11 = n9; n11 < n12; ++n11) {
                        fArray5[n11] = n10;
                    }
                }
            }
            if (cell.uniformX == Boolean.TRUE && cell.colspan == 1) {
                float f13 = cell.computedPadLeft + cell.computedPadRight;
                f9 = Math.max(f9, fArray[n9] - f13);
                f11 = Math.max(f11, fArray3[n9] - f13);
            }
            if (cell.uniformY != Boolean.TRUE) continue;
            float f14 = cell.computedPadTop + cell.computedPadBottom;
            f10 = Math.max(f10, fArray2[cell.row] - f14);
            f12 = Math.max(f12, fArray4[cell.row] - f14);
        }
        if (f11 > 0.0f || f12 > 0.0f) {
            for (n3 = 0; n3 < n4; ++n3) {
                Cell cell = (Cell)TArray[n3];
                if (f11 > 0.0f && cell.uniformX == Boolean.TRUE && cell.colspan == 1) {
                    f4 = cell.computedPadLeft + cell.computedPadRight;
                    fArray[cell.column] = f9 + f4;
                    fArray3[cell.column] = f11 + f4;
                }
                if (!(f12 > 0.0f) || cell.uniformY != Boolean.TRUE) continue;
                f4 = cell.computedPadTop + cell.computedPadBottom;
                fArray2[cell.row] = f10 + f4;
                fArray4[cell.row] = f12 + f4;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n13;
            float f15;
            Cell cell = (Cell)TArray[n3];
            int n14 = cell.colspan;
            if (n14 == 1) continue;
            int n15 = cell.column;
            Actor actor = cell.actor;
            float f16 = cell.minWidth.get(actor);
            f3 = cell.prefWidth.get(actor);
            f2 = cell.maxWidth.get(actor);
            if (f3 < f16) {
                f3 = f16;
            }
            if (f2 > 0.0f && f3 > f2) {
                f3 = f2;
            }
            if (this.round) {
                f16 = (float)Math.ceil(f16);
                f3 = (float)Math.ceil(f3);
            }
            f2 = f15 = -(cell.computedPadLeft + cell.computedPadRight);
            float f17 = 0.0f;
            int n16 = n13 + n14;
            for (n13 = n15; n13 < n16; ++n13) {
                f15 += fArray[n13];
                f2 += fArray3[n13];
                f17 += fArray5[n13];
            }
            f9 = Math.max(0.0f, f16 - f15);
            f10 = Math.max(0.0f, f3 - f2);
            int n17 = n15;
            int n18 = n17 + n14;
            while (n17 < n18) {
                f15 = f17 == 0.0f ? 1.0f / (float)n14 : fArray5[n17] / f17;
                int n19 = n17;
                fArray[n19] = fArray[n19] + f9 * f15;
                int n20 = n17++;
                fArray3[n20] = fArray3[n20] + f10 * f15;
            }
        }
        float f18 = this.padLeft.get(this) + this.padRight.get(this);
        float f19 = this.padTop.get(this) + this.padBottom.get(this);
        this.tableMinWidth = f18;
        this.tablePrefWidth = f18;
        for (n2 = 0; n2 < n5; ++n2) {
            this.tableMinWidth += fArray[n2];
            this.tablePrefWidth += fArray3[n2];
        }
        this.tableMinHeight = f19;
        this.tablePrefHeight = f19;
        for (n2 = 0; n2 < n6; ++n2) {
            this.tableMinHeight += fArray2[n2];
            this.tablePrefHeight += Math.max(fArray2[n2], fArray4[n2]);
        }
        this.tablePrefWidth = Math.max(this.tableMinWidth, this.tablePrefWidth);
        this.tablePrefHeight = Math.max(this.tableMinHeight, this.tablePrefHeight);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layout() {
        int n2;
        float n23;
        float f2;
        float f3;
        float n17;
        int f29;
        void fArray8;
        float[] fArray;
        int n4;
        Object[] objectArray;
        float[] fArray2;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f6 = this.getWidth();
        float f7 = this.getHeight();
        int n5 = this.columns;
        int n6 = this.rows;
        float[] fArray3 = this.columnWidth;
        float[] fArray4 = this.rowHeight;
        float f8 = this.padLeft.get(this);
        float f9 = f8 + this.padRight.get(this);
        float f10 = this.padTop.get(this);
        float f11 = f10 + this.padBottom.get(this);
        float f12 = this.tablePrefWidth - this.tableMinWidth;
        if (f12 == 0.0f) {
            fArray2 = this.columnMinWidth;
        } else {
            float f13 = Math.min(f12, Math.max(0.0f, f6 - this.tableMinWidth));
            columnWeightedWidth = this.ensureSize(columnWeightedWidth, n5);
            fArray2 = columnWeightedWidth;
            float[] fArray5 = this.columnMinWidth;
            objectArray = this.columnPrefWidth;
            for (n4 = 0; n4 < n5; ++n4) {
                reference var17_33 = objectArray[n4] - fArray5[n4];
                reference i2 = var17_33 / f12;
                fArray2[n4] = fArray5[n4] + f13 * i2;
            }
        }
        float f14 = this.tablePrefHeight - this.tableMinHeight;
        if (f14 == 0.0f) {
            fArray = this.rowMinHeight;
        } else {
            void fArray9;
            rowWeightedHeight = this.ensureSize(rowWeightedHeight, n6);
            fArray = rowWeightedHeight;
            float f15 = Math.min(f14, Math.max(0.0f, f7 - this.tableMinHeight));
            float[] fArray6 = this.rowMinHeight;
            float[] fArray7 = this.rowPrefHeight;
            boolean cell = false;
            while (fArray9 < n6) {
                f12 = fArray7[fArray9] - fArray6[fArray9];
                float i4 = f12 / f14;
                fArray[fArray9] = fArray6[fArray9] + f15 * i4;
                ++fArray9;
            }
        }
        objectArray = this.cells.items;
        n4 = this.cells.size;
        boolean i3 = false;
        while (fArray8 < n4) {
            int f30;
            Cell cell = (Cell)objectArray[fArray8];
            int n8 = cell.column;
            int f21 = cell.row;
            Actor actor = cell.actor;
            float f4 = 0.0f;
            f29 = cell.colspan;
            int f31 = f30 + f29;
            for (f30 = n8; f30 < f31; ++f30) {
                f4 += fArray2[f30];
            }
            n17 = fArray[f21];
            float n19 = cell.prefWidth.get(actor);
            f3 = cell.prefHeight.get(actor);
            float snapshotArray = cell.minWidth.get(actor);
            float actorArray = cell.minHeight.get(actor);
            f2 = cell.maxWidth.get(actor);
            n23 = cell.maxHeight.get(actor);
            if (n19 < snapshotArray) {
                n19 = snapshotArray;
            }
            if (f3 < actorArray) {
                f3 = actorArray;
            }
            if (f2 > 0.0f && n19 > f2) {
                n19 = f2;
            }
            if (n23 > 0.0f && f3 > n23) {
                f3 = n23;
            }
            cell.actorWidth = Math.min(f4 - cell.computedPadLeft - cell.computedPadRight, n19);
            cell.actorHeight = Math.min(n17 - cell.computedPadTop - cell.computedPadBottom, f3);
            if (f29 == 1) {
                fArray3[n8] = Math.max(fArray3[n8], f4);
            }
            fArray4[f21] = Math.max(fArray4[f21], n17);
            ++fArray8;
        }
        float[] fArray5 = this.expandWidth;
        float[] fArray6 = this.expandHeight;
        f12 = 0.0f;
        for (int i6 = 0; i6 < n5; ++i6) {
            f12 += fArray5[i6];
        }
        if (f12 > 0.0f) {
            float f23 = f6 - f9;
            for (int i5 = 0; i5 < n5; ++i5) {
                f23 -= fArray3[i5];
            }
            if (f23 > 0.0f) {
                float f22 = 0.0f;
                int n14 = 0;
                for (f29 = 0; f29 < n5; ++f29) {
                    if (fArray5[f29] == 0.0f) continue;
                    n17 = f23 * fArray5[f29] / f12;
                    int n3 = f29;
                    fArray3[n3] = fArray3[n3] + n17;
                    f22 += n17;
                    n14 = f29;
                }
                int n7 = n14;
                fArray3[n7] = fArray3[n7] + (f23 - f22);
            }
        }
        f12 = 0.0f;
        for (int i8 = 0; i8 < n6; ++i8) {
            f12 += fArray6[i8];
        }
        if (f12 > 0.0f) {
            float f27 = f7 - f11;
            for (int i7 = 0; i7 < n6; ++i7) {
                f27 -= fArray4[i7];
            }
            if (f27 > 0.0f) {
                float f24 = 0.0f;
                int n22 = 0;
                for (f29 = 0; f29 < n6; ++f29) {
                    if (fArray6[f29] == 0.0f) continue;
                    n17 = f27 * fArray6[f29] / f12;
                    int n8 = f29;
                    fArray4[n8] = fArray4[n8] + n17;
                    f24 += n17;
                    n22 = f29;
                }
                int n9 = n22;
                fArray4[n9] = fArray4[n9] + (f27 - f24);
            }
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            float f5;
            int n10;
            Cell cell = (Cell)objectArray[i2];
            int n11 = cell.colspan;
            if (n11 == 1) continue;
            float f13 = 0.0f;
            int n12 = n10 + n11;
            for (n10 = cell.column; n10 < n12; ++n10) {
                f13 += fArray2[n10] - fArray3[n10];
            }
            f13 -= Math.max(0.0f, cell.computedPadLeft + cell.computedPadRight);
            f13 /= (float)n11;
            if (!(f5 > 0.0f)) continue;
            n10 = cell.column;
            n12 = n10 + n11;
            while (n10 < n12) {
                int n13 = n10++;
                fArray3[n13] = fArray3[n13] + f13;
            }
        }
        float f15 = f9;
        float f28 = f11;
        for (n2 = 0; n2 < n5; ++n2) {
            f15 += fArray3[n2];
        }
        for (n2 = 0; n2 < n6; ++n2) {
            f28 += fArray4[n2];
        }
        n2 = this.align;
        float f16 = f8;
        if ((n2 & 0x10) != 0) {
            f16 = f8 + (f6 - f15);
        } else if ((n2 & 8) == 0) {
            f16 = f8 + (f6 - f15) / 2.0f;
        }
        float f17 = f10;
        if ((n2 & 4) != 0) {
            f17 = f10 + (f7 - f28);
        } else if ((n2 & 2) == 0) {
            f17 = f10 + (f7 - f28) / 2.0f;
        }
        float f18 = f16;
        f3 = f17;
        for (int i4 = 0; i4 < n4; ++i4) {
            int n14;
            Cell cell = (Cell)objectArray[i4];
            f2 = 0.0f;
            int n22 = n14 + cell.colspan;
            for (n14 = cell.column; n14 < n22; ++n14) {
                f2 += fArray3[n14];
            }
            f2 -= cell.computedPadLeft + cell.computedPadRight;
            f18 += cell.computedPadLeft;
            n23 = cell.fillX.floatValue();
            f6 = cell.fillY.floatValue();
            if (n23 > 0.0f) {
                float f19;
                cell.actorWidth = Math.max(f2 * n23, cell.minWidth.get(cell.actor));
                float f33 = cell.maxWidth.get(cell.actor);
                if (f19 > 0.0f) {
                    cell.actorWidth = Math.min(cell.actorWidth, f33);
                }
            }
            if (f6 > 0.0f) {
                float f20;
                cell.actorHeight = Math.max(fArray4[cell.row] * f6 - cell.computedPadTop - cell.computedPadBottom, cell.minHeight.get(cell.actor));
                float f35 = cell.maxHeight.get(cell.actor);
                if (f20 > 0.0f) {
                    cell.actorHeight = Math.min(cell.actorHeight, f35);
                }
            }
            cell.actorX = ((n2 = cell.align.intValue()) & 8) != 0 ? f18 : ((n2 & 0x10) != 0 ? f18 + f2 - cell.actorWidth : f18 + (f2 - cell.actorWidth) / 2.0f);
            cell.actorY = (n2 & 2) != 0 ? cell.computedPadTop : ((n2 & 4) != 0 ? fArray4[cell.row] - cell.actorHeight - cell.computedPadBottom : (fArray4[cell.row] - cell.actorHeight + cell.computedPadTop - cell.computedPadBottom) / 2.0f);
            cell.actorY = f7 - f3 - cell.actorY - cell.actorHeight;
            if (this.round) {
                cell.actorWidth = (float)Math.ceil(cell.actorWidth);
                cell.actorHeight = (float)Math.ceil(cell.actorHeight);
                cell.actorX = (float)Math.floor(cell.actorX);
                cell.actorY = (float)Math.floor(cell.actorY);
            }
            if (cell.actor != null) {
                cell.actor.setBounds(cell.actorX, cell.actorY, cell.actorWidth, cell.actorHeight);
            }
            if (cell.endRow) {
                f18 = f16;
                f3 += fArray4[cell.row];
                continue;
            }
            f18 += f2 + cell.computedPadRight;
        }
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        Actor[] actorArray = (Actor[])snapshotArray.items;
        int n15 = snapshotArray.size;
        for (int i5 = 0; i5 < n15; ++i5) {
            Actor actor = actorArray[i5];
            if (!(actor instanceof Layout)) continue;
            ((Layout)((Object)actor)).validate();
        }
        if (this.debug != Table$Debug.none) {
            this.addDebugRects(f16, f17, f15 - f9, f28 - f11);
        }
    }

    private void addDebugRects(float f2, float f3, float f4, float f5) {
        this.clearDebugRects();
        if (this.debug == Table$Debug.table || this.debug == Table$Debug.all) {
            this.addDebugRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), debugTableColor);
            this.addDebugRect(f2, this.getHeight() - f3, f4, -f5, debugTableColor);
        }
        f4 = f2;
        int n2 = this.cells.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Cell cell = this.cells.get(i2);
            if (this.debug == Table$Debug.actor || this.debug == Table$Debug.all) {
                this.addDebugRect(cell.actorX, cell.actorY, cell.actorWidth, cell.actorHeight, debugActorColor);
            }
            float f6 = 0.0f;
            int n4 = n3 + cell.colspan;
            for (n3 = cell.column; n3 < n4; ++n3) {
                f6 += this.columnWidth[n3];
            }
            f6 -= cell.computedPadLeft + cell.computedPadRight;
            f2 += cell.computedPadLeft;
            if (this.debug == Table$Debug.cell || this.debug == Table$Debug.all) {
                float f7 = this.rowHeight[cell.row] - cell.computedPadTop - cell.computedPadBottom;
                float f8 = f3 + cell.computedPadTop;
                this.addDebugRect(f2, this.getHeight() - f8, f6, -f7, debugCellColor);
            }
            if (cell.endRow) {
                f2 = f4;
                f3 += this.rowHeight[cell.row];
                continue;
            }
            f2 += f6 + cell.computedPadRight;
        }
    }

    private void clearDebugRects() {
        if (this.debugRects == null) {
            this.debugRects = new Array();
        }
        Table$DebugRect.pool.freeAll(this.debugRects);
        this.debugRects.clear();
    }

    private void addDebugRect(float f2, float f3, float f4, float f5, Color color) {
        Table$DebugRect table$DebugRect = Table$DebugRect.pool.obtain();
        Table$DebugRect.pool.obtain().color = color;
        table$DebugRect.set(f2, f3, f4, f5);
        this.debugRects.add(table$DebugRect);
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        if (this.isTransform()) {
            this.applyTransform(shapeRenderer, this.computeTransform());
            this.drawDebugRects(shapeRenderer);
            if (this.clip) {
                shapeRenderer.flush();
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = this.getWidth();
                float f5 = this.getHeight();
                if (this.background != null) {
                    f2 = this.padLeft.get(this);
                    f3 = this.padBottom.get(this);
                    f4 -= f2 + this.padRight.get(this);
                    f5 -= f3 + this.padTop.get(this);
                }
                if (this.clipBegin(f2, f3, f4, f5)) {
                    this.drawDebugChildren(shapeRenderer);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapeRenderer);
            }
            this.resetTransform(shapeRenderer);
            return;
        }
        this.drawDebugRects(shapeRenderer);
        super.drawDebug(shapeRenderer);
    }

    @Override
    public void drawDebugBounds(ShapeRenderer shapeRenderer) {
    }

    private void drawDebugRects(ShapeRenderer shapeRenderer) {
        if (this.debugRects == null || !this.getDebug()) {
            return;
        }
        shapeRenderer.set(ShapeRenderer$ShapeType.Line);
        if (this.getStage() != null) {
            shapeRenderer.setColor(this.getStage().getDebugColor());
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (!this.isTransform()) {
            f2 = this.getX();
            f3 = this.getY();
        }
        int n2 = this.debugRects.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Table$DebugRect table$DebugRect = this.debugRects.get(i2);
            shapeRenderer.setColor(table$DebugRect.color);
            shapeRenderer.rect(f2 + table$DebugRect.x, f3 + table$DebugRect.y, table$DebugRect.width, table$DebugRect.height);
        }
    }

    @Null
    public Skin getSkin() {
        return this.skin;
    }

    static {
        backgroundTop = new Table$2();
        backgroundLeft = new Table$3();
        backgroundBottom = new Table$4();
        backgroundRight = new Table$5();
    }
}

