/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton$TextButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Null;

public class TextButton
extends Button {
    private Label label;
    private TextButton$TextButtonStyle style;

    public TextButton(@Null String string, Skin skin) {
        this(string, skin.get(TextButton$TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(@Null String string, Skin skin, String string2) {
        this(string, skin.get(string2, TextButton$TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(@Null String string, TextButton$TextButtonStyle textButton$TextButtonStyle) {
        ((Button)this).setStyle(textButton$TextButtonStyle);
        this.label = this.newLabel(string, new Label$LabelStyle(textButton$TextButtonStyle.font, textButton$TextButtonStyle.fontColor));
        this.label.setAlignment(1);
        TextButton textButton = this;
        textButton.add(textButton.label).expand().fill();
        TextButton textButton2 = this;
        textButton2.setSize(((WidgetGroup)textButton2).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    protected Label newLabel(String string, Label$LabelStyle label$LabelStyle) {
        return new Label((CharSequence)string, label$LabelStyle);
    }

    @Override
    public void setStyle(Button$ButtonStyle button$ButtonStyle) {
        if (button$ButtonStyle == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(button$ButtonStyle instanceof TextButton$TextButtonStyle)) {
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        this.style = (TextButton$TextButtonStyle)button$ButtonStyle;
        super.setStyle(button$ButtonStyle);
        if (this.label != null) {
            button$ButtonStyle = (TextButton$TextButtonStyle)button$ButtonStyle;
            Label$LabelStyle label$LabelStyle = this.label.getStyle();
            this.label.getStyle().font = ((TextButton$TextButtonStyle)button$ButtonStyle).font;
            label$LabelStyle.fontColor = ((TextButton$TextButtonStyle)button$ButtonStyle).fontColor;
            this.label.setStyle(label$LabelStyle);
        }
    }

    @Override
    public TextButton$TextButtonStyle getStyle() {
        return this.style;
    }

    @Null
    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDownFontColor != null) {
                return this.style.checkedDownFontColor;
            }
            if (this.style.downFontColor != null) {
                return this.style.downFontColor;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOverFontColor != null) {
                    return this.style.checkedOverFontColor;
                }
            } else if (this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        boolean bl = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (bl && this.style.checkedFocusedFontColor != null) {
                return this.style.checkedFocusedFontColor;
            }
            if (this.style.checkedFontColor != null) {
                return this.style.checkedFontColor;
            }
            if (this.isOver() && this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        if (bl && this.style.focusedFontColor != null) {
            return this.style.focusedFontColor;
        }
        return this.style.fontColor;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.label.getStyle().fontColor = this.getFontColor();
        super.draw(batch, f2);
    }

    public void setLabel(Label label) {
        if (label == null) {
            throw new IllegalArgumentException("label cannot be null.");
        }
        this.getLabelCell().setActor(label);
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell<Label> getLabelCell() {
        TextButton textButton = this;
        return textButton.getCell(textButton.label);
    }

    public void setText(@Null String string) {
        this.label.setText(string);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return (string.indexOf(36) != -1 ? "TextButton " : "") + string + ": " + this.label.getText();
    }
}

