/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Timer;

public class TextField$TextFieldClickListener
extends ClickListener {
    final /* synthetic */ TextField this$0;

    public TextField$TextFieldClickListener(TextField textField) {
        this.this$0 = textField;
    }

    @Override
    public void clicked(InputEvent inputEvent, float f2, float f3) {
        int n2 = this.getTapCount() % 4;
        if (n2 == 0) {
            this.this$0.clearSelection();
        }
        if (n2 == 2) {
            int[] nArray = this.this$0.wordUnderCursor(f2);
            this.this$0.setSelection(nArray[0], nArray[1]);
        }
        if (n2 == 3) {
            this.this$0.selectAll();
        }
    }

    @Override
    public boolean touchDown(InputEvent object, float f2, float f3, int n2, int n3) {
        if (!super.touchDown((InputEvent)object, f2, f3, n2, n3)) {
            return false;
        }
        if (n2 == 0 && n3 != 0) {
            return false;
        }
        if (this.this$0.disabled) {
            return true;
        }
        this.setCursorPosition(f2, f3);
        this.this$0.selectionStart = this.this$0.cursor;
        object = this.this$0.getStage();
        if (object != null) {
            ((Stage)object).setKeyboardFocus(this.this$0);
        }
        this.this$0.keyboard.show(true);
        this.this$0.hasSelection = true;
        return true;
    }

    @Override
    public void touchDragged(InputEvent inputEvent, float f2, float f3, int n2) {
        super.touchDragged(inputEvent, f2, f3, n2);
        this.setCursorPosition(f2, f3);
    }

    @Override
    public void touchUp(InputEvent inputEvent, float f2, float f3, int n2, int n3) {
        if (this.this$0.selectionStart == this.this$0.cursor) {
            this.this$0.hasSelection = false;
        }
        super.touchUp(inputEvent, f2, f3, n2, n3);
    }

    protected void setCursorPosition(float f2, float f3) {
        this.this$0.cursor = this.this$0.letterUnderCursor(f2);
        this.this$0.cursorOn = this.this$0.focused;
        this.this$0.blinkTask.cancel();
        if (this.this$0.focused) {
            Timer.schedule(this.this$0.blinkTask, this.this$0.blinkTime, this.this$0.blinkTime);
        }
    }

    protected void goHome(boolean bl) {
        this.this$0.cursor = 0;
    }

    protected void goEnd(boolean bl) {
        this.this$0.cursor = this.this$0.text.length();
    }

    @Override
    public boolean keyDown(InputEvent inputEvent, int n2) {
        boolean bl;
        boolean bl2;
        block30: {
            boolean bl3;
            block29: {
                if (this.this$0.disabled) {
                    return false;
                }
                this.this$0.cursorOn = this.this$0.focused;
                this.this$0.blinkTask.cancel();
                if (this.this$0.focused) {
                    Timer.schedule(this.this$0.blinkTask, this.this$0.blinkTime, this.this$0.blinkTime);
                }
                if (!this.this$0.hasKeyboardFocus()) {
                    return false;
                }
                bl2 = false;
                int n3 = UIUtils.ctrl();
                bl3 = n3 != 0 && !this.this$0.passwordMode;
                bl = true;
                if (n3 != 0) {
                    switch (n2) {
                        case 50: {
                            this.this$0.paste(this.this$0.clipboard.getContents(), true);
                            bl2 = true;
                            break;
                        }
                        case 31: 
                        case 124: {
                            this.this$0.copy();
                            return true;
                        }
                        case 52: {
                            this.this$0.cut(true);
                            return true;
                        }
                        case 29: {
                            this.this$0.selectAll();
                            return true;
                        }
                        case 54: {
                            String string = this.this$0.text;
                            this.this$0.setText(this.this$0.undoText);
                            this.this$0.undoText = string;
                            this.this$0.updateDisplayText();
                            return true;
                        }
                        default: {
                            bl = false;
                        }
                    }
                }
                if (!UIUtils.shift()) break block29;
                switch (n2) {
                    case 124: {
                        this.this$0.paste(this.this$0.clipboard.getContents(), true);
                        break;
                    }
                    case 112: {
                        this.this$0.cut(true);
                    }
                }
                n3 = this.this$0.cursor;
                switch (n2) {
                    case 21: {
                        this.this$0.moveCursor(false, bl3);
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    case 22: {
                        this.this$0.moveCursor(true, bl3);
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    case 3: {
                        this.goHome(bl3);
                        bl = true;
                        break;
                    }
                    case 123: {
                        this.goEnd(bl3);
                        bl = true;
                        break;
                    }
                    default: {
                        break block30;
                    }
                }
                if (!this.this$0.hasSelection) {
                    this.this$0.selectionStart = n3;
                    this.this$0.hasSelection = true;
                }
                break block30;
            }
            switch (n2) {
                case 21: {
                    this.this$0.moveCursor(false, bl3);
                    this.this$0.clearSelection();
                    bl2 = true;
                    bl = true;
                    break;
                }
                case 22: {
                    this.this$0.moveCursor(true, bl3);
                    this.this$0.clearSelection();
                    bl2 = true;
                    bl = true;
                    break;
                }
                case 3: {
                    this.goHome(bl3);
                    this.this$0.clearSelection();
                    bl = true;
                    break;
                }
                case 123: {
                    this.goEnd(bl3);
                    this.this$0.clearSelection();
                    bl = true;
                }
            }
        }
        this.this$0.cursor = MathUtils.clamp(this.this$0.cursor, 0, this.this$0.text.length());
        if (bl2) {
            this.scheduleKeyRepeatTask(n2);
        }
        return bl;
    }

    protected void scheduleKeyRepeatTask(int n2) {
        if (!this.this$0.keyRepeatTask.isScheduled() || this.this$0.keyRepeatTask.keycode != n2) {
            this.this$0.keyRepeatTask.keycode = n2;
            this.this$0.keyRepeatTask.cancel();
            Timer.schedule(this.this$0.keyRepeatTask, TextField.keyRepeatInitialTime, TextField.keyRepeatTime);
        }
    }

    @Override
    public boolean keyUp(InputEvent inputEvent, int n2) {
        if (this.this$0.disabled) {
            return false;
        }
        this.this$0.keyRepeatTask.cancel();
        return true;
    }

    protected boolean checkFocusTraversal(char c2) {
        return !(!this.this$0.focusTraversal || c2 != '\t' && (c2 != '\r' && c2 != '\n' || !UIUtils.isAndroid && !UIUtils.isIos));
    }

    @Override
    public boolean keyTyped(InputEvent inputEvent, char c2) {
        if (this.this$0.disabled) {
            return false;
        }
        switch (c2) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\r': {
                break;
            }
            default: {
                if (c2 >= ' ') break;
                return false;
            }
        }
        if (!this.this$0.hasKeyboardFocus()) {
            return false;
        }
        if (UIUtils.isMac && Gdx.input.isKeyPressed(63)) {
            return true;
        }
        if (this.checkFocusTraversal(c2)) {
            this.this$0.next(UIUtils.shift());
        } else {
            boolean bl;
            boolean bl2;
            boolean bl3 = c2 == '\r' || c2 == '\n';
            boolean bl4 = c2 == '\u007f';
            boolean bl5 = bl2 = c2 == '\b';
            boolean bl6 = bl3 ? this.this$0.writeEnters : !this.this$0.onlyFontChars || this.this$0.style.font.getData().hasGlyph(c2);
            boolean bl7 = bl = bl2 || bl4;
            if (bl6 || bl) {
                String string = this.this$0.text;
                int n2 = this.this$0.cursor;
                if (bl) {
                    if (this.this$0.hasSelection) {
                        this.this$0.cursor = this.this$0.delete(false);
                    } else {
                        if (bl2 && this.this$0.cursor > 0) {
                            this.this$0.text = this.this$0.text.substring(0, this.this$0.cursor - 1) + this.this$0.text.substring(this.this$0.cursor--);
                            this.this$0.renderOffset = 0.0f;
                        }
                        if (bl4 && this.this$0.cursor < this.this$0.text.length()) {
                            this.this$0.text = this.this$0.text.substring(0, this.this$0.cursor) + this.this$0.text.substring(this.this$0.cursor + 1);
                        }
                    }
                }
                if (bl6 && !bl) {
                    if (!bl3 && this.this$0.filter != null && !this.this$0.filter.acceptChar(this.this$0, c2)) {
                        return true;
                    }
                    if (!this.this$0.withinMaxLength(this.this$0.text.length() - (this.this$0.hasSelection ? Math.abs(this.this$0.cursor - this.this$0.selectionStart) : 0))) {
                        return true;
                    }
                    if (this.this$0.hasSelection) {
                        this.this$0.cursor = this.this$0.delete(false);
                    }
                    String string2 = bl3 ? "\n" : String.valueOf(c2);
                    this.this$0.text = this.this$0.insert(this.this$0.cursor++, string2, this.this$0.text);
                }
                String cfr_ignored_0 = this.this$0.undoText;
                if (this.this$0.changeText(string, this.this$0.text)) {
                    long l2 = System.currentTimeMillis();
                    if (l2 - 750L > this.this$0.lastChangeTime) {
                        this.this$0.undoText = string;
                    }
                    this.this$0.lastChangeTime = l2;
                    this.this$0.updateDisplayText();
                } else if (!this.this$0.text.equals(string)) {
                    this.this$0.cursor = n2;
                }
            }
        }
        if (this.this$0.listener != null) {
            this.this$0.listener.keyTyped(this.this$0, c2);
        }
        return true;
    }
}

