/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;

public abstract class Tree$Node<N extends Tree$Node, V, A extends Actor> {
    A actor;
    N parent;
    final Array<N> children = new Array(0);
    boolean selectable = true;
    boolean expanded;
    Drawable icon;
    float height;
    V value;

    public Tree$Node(A a2) {
        if (a2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        this.actor = a2;
    }

    public Tree$Node() {
    }

    public void setExpanded(boolean n2) {
        if (n2 == this.expanded) {
            return;
        }
        this.expanded = n2;
        if (this.children.size == 0) {
            return;
        }
        Tree<N, V> tree = this.getTree();
        if (tree == null) {
            return;
        }
        T[] TArray = this.children.items;
        int n3 = ((Actor)this.actor).getZIndex() + 1;
        if (n2 != 0) {
            int n4 = this.children.size;
            for (n2 = 0; n2 < n4; ++n2) {
                n3 += ((Tree$Node)TArray[n2]).addToTree(tree, n3);
            }
            return;
        }
        int n5 = this.children.size;
        for (n2 = 0; n2 < n5; ++n2) {
            ((Tree$Node)TArray[n2]).removeFromTree(tree, n3);
        }
    }

    protected int addToTree(Tree<N, V> tree, int n2) {
        tree.addActorAt(n2, (Actor)this.actor);
        if (!this.expanded) {
            return 1;
        }
        int n3 = n2 + 1;
        T[] TArray = this.children.items;
        int n4 = this.children.size;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 += ((Tree$Node)TArray[i2]).addToTree(tree, n3);
        }
        return n3 - n2;
    }

    protected void removeFromTree(Tree<N, V> tree, int n2) {
        tree.removeActorAt(n2, true);
        if (!this.expanded) {
            return;
        }
        T[] TArray = this.children.items;
        int n3 = this.children.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            ((Tree$Node)TArray[i2]).removeFromTree(tree, n2);
        }
    }

    public void add(N n2) {
        Tree$Node tree$Node = this;
        tree$Node.insert(tree$Node.children.size, n2);
    }

    public void addAll(Array<N> array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = this;
            tree$Node.insert(tree$Node.children.size, (Tree$Node)array.get(i2));
        }
    }

    public void insert(int n2, N n3) {
        ((Tree$Node)n3).parent = this;
        this.children.insert(n2, n3);
        if (!this.expanded) {
            return;
        }
        Tree<N, V> tree = this.getTree();
        if (tree != null) {
            if (n2 == 0) {
                n2 = ((Actor)this.actor).getZIndex() + 1;
            } else if (n2 < this.children.size - 1) {
                n2 = ((Actor)((Tree$Node)this.children.get((int)(n2 + 1))).actor).getZIndex();
            } else {
                Tree$Node tree$Node = (Tree$Node)this.children.get(n2 - 1);
                n2 = ((Actor)tree$Node.actor).getZIndex() + tree$Node.countActors();
            }
            ((Tree$Node)n3).addToTree(tree, n2);
        }
    }

    int countActors() {
        if (!this.expanded) {
            return 1;
        }
        int n2 = 1;
        T[] TArray = this.children.items;
        int n3 = this.children.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += ((Tree$Node)TArray[i2]).countActors();
        }
        return n2;
    }

    public void remove() {
        Tree<Tree$Node, V> tree = this.getTree();
        if (tree != null) {
            tree.remove(this);
            return;
        }
        if (this.parent != null) {
            this.parent.remove((Tree$Node)this);
        }
    }

    public void remove(N n2) {
        if (!this.children.removeValue(n2, true)) {
            return;
        }
        if (!this.expanded) {
            return;
        }
        Tree<N, V> tree = this.getTree();
        if (tree != null) {
            ((Tree$Node)n2).removeFromTree(tree, ((Actor)((Tree$Node)n2).actor).getZIndex());
        }
    }

    public void clearChildren() {
        Tree<N, V> tree;
        if (this.expanded && (tree = this.getTree()) != null) {
            int n2 = ((Actor)this.actor).getZIndex() + 1;
            T[] TArray = this.children.items;
            int n3 = this.children.size;
            for (int i2 = 0; i2 < n3; ++i2) {
                ((Tree$Node)TArray[i2]).removeFromTree(tree, n2);
            }
        }
        this.children.clear();
    }

    @Null
    public Tree<N, V> getTree() {
        Group group = ((Actor)this.actor).getParent();
        if (group instanceof Tree) {
            return (Tree)group;
        }
        return null;
    }

    public void setActor(A a2) {
        Tree<N, V> tree;
        if (this.actor != null && (tree = this.getTree()) != null) {
            int n2 = ((Actor)this.actor).getZIndex();
            tree.removeActorAt(n2, true);
            tree.addActorAt(n2, (Actor)a2);
        }
        this.actor = a2;
    }

    public A getActor() {
        return this.actor;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public Array<N> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size > 0;
    }

    public void updateChildren() {
        int n2;
        if (!this.expanded) {
            return;
        }
        Tree<N, V> tree = this.getTree();
        if (tree == null) {
            return;
        }
        T[] TArray = this.children.items;
        int n3 = this.children.size;
        int n4 = ((Actor)this.actor).getZIndex() + 1;
        for (n2 = 0; n2 < n3; ++n2) {
            ((Tree$Node)TArray[n2]).removeFromTree(tree, n4);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += ((Tree$Node)TArray[n2]).addToTree(tree, n4);
        }
    }

    @Null
    public N getParent() {
        return this.parent;
    }

    public void setIcon(@Null Drawable drawable) {
        this.icon = drawable;
    }

    @Null
    public V getValue() {
        return this.value;
    }

    public void setValue(@Null V v2) {
        this.value = v2;
    }

    @Null
    public Drawable getIcon() {
        return this.icon;
    }

    public int getLevel() {
        int n2 = 0;
        Tree$Node<N, V, A> tree$Node = this;
        do {
            ++n2;
        } while ((tree$Node = tree$Node.getParent()) != null);
        return n2;
    }

    @Null
    public N findNode(V v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        if (v2.equals(this.value)) {
            return (N)this;
        }
        return (N)Tree.findNode(this.children, v2);
    }

    public void collapseAll() {
        this.setExpanded(false);
        Tree.collapseAll(this.children);
    }

    public void expandAll() {
        this.setExpanded(true);
        if (this.children.size > 0) {
            Tree.expandAll(this.children);
        }
    }

    public void expandTo() {
        N n2 = this.parent;
        while (n2 != null) {
            ((Tree$Node)n2).setExpanded(true);
            n2 = ((Tree$Node)n2).parent;
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public void findExpandedValues(Array<V> array) {
        if (this.expanded && !Tree.findExpandedValues(this.children, array)) {
            array.add(this.value);
        }
    }

    public void restoreExpandedValues(Array<V> array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            N n3 = this.findNode(array.get(i2));
            if (n3 == null) continue;
            ((Tree$Node)n3).setExpanded(true);
            ((Tree$Node)n3).expandTo();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public boolean isAscendantOf(N n2) {
        if (n2 == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        do {
            if (n2 != this) continue;
            return true;
        } while ((n2 = ((Tree$Node)n2).parent) != null);
        return false;
    }

    public boolean isDescendantOf(N n2) {
        if (n2 == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        Tree$Node<N, V, A> tree$Node = this;
        do {
            if (tree$Node != n2) continue;
            return true;
        } while ((tree$Node = tree$Node.parent) != null);
        return false;
    }
}

