/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Application$ApplicationType;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Tree$1;
import com.badlogic.gdx.scenes.scene2d.ui.Tree$2;
import com.badlogic.gdx.scenes.scene2d.ui.Tree$Node;
import com.badlogic.gdx.scenes.scene2d.ui.Tree$TreeStyle;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;

public class Tree<N extends Tree$Node, V>
extends WidgetGroup {
    private static final Vector2 tmp = new Vector2();
    Tree$TreeStyle style;
    final Array<N> rootNodes = new Array();
    final Selection<N> selection = new Tree$1(this);
    float ySpacing = 4.0f;
    float iconSpacingLeft = 2.0f;
    float iconSpacingRight = 2.0f;
    float paddingLeft;
    float paddingRight;
    float indentSpacing;
    private float prefWidth;
    private float prefHeight;
    private boolean sizeInvalid = true;
    private N foundNode;
    private N overNode;
    N rangeStart;
    private ClickListener clickListener;

    public Tree(Skin skin) {
        this(skin.get(Tree$TreeStyle.class));
    }

    public Tree(Skin skin, String string) {
        this(skin.get(string, Tree$TreeStyle.class));
    }

    public Tree(Tree$TreeStyle tree$TreeStyle) {
        this.selection.setActor(this);
        this.selection.setMultiple(true);
        this.setStyle(tree$TreeStyle);
        this.initialize();
    }

    private void initialize() {
        this.clickListener = new Tree$2(this);
        this.addListener(this.clickListener);
    }

    public void setStyle(Tree$TreeStyle tree$TreeStyle) {
        this.style = tree$TreeStyle;
        if (this.indentSpacing == 0.0f) {
            this.indentSpacing = this.plusMinusWidth();
        }
    }

    public void add(N n2) {
        Tree tree = this;
        tree.insert(tree.rootNodes.size, n2);
    }

    public void insert(int n2, N n3) {
        int n4;
        if (((Tree$Node)n3).parent != null) {
            ((Tree$Node)((Tree$Node)n3).parent).remove(n3);
            ((Tree$Node)n3).parent = null;
        } else {
            n4 = this.rootNodes.indexOf(n3, true);
            if (n4 != -1) {
                if (n4 == n2) {
                    return;
                }
                if (n4 < n2) {
                    --n2;
                }
                this.rootNodes.removeIndex(n4);
                n4 = ((Actor)((Tree$Node)n3).actor).getZIndex();
                if (n4 != -1) {
                    ((Tree$Node)n3).removeFromTree(this, n4);
                }
            }
        }
        this.rootNodes.insert(n2, n3);
        if (n2 == 0) {
            n4 = 0;
        } else if (n2 < this.rootNodes.size - 1) {
            n4 = ((Actor)((Tree$Node)this.rootNodes.get((int)(n2 + 1))).actor).getZIndex();
        } else {
            Tree$Node tree$Node = (Tree$Node)this.rootNodes.get(n2 - 1);
            n4 = ((Actor)tree$Node.actor).getZIndex() + tree$Node.countActors();
        }
        ((Tree$Node)n3).addToTree(this, n4);
    }

    public void remove(N n2) {
        if (((Tree$Node)n2).parent != null) {
            ((Tree$Node)((Tree$Node)n2).parent).remove(n2);
            return;
        }
        if (!this.rootNodes.removeValue(n2, true)) {
            return;
        }
        int n3 = ((Actor)((Tree$Node)n2).actor).getZIndex();
        if (n3 != -1) {
            ((Tree$Node)n2).removeFromTree(this, n3);
        }
    }

    @Override
    public void clearChildren(boolean bl) {
        super.clearChildren(bl);
        this.setOverNode(null);
        this.rootNodes.clear();
        this.selection.clear();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private float plusMinusWidth() {
        float f2 = Math.max(this.style.plus.getMinWidth(), this.style.minus.getMinWidth());
        if (this.style.plusOver != null) {
            f2 = Math.max(f2, this.style.plusOver.getMinWidth());
        }
        if (this.style.minusOver != null) {
            f2 = Math.max(f2, this.style.minusOver.getMinWidth());
        }
        return f2;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = this.plusMinusWidth();
        this.prefHeight = 0.0f;
        Tree tree = this;
        tree.computeSize(tree.rootNodes, 0.0f, this.prefWidth);
        this.prefWidth += this.paddingLeft + this.paddingRight;
    }

    private void computeSize(Array<N> array, float f2, float f3) {
        float f4 = this.ySpacing;
        float f5 = this.iconSpacingLeft + this.iconSpacingRight;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            float f6 = f2 + f3;
            Object object = tree$Node.actor;
            if (object instanceof Layout) {
                object = (Layout)object;
                f6 += object.getPrefWidth();
                tree$Node.height = object.getPrefHeight();
            } else {
                f6 += ((Actor)object).getWidth();
                tree$Node.height = ((Actor)object).getHeight();
            }
            if (tree$Node.icon != null) {
                f6 += f5 + tree$Node.icon.getMinWidth();
                tree$Node.height = Math.max(tree$Node.height, tree$Node.icon.getMinHeight());
            }
            this.prefWidth = Math.max(this.prefWidth, f6);
            this.prefHeight += tree$Node.height + f4;
            if (!tree$Node.expanded) continue;
            this.computeSize(tree$Node.children, f2 + this.indentSpacing, f3);
        }
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        Tree tree = this;
        tree.layout(tree.rootNodes, this.paddingLeft, this.getHeight() - this.ySpacing / 2.0f, this.plusMinusWidth());
    }

    private float layout(Array<N> array, float f2, float f3, float f4) {
        float f5 = this.ySpacing;
        float f6 = this.iconSpacingLeft;
        float f7 = f6 + this.iconSpacingRight;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            float f8 = f2 + f4;
            f8 = tree$Node.icon != null ? (f8 += f7 + tree$Node.icon.getMinWidth()) : (f8 += f6);
            if (tree$Node.actor instanceof Layout) {
                ((Layout)tree$Node.actor).pack();
            }
            ((Actor)tree$Node.actor).setPosition(f8, f3 -= tree$Node.getHeight());
            f3 -= f5;
            if (!tree$Node.expanded) continue;
            f3 = this.layout(tree$Node.children, f2 + this.indentSpacing, f3, f4);
        }
        return f3;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.drawBackground(batch, f2);
        Color color = this.getColor();
        float f3 = color.a * f2;
        batch.setColor(color.r, color.g, color.b, f3);
        this.drawIcons(batch, color.r, color.g, color.b, f3, null, this.rootNodes, this.paddingLeft, this.plusMinusWidth());
        super.draw(batch, f2);
    }

    protected void drawBackground(Batch batch, float f2) {
        if (this.style.background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * f2);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected float drawIcons(Batch batch, float f2, float f3, float f4, float f5, @Null N object, Array<N> array, float f6, float f7) {
        object = this.getCullingArea();
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (object != null) {
            f8 = ((Rectangle)object).y;
            f9 = f8 + ((Rectangle)object).height;
        }
        Tree$TreeStyle tree$TreeStyle = this.style;
        float f10 = this.getX();
        float f11 = this.getY();
        float f12 = f10 + f6;
        float f13 = f12 + f7 + this.iconSpacingLeft;
        float f14 = 0.0f;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            Object object2 = tree$Node.actor;
            f14 = ((Actor)object2).getY();
            float f15 = tree$Node.height;
            if (object == null || f14 + f15 >= f8 && f14 <= f9) {
                if (this.selection.contains(tree$Node) && tree$TreeStyle.selection != null) {
                    this.drawSelection(tree$Node, tree$TreeStyle.selection, batch, f10, f11 + f14 - this.ySpacing / 2.0f, this.getWidth(), f15 + this.ySpacing);
                } else if (tree$Node == this.overNode && tree$TreeStyle.over != null) {
                    this.drawOver(tree$Node, tree$TreeStyle.over, batch, f10, f11 + f14 - this.ySpacing / 2.0f, this.getWidth(), f15 + this.ySpacing);
                }
                if (tree$Node.icon != null) {
                    float f16 = f11 + f14 + (float)Math.round((f15 - tree$Node.icon.getMinHeight()) / 2.0f);
                    object2 = ((Actor)object2).getColor();
                    batch.setColor(((Color)object2).r, ((Color)object2).g, ((Color)object2).b, ((Color)object2).a * f5);
                    Tree$Node tree$Node2 = tree$Node;
                    this.drawIcon(tree$Node2, tree$Node2.icon, batch, f13, f16);
                    batch.setColor(f2, f3, f4, f5);
                }
                if (tree$Node.children.size > 0) {
                    Drawable drawable = this.getExpandIcon(tree$Node, f13);
                    float f17 = f11 + f14 + (float)Math.round((f15 - drawable.getMinHeight()) / 2.0f);
                    this.drawExpandIcon(tree$Node, drawable, batch, f12, f17);
                }
            } else if (f14 < f8) break;
            if (!tree$Node.expanded || tree$Node.children.size <= 0) continue;
            Tree$Node tree$Node3 = tree$Node;
            this.drawIcons(batch, f2, f3, f4, f5, tree$Node3, tree$Node3.children, f6 + this.indentSpacing, f7);
        }
        return f14;
    }

    protected void drawSelection(N n2, Drawable drawable, Batch batch, float f2, float f3, float f4, float f5) {
        drawable.draw(batch, f2, f3, f4, f5);
    }

    protected void drawOver(N n2, Drawable drawable, Batch batch, float f2, float f3, float f4, float f5) {
        drawable.draw(batch, f2, f3, f4, f5);
    }

    protected void drawExpandIcon(N n2, Drawable drawable, Batch batch, float f2, float f3) {
        drawable.draw(batch, f2, f3, drawable.getMinWidth(), drawable.getMinHeight());
    }

    protected void drawIcon(N n2, Drawable drawable, Batch batch, float f2, float f3) {
        drawable.draw(batch, f2, f3, drawable.getMinWidth(), drawable.getMinHeight());
    }

    protected Drawable getExpandIcon(N n2, float f2) {
        if (!(n2 != this.overNode || Gdx.app.getType() != Application$ApplicationType.Desktop || this.selection.getMultiple() && (UIUtils.ctrl() || UIUtils.shift()))) {
            Drawable drawable;
            float f3;
            float f4 = this.screenToLocalCoordinates((Vector2)Tree.tmp.set((float)((float)Gdx.input.getX()), (float)0.0f)).x + this.getX();
            if (f3 >= 0.0f && f4 < f2 && (drawable = ((Tree$Node)n2).expanded ? this.style.minusOver : this.style.plusOver) != null) {
                return drawable;
            }
        }
        if (((Tree$Node)n2).expanded) {
            return this.style.minus;
        }
        return this.style.plus;
    }

    @Null
    public N getNodeAt(float f2) {
        this.foundNode = null;
        Tree tree = this;
        tree.getNodeAt(tree.rootNodes, f2, this.getHeight());
        try {
            N n2 = this.foundNode;
            return n2;
        }
        finally {
            this.foundNode = null;
        }
    }

    private float getNodeAt(Array<N> array, float f2, float f3) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            float f4 = tree$Node.height;
            if (f2 >= (f3 -= tree$Node.getHeight() - f4) - f4 - this.ySpacing && f2 < f3) {
                this.foundNode = tree$Node;
                return -1.0f;
            }
            f3 -= f4 + this.ySpacing;
            if (!tree$Node.expanded || (f3 = this.getNodeAt(tree$Node.children, f2, f3)) != -1.0f) continue;
            return -1.0f;
        }
        return f3;
    }

    void selectNodes(Array<N> array, float f2, float f3) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            if (((Actor)tree$Node.actor).getY() < f2) break;
            if (!tree$Node.isSelectable()) continue;
            if (((Actor)tree$Node.actor).getY() <= f3) {
                this.selection.add(tree$Node);
            }
            if (!tree$Node.expanded) continue;
            this.selectNodes(tree$Node.children, f2, f3);
        }
    }

    public Selection<N> getSelection() {
        return this.selection;
    }

    @Null
    public N getSelectedNode() {
        return (N)((Tree$Node)this.selection.first());
    }

    @Null
    public V getSelectedValue() {
        Tree$Node tree$Node = (Tree$Node)this.selection.first();
        if (tree$Node == null) {
            return null;
        }
        return tree$Node.getValue();
    }

    public Tree$TreeStyle getStyle() {
        return this.style;
    }

    public Array<N> getRootNodes() {
        return this.rootNodes;
    }

    @Deprecated
    public Array<N> getNodes() {
        return this.rootNodes;
    }

    public void updateRootNodes() {
        int n2;
        int n3 = this.rootNodes.size;
        for (n2 = 0; n2 < n3; ++n2) {
            Tree$Node tree$Node = (Tree$Node)this.rootNodes.get(n2);
            int n4 = ((Actor)tree$Node.actor).getZIndex();
            if (n4 == -1) continue;
            tree$Node.removeFromTree(this, n4);
        }
        n3 = this.rootNodes.size;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n5 += ((Tree$Node)this.rootNodes.get(n2)).addToTree(this, n5);
        }
    }

    @Null
    public N getOverNode() {
        return this.overNode;
    }

    @Null
    public V getOverValue() {
        if (this.overNode == null) {
            return null;
        }
        return ((Tree$Node)this.overNode).getValue();
    }

    public void setOverNode(@Null N n2) {
        this.overNode = n2;
    }

    public void setPadding(float f2) {
        this.paddingLeft = f2;
        this.paddingRight = f2;
    }

    public void setPadding(float f2, float f3) {
        this.paddingLeft = f2;
        this.paddingRight = f3;
    }

    public void setIndentSpacing(float f2) {
        this.indentSpacing = f2;
    }

    public float getIndentSpacing() {
        return this.indentSpacing;
    }

    public void setYSpacing(float f2) {
        this.ySpacing = f2;
    }

    public float getYSpacing() {
        return this.ySpacing;
    }

    public void setIconSpacing(float f2, float f3) {
        this.iconSpacingLeft = f2;
        this.iconSpacingRight = f3;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    public void findExpandedValues(Array<V> array) {
        Tree.findExpandedValues(this.rootNodes, array);
    }

    public void restoreExpandedValues(Array<V> array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            N n3 = this.findNode(array.get(i2));
            if (n3 == null) continue;
            ((Tree$Node)n3).setExpanded(true);
            ((Tree$Node)n3).expandTo();
        }
    }

    static boolean findExpandedValues(Array<? extends Tree$Node> array, Array array2) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = array.get(i2);
            if (!tree$Node.expanded || Tree.findExpandedValues(tree$Node.children, array2)) continue;
            array2.add(tree$Node.value);
        }
        return false;
    }

    @Null
    public N findNode(V v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        return (N)Tree.findNode(this.rootNodes, v2);
    }

    @Null
    static Tree$Node findNode(Array<? extends Tree$Node> array, Object object) {
        Tree$Node tree$Node;
        int n2;
        int n3 = array.size;
        for (n2 = 0; n2 < n3; ++n2) {
            tree$Node = array.get(n2);
            if (!object.equals(tree$Node.value)) continue;
            return tree$Node;
        }
        n3 = array.size;
        for (n2 = 0; n2 < n3; ++n2) {
            tree$Node = array.get(n2);
            tree$Node = Tree.findNode(tree$Node.children, object);
            if (tree$Node == null) continue;
            return tree$Node;
        }
        return null;
    }

    public void collapseAll() {
        Tree.collapseAll(this.rootNodes);
    }

    static void collapseAll(Array<? extends Tree$Node> array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = array.get(i2);
            tree$Node.setExpanded(false);
            Tree.collapseAll(tree$Node.children);
        }
    }

    public void expandAll() {
        Tree.expandAll(this.rootNodes);
    }

    static void expandAll(Array<? extends Tree$Node> array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            array.get(i2).expandAll();
        }
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }
}

