/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;

public class WidgetGroup
extends Group
implements Layout {
    private boolean needsLayout = true;
    private boolean fillParent;
    private boolean layoutEnabled = true;

    public WidgetGroup() {
    }

    public WidgetGroup(Actor ... actorArray) {
        for (Actor actor : actorArray) {
            this.addActor(actor);
        }
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getPrefWidth() {
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public void setLayoutEnabled(boolean bl) {
        this.layoutEnabled = bl;
        WidgetGroup widgetGroup = this;
        widgetGroup.setLayoutEnabled(widgetGroup, bl);
    }

    private void setLayoutEnabled(Group object, boolean bl) {
        object = ((Group)object).getChildren();
        int n2 = ((Array)object).size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Actor actor = (Actor)((Array)object).get(i2);
            if (actor instanceof Layout) {
                ((Layout)((Object)actor)).setLayoutEnabled(bl);
                continue;
            }
            if (!(actor instanceof Group)) continue;
            this.setLayoutEnabled((Group)actor, bl);
        }
    }

    @Override
    public void validate() {
        if (!this.layoutEnabled) {
            return;
        }
        Group group = this.getParent();
        if (this.fillParent && group != null) {
            Stage stage = this.getStage();
            if (stage != null && group == stage.getRoot()) {
                this.setSize(stage.getWidth(), stage.getHeight());
            } else {
                this.setSize(group.getWidth(), group.getHeight());
            }
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
        if (this.needsLayout) {
            if (group instanceof WidgetGroup) {
                return;
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                this.needsLayout = false;
                this.layout();
                if (!this.needsLayout) break;
            }
        }
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public void invalidateHierarchy() {
        this.invalidate();
        Group group = this.getParent();
        if (group instanceof Layout) {
            ((Layout)((Object)group)).invalidateHierarchy();
        }
    }

    @Override
    public void childrenChanged() {
        this.invalidateHierarchy();
    }

    @Override
    public void sizeChanged() {
        this.invalidate();
    }

    @Override
    public void pack() {
        WidgetGroup widgetGroup = this;
        widgetGroup.setSize(widgetGroup.getPrefWidth(), this.getPrefHeight());
        this.validate();
        WidgetGroup widgetGroup2 = this;
        widgetGroup2.setSize(widgetGroup2.getPrefWidth(), this.getPrefHeight());
        this.validate();
    }

    @Override
    public void setFillParent(boolean bl) {
        this.fillParent = bl;
    }

    @Override
    public void layout() {
    }

    @Override
    public Actor hit(float f2, float f3, boolean bl) {
        this.validate();
        return super.hit(f2, f3, bl);
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        super.draw(batch, f2);
    }
}

