/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.ObjectSet$ObjectSetIterator;

public class ArraySelection<T>
extends Selection<T> {
    private Array<T> array;
    private boolean rangeSelect = true;
    private T rangeStart;

    public ArraySelection(Array<T> array) {
        this.array = array;
    }

    @Override
    public void choose(T t2) {
        int n2;
        if (t2 == null) {
            throw new IllegalArgumentException("item cannot be null.");
        }
        if (this.isDisabled) {
            return;
        }
        if (!this.rangeSelect || !this.multiple) {
            super.choose(t2);
            return;
        }
        if (this.selected.size > 0 && UIUtils.shift() && (n2 = this.rangeStart == null ? -1 : this.array.indexOf(this.rangeStart, false)) != -1) {
            T t3 = this.rangeStart;
            this.snapshot();
            int n3 = n2;
            int n4 = this.array.indexOf(t2, false);
            if (n2 > n4) {
                n3 = n4;
                n4 = n2;
            }
            if (!UIUtils.ctrl()) {
                ((ObjectSet)this.selected).clear(8);
            }
            while (n3 <= n4) {
                ((ObjectSet)this.selected).add(this.array.get(n3));
                ++n3;
            }
            if (this.fireChangeEvent()) {
                this.revert();
            } else {
                this.changed();
            }
            this.rangeStart = t3;
            this.cleanup();
            return;
        }
        super.choose(t2);
        this.rangeStart = t2;
    }

    @Override
    protected void changed() {
        this.rangeStart = null;
    }

    public boolean getRangeSelect() {
        return this.rangeSelect;
    }

    public void setRangeSelect(boolean bl) {
        this.rangeSelect = bl;
    }

    public void validate() {
        Array array = this.array;
        if (array.size == 0) {
            this.clear();
            return;
        }
        boolean bl = false;
        ObjectSet$ObjectSetIterator objectSet$ObjectSetIterator = this.items().iterator();
        while (objectSet$ObjectSetIterator.hasNext()) {
            Object e2 = objectSet$ObjectSetIterator.next();
            if (array.contains(e2, false)) continue;
            objectSet$ObjectSetIterator.remove();
            bl = true;
        }
        if (this.required && this.selected.size == 0) {
            this.set(array.first());
            return;
        }
        if (bl) {
            this.changed();
        }
    }
}

