/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop$1;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop$Payload;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop$Source;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop$Target;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;

public class DragAndDrop {
    static final Vector2 tmpVector = new Vector2();
    DragAndDrop$Source dragSource;
    DragAndDrop$Payload payload;
    Actor dragActor;
    boolean removeDragActor;
    DragAndDrop$Target target;
    boolean isValidTarget;
    final Array<DragAndDrop$Target> targets = new Array(8);
    final ObjectMap<DragAndDrop$Source, DragListener> sourceListeners = new ObjectMap(8);
    private float tapSquareSize = 8.0f;
    private int button;
    float dragActorX = 0.0f;
    float dragActorY = 0.0f;
    float touchOffsetX;
    float touchOffsetY;
    long dragValidTime;
    int dragTime = 250;
    int activePointer = -1;
    boolean cancelTouchFocus = true;
    boolean keepWithinStage = true;

    public void addSource(DragAndDrop$Source dragAndDrop$Source) {
        DragAndDrop$1 dragAndDrop$1 = new DragAndDrop$1(this, dragAndDrop$Source);
        dragAndDrop$1.setTapSquareSize(this.tapSquareSize);
        dragAndDrop$1.setButton(this.button);
        dragAndDrop$Source.actor.addCaptureListener(dragAndDrop$1);
        this.sourceListeners.put(dragAndDrop$Source, dragAndDrop$1);
    }

    public void removeSource(DragAndDrop$Source dragAndDrop$Source) {
        DragListener dragListener = this.sourceListeners.remove(dragAndDrop$Source);
        dragAndDrop$Source.actor.removeCaptureListener(dragListener);
    }

    public void addTarget(DragAndDrop$Target dragAndDrop$Target) {
        this.targets.add(dragAndDrop$Target);
    }

    public void removeTarget(DragAndDrop$Target dragAndDrop$Target) {
        this.targets.removeValue(dragAndDrop$Target, true);
    }

    public void clear() {
        this.targets.clear();
        for (ObjectMap$Entry objectMap$Entry : this.sourceListeners.entries()) {
            ((DragAndDrop$Source)objectMap$Entry.key).actor.removeCaptureListener((EventListener)objectMap$Entry.value);
        }
        this.sourceListeners.clear(8);
    }

    public void cancelTouchFocusExcept(DragAndDrop$Source dragAndDrop$Source) {
        DragListener dragListener = this.sourceListeners.get(dragAndDrop$Source);
        if (dragListener == null) {
            return;
        }
        Stage stage = dragAndDrop$Source.getActor().getStage();
        if (stage != null) {
            stage.cancelTouchFocusExcept(dragListener, dragAndDrop$Source.getActor());
        }
    }

    public void setTapSquareSize(float f2) {
        this.tapSquareSize = f2;
    }

    public void setButton(int n2) {
        this.button = n2;
    }

    public void setDragActorPosition(float f2, float f3) {
        this.dragActorX = f2;
        this.dragActorY = f3;
    }

    public void setTouchOffset(float f2, float f3) {
        this.touchOffsetX = f2;
        this.touchOffsetY = f3;
    }

    public boolean isDragging() {
        return this.payload != null;
    }

    @Null
    public Actor getDragActor() {
        return this.dragActor;
    }

    @Null
    public DragAndDrop$Payload getDragPayload() {
        return this.payload;
    }

    @Null
    public DragAndDrop$Source getDragSource() {
        return this.dragSource;
    }

    public void setDragTime(int n2) {
        this.dragTime = n2;
    }

    public int getDragTime() {
        return this.dragTime;
    }

    public boolean isDragValid() {
        return this.payload != null && System.currentTimeMillis() >= this.dragValidTime;
    }

    public void setCancelTouchFocus(boolean bl) {
        this.cancelTouchFocus = bl;
    }

    public void setKeepWithinStage(boolean bl) {
        this.keepWithinStage = bl;
    }
}

