/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Align;

public class TiledDrawable
extends TextureRegionDrawable {
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private float scale = 1.0f;
    private int align = 12;

    public TiledDrawable() {
    }

    public TiledDrawable(TextureRegion textureRegion) {
        super(textureRegion);
    }

    public TiledDrawable(TextureRegionDrawable textureRegionDrawable) {
        super(textureRegionDrawable);
    }

    @Override
    public void draw(Batch batch, float f2, float f3, float f4, float f5) {
        float f6 = batch.getPackedColor();
        Batch batch2 = batch;
        batch2.setColor(batch2.getColor().mul(this.color));
        TiledDrawable.draw(batch, this.getRegion(), f2, f3, f4, f5, this.scale, this.align);
        batch.setPackedColor(f6);
    }

    public static void draw(Batch batch, TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, int n2) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16 = (float)textureRegion.getRegionWidth() * f6;
        float f17 = (float)textureRegion.getRegionHeight() * f6;
        Texture texture = textureRegion.getTexture();
        float f18 = (float)((GLTexture)texture).getWidth() * f6;
        f6 = (float)((GLTexture)texture).getHeight() * f6;
        float f19 = textureRegion.getU();
        float f20 = textureRegion.getV();
        float f21 = textureRegion.getU2();
        float f22 = textureRegion.getV2();
        int n3 = (int)(f4 / f16);
        if (Align.isLeft(n2)) {
            f15 = 0.0f;
            f14 = f4 - f16 * (float)n3;
        } else if (Align.isRight(n2)) {
            f15 = f4 - f16 * (float)n3;
            f14 = 0.0f;
        } else if (n3 != 0) {
            float f23;
            n3 = n3 % 2 == 1 ? n3 : n3 - 1;
            f15 = f23 = 0.5f * (f4 - f16 * (float)n3);
            f14 = f23;
        } else {
            f15 = 0.0f;
            f14 = 0.0f;
        }
        int n4 = (int)(f5 / f17);
        if (Align.isTop(n2)) {
            f13 = 0.0f;
            f12 = f5 - f17 * (float)n4;
        } else if (Align.isBottom(n2)) {
            f13 = f5 - f17 * (float)n4;
            f12 = 0.0f;
        } else if (n4 != 0) {
            n4 = n4 % 2 == 1 ? n4 : n4 - 1;
            f13 = f11 = 0.5f * (f5 - f17 * (float)n4);
            f12 = f11;
        } else {
            f13 = 0.0f;
            f12 = 0.0f;
        }
        float f24 = f3;
        if (f15 > 0.0f) {
            float f25;
            f10 = f21 - f15 / f18;
            if (f12 > 0.0f) {
                f25 = f20 + f12 / f6;
                batch.draw(texture, f2, f3, f15, f12, f10, f25, f21, f20);
                f24 = f3 + f12;
            }
            if (n4 == 0 && Align.isCenterVertical(n2)) {
                f25 = 0.5f * (f22 - f20) * (1.0f - f5 / f17);
                f9 = f22 - f25;
                f8 = f20 + f25;
                batch.draw(texture, f2, f24, f15, f5, f10, f9, f21, f8);
                f24 += f5;
            } else {
                for (int i2 = 0; i2 < n4; ++i2) {
                    batch.draw(texture, f2, f24, f15, f17, f10, f22, f21, f20);
                    f24 += f17;
                }
            }
            if (f13 > 0.0f) {
                float f26 = f22 - f13 / f6;
                batch.draw(texture, f2, f24, f15, f13, f10, f22, f21, f26);
            }
        }
        if (f12 > 0.0f) {
            f11 = f2 + f15;
            f24 = f3;
            f10 = f20 + f12 / f6;
            if (n3 == 0 && Align.isCenterHorizontal(n2)) {
                float f27 = 0.5f * (f21 - f19) * (1.0f - f4 / f16);
                f9 = f19 + f27;
                f8 = f21 - f27;
                batch.draw(texture, f11, f3, f4, f12, f9, f10, f8, f20);
            } else {
                for (int i3 = 0; i3 < n3; ++i3) {
                    batch.draw(texture, f11, f3, f16, f12, f19, f10, f21, f20);
                    f11 += f16;
                }
            }
        }
        f11 = f2 + f15;
        int n5 = n3;
        int n6 = n4;
        f9 = f16;
        f8 = f17;
        float f28 = f19;
        float f29 = f21;
        float f30 = f22;
        float f31 = f20;
        if (n3 == 0 && Align.isCenterHorizontal(n2)) {
            n3 = 1;
            f9 = f4;
            f7 = 0.5f * (f21 - f19) * (1.0f - f4 / f16);
            f28 = f19 + f7;
            f29 = f21 - f7;
        }
        if (n4 == 0 && Align.isCenterVertical(n2)) {
            n4 = 1;
            f8 = f5;
            f7 = 0.5f * (f22 - f20) * (1.0f - f5 / f17);
            f30 = f22 - f7;
            f31 = f20 + f7;
        }
        for (int i4 = 0; i4 < n3; ++i4) {
            f24 = f3 + f12;
            for (int i5 = 0; i5 < n4; ++i5) {
                batch.draw(texture, f11, f24, f9, f8, f28, f30, f29, f31);
                f24 += f8;
            }
            f11 += f9;
        }
        n3 = n5;
        n4 = n6;
        if (f13 > 0.0f) {
            f11 = f2 + f15;
            float f32 = f22 - f13 / f6;
            if (n3 == 0 && Align.isCenterHorizontal(n2)) {
                float f33 = 0.5f * (f21 - f19) * (1.0f - f4 / f16);
                f9 = f19 + f33;
                f8 = f21 - f33;
                batch.draw(texture, f11, f24, f4, f13, f9, f22, f8, f32);
                f11 += f4;
            } else {
                for (n6 = 0; n6 < n3; ++n6) {
                    batch.draw(texture, f11, f24, f16, f13, f19, f22, f21, f32);
                    f11 += f16;
                }
            }
        }
        if (f14 > 0.0f) {
            f24 = f3;
            float f34 = f19 + f14 / f18;
            if (f12 > 0.0f) {
                float f35 = f20 + f12 / f6;
                batch.draw(texture, f11, f3, f14, f12, f19, f35, f34, f20);
                f24 = f3 + f12;
            }
            if (n4 == 0 && Align.isCenterVertical(n2)) {
                float f36 = 0.5f * (f22 - f20) * (1.0f - f5 / f17);
                f9 = f22 - f36;
                f8 = f20 + f36;
                batch.draw(texture, f11, f24, f14, f5, f19, f9, f34, f8);
                f24 += f5;
            } else {
                for (int i6 = 0; i6 < n4; ++i6) {
                    batch.draw(texture, f11, f24, f14, f17, f19, f22, f34, f20);
                    f24 += f17;
                }
            }
            if (f13 > 0.0f) {
                float f37 = f22 - f13 / f6;
                batch.draw(texture, f11, f24, f14, f13, f19, f22, f34, f37);
            }
        }
    }

    @Override
    public void draw(Batch batch, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        throw new UnsupportedOperationException();
    }

    public Color getColor() {
        return this.color;
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int n2) {
        this.align = n2;
    }

    @Override
    public TiledDrawable tint(Color color) {
        TiledDrawable tiledDrawable = new TiledDrawable(this);
        tiledDrawable.color.set(color);
        tiledDrawable.setLeftWidth(this.getLeftWidth());
        tiledDrawable.setRightWidth(this.getRightWidth());
        tiledDrawable.setTopHeight(this.getTopHeight());
        tiledDrawable.setBottomHeight(this.getBottomHeight());
        return tiledDrawable;
    }
}

