/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Base64Coder$CharMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.UnsupportedEncodingException;

public class Base64Coder {
    private static final String systemLineSeparator = "\n";
    public static final Base64Coder$CharMap regularMap = new Base64Coder$CharMap('+', '/');
    public static final Base64Coder$CharMap urlsafeMap = new Base64Coder$CharMap('-', '_');

    public static String encodeString(String string) {
        return Base64Coder.encodeString(string, false);
    }

    public static String encodeString(String string, boolean bl) {
        try {
            return new String(Base64Coder.encode(string.getBytes("UTF-8"), bl ? Base64Coder.urlsafeMap.encodingMap : Base64Coder.regularMap.encodingMap));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String encodeLines(byte[] byArray) {
        return Base64Coder.encodeLines(byArray, 0, byArray.length, 76, systemLineSeparator, Base64Coder.regularMap.encodingMap);
    }

    public static String encodeLines(byte[] byArray, int n2, int n3, int n4, String string, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.encodeLines(byArray, n2, n3, n4, string, base64Coder$CharMap.encodingMap);
    }

    public static String encodeLines(byte[] byArray, int n2, int n3, int n4, String string, char[] cArray) {
        int n5;
        if ((n4 = n4 * 3 / 4) <= 0) {
            throw new IllegalArgumentException();
        }
        int n6 = (n3 + n4 - 1) / n4;
        n6 = ((n3 + 2) / 3 << 2) + n6 * string.length();
        StringBuilder stringBuilder = new StringBuilder(n6);
        for (int i2 = 0; i2 < n3; i2 += n5) {
            n5 = Math.min(n3 - i2, n4);
            stringBuilder.append(Base64Coder.encode(byArray, n2 + i2, n5, cArray));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static char[] encode(byte[] byArray) {
        return Base64Coder.encode(byArray, Base64Coder.regularMap.encodingMap);
    }

    public static char[] encode(byte[] byArray, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.encode(byArray, 0, byArray.length, base64Coder$CharMap);
    }

    public static char[] encode(byte[] byArray, char[] cArray) {
        return Base64Coder.encode(byArray, 0, byArray.length, cArray);
    }

    public static char[] encode(byte[] byArray, int n2) {
        return Base64Coder.encode(byArray, 0, n2, Base64Coder.regularMap.encodingMap);
    }

    public static char[] encode(byte[] byArray, int n2, int n3, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.encode(byArray, n2, n3, base64Coder$CharMap.encodingMap);
    }

    public static char[] encode(byte[] byArray, int n2, int n3, char[] cArray) {
        int n4 = ((n3 << 2) + 2) / 3;
        int n5 = (n3 + 2) / 3 << 2;
        char[] cArray2 = new char[n5];
        int n6 = n2;
        n2 += n3;
        n3 = 0;
        while (n6 < n2) {
            int n7 = byArray[n6++] & 0xFF;
            int n8 = n6 < n2 ? byArray[n6++] & 0xFF : 0;
            int n9 = n6 < n2 ? byArray[n6++] & 0xFF : 0;
            int n10 = n7 >>> 2;
            n7 = (n7 & 3) << 4 | n8 >>> 4;
            n8 = (n8 & 0xF) << 2 | n9 >>> 6;
            n9 &= 0x3F;
            cArray2[n3++] = cArray[n10];
            cArray2[n3++] = cArray[n7];
            int n11 = n3;
            cArray2[n11] = n11 < n4 ? cArray[n8] : 61;
            int n12 = ++n3;
            cArray2[n12] = n12 < n4 ? cArray[n9] : 61;
            ++n3;
        }
        return cArray2;
    }

    public static String decodeString(String string) {
        return Base64Coder.decodeString(string, false);
    }

    public static String decodeString(String string, boolean bl) {
        return new String(Base64Coder.decode(string.toCharArray(), bl ? Base64Coder.urlsafeMap.decodingMap : Base64Coder.regularMap.decodingMap));
    }

    public static byte[] decodeLines(String string) {
        return Base64Coder.decodeLines(string, Base64Coder.regularMap.decodingMap);
    }

    public static byte[] decodeLines(String string, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.decodeLines(string, base64Coder$CharMap.decodingMap);
    }

    public static byte[] decodeLines(String string, byte[] byArray) {
        char[] cArray = new char[string.length()];
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t') continue;
            cArray[n2++] = c2;
        }
        return Base64Coder.decode(cArray, 0, n2, byArray);
    }

    public static byte[] decode(String string) {
        return Base64Coder.decode(string.toCharArray());
    }

    public static byte[] decode(String string, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.decode(string.toCharArray(), base64Coder$CharMap);
    }

    public static byte[] decode(char[] cArray, byte[] byArray) {
        return Base64Coder.decode(cArray, 0, cArray.length, byArray);
    }

    public static byte[] decode(char[] cArray, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.decode(cArray, 0, cArray.length, base64Coder$CharMap);
    }

    public static byte[] decode(char[] cArray) {
        return Base64Coder.decode(cArray, 0, cArray.length, Base64Coder.regularMap.decodingMap);
    }

    public static byte[] decode(char[] cArray, int n2, int n3, Base64Coder$CharMap base64Coder$CharMap) {
        return Base64Coder.decode(cArray, n2, n3, base64Coder$CharMap.decodingMap);
    }

    public static byte[] decode(char[] cArray, int n2, int n3, byte[] byArray) {
        if (n3 % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (n3 > 0 && cArray[n2 + n3 - 1] == '=') {
            --n3;
        }
        int n4 = n3 * 3 / 4;
        byte[] byArray2 = new byte[n4];
        int n5 = n2;
        n2 += n3;
        n3 = 0;
        while (n5 < n2) {
            int n6;
            int n7 = cArray[n5++];
            int n8 = cArray[n5++];
            int n9 = n5 < n2 ? cArray[n5++] : 65;
            int n10 = n6 = n5 < n2 ? cArray[n5++] : 65;
            if (n7 > 127 || n8 > 127 || n9 > 127 || n6 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            n7 = byArray[n7];
            n8 = byArray[n8];
            n9 = byArray[n9];
            n6 = byArray[n6];
            if (n7 < 0 || n8 < 0 || n9 < 0 || n6 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            n7 = n7 << 2 | n8 >>> 4;
            n8 = (n8 & 0xF) << 4 | n9 >>> 2;
            n9 = (n9 & 3) << 6 | n6;
            byArray2[n3++] = (byte)n7;
            if (n3 < n4) {
                byArray2[n3++] = (byte)n8;
            }
            if (n3 >= n4) continue;
            byArray2[n3++] = (byte)n9;
        }
        return byArray2;
    }

    private Base64Coder() {
    }
}

