/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Keys;
import com.badlogic.gdx.utils.PropertiesUtils;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.TextFormatter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public class I18NBundle {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static boolean simpleFormatter = false;
    private static boolean exceptionOnMissingKey = true;
    private I18NBundle parent;
    private Locale locale;
    private ObjectMap<String, String> properties;
    private TextFormatter formatter;

    public static boolean getSimpleFormatter() {
        return simpleFormatter;
    }

    public static void setSimpleFormatter(boolean bl) {
        simpleFormatter = bl;
    }

    public static boolean getExceptionOnMissingKey() {
        return exceptionOnMissingKey;
    }

    public static void setExceptionOnMissingKey(boolean bl) {
        exceptionOnMissingKey = bl;
    }

    public static I18NBundle createBundle(FileHandle fileHandle) {
        return I18NBundle.createBundleImpl(fileHandle, Locale.getDefault(), DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(FileHandle fileHandle, Locale locale) {
        return I18NBundle.createBundleImpl(fileHandle, locale, DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(FileHandle fileHandle, String string) {
        return I18NBundle.createBundleImpl(fileHandle, Locale.getDefault(), string);
    }

    public static I18NBundle createBundle(FileHandle fileHandle, Locale locale, String string) {
        return I18NBundle.createBundleImpl(fileHandle, locale, string);
    }

    private static I18NBundle createBundleImpl(FileHandle fileHandle, Locale locale, String string) {
        I18NBundle i18NBundle;
        if (fileHandle == null || locale == null || string == null) {
            throw new NullPointerException();
        }
        I18NBundle i18NBundle2 = null;
        Locale locale2 = locale;
        do {
            List<Locale> list;
            if ((i18NBundle = I18NBundle.loadBundleChain(fileHandle, string, list = I18NBundle.getCandidateLocales(locale2), 0, i18NBundle2)) == null) continue;
            Locale locale3 = i18NBundle.getLocale();
            boolean bl = locale3.equals(ROOT_LOCALE);
            if (!bl || locale3.equals(locale) || list.size() == 1 && locale3.equals(list.get(0))) break;
            if (!bl || i18NBundle2 != null) continue;
            i18NBundle2 = i18NBundle;
        } while ((locale2 = I18NBundle.getFallbackLocale(locale2)) != null);
        if (i18NBundle == null) {
            if (i18NBundle2 == null) {
                throw new MissingResourceException("Can't find bundle for base file handle " + fileHandle.path() + ", locale " + locale, fileHandle + "_" + locale, "");
            }
            i18NBundle = i18NBundle2;
        }
        return i18NBundle;
    }

    private static List<Locale> getCandidateLocales(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (string3.length() > 0) {
            arrayList.add(locale);
        }
        if (string2.length() > 0) {
            ArrayList<Locale> arrayList2 = arrayList;
            arrayList2.add(arrayList2.isEmpty() ? locale : new Locale(string, string2));
        }
        if (string.length() > 0) {
            ArrayList<Locale> arrayList3 = arrayList;
            arrayList3.add(arrayList3.isEmpty() ? locale : new Locale(string));
        }
        arrayList.add(ROOT_LOCALE);
        return arrayList;
    }

    private static Locale getFallbackLocale(Locale locale) {
        Locale locale2 = Locale.getDefault();
        if (locale.equals(locale2)) {
            return null;
        }
        return locale2;
    }

    private static I18NBundle loadBundleChain(FileHandle object, String string, List<Locale> list, int n2, I18NBundle i18NBundle) {
        Locale locale = list.get(n2);
        I18NBundle i18NBundle2 = null;
        if (n2 != list.size() - 1) {
            i18NBundle2 = I18NBundle.loadBundleChain((FileHandle)object, string, list, n2 + 1, i18NBundle);
        } else if (i18NBundle != null && locale.equals(ROOT_LOCALE)) {
            return i18NBundle;
        }
        object = I18NBundle.loadBundle((FileHandle)object, string, locale);
        if (object != null) {
            ((I18NBundle)object).parent = i18NBundle2;
            return object;
        }
        return i18NBundle2;
    }

    private static I18NBundle loadBundle(FileHandle fileHandle, String string, Locale locale) {
        I18NBundle i18NBundle = null;
        Reader reader = null;
        try {
            fileHandle = I18NBundle.toFileHandle(fileHandle, locale);
            if (I18NBundle.checkFileExistence(fileHandle)) {
                i18NBundle = new I18NBundle();
                reader = fileHandle.reader(string);
                i18NBundle.load(reader);
            }
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException(iOException);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
        if (i18NBundle != null) {
            i18NBundle.setLocale(locale);
        }
        return i18NBundle;
    }

    private static boolean checkFileExistence(FileHandle fileHandle) {
        try {
            fileHandle.read().close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void load(Reader reader) {
        this.properties = new ObjectMap();
        PropertiesUtils.load(this.properties, reader);
    }

    private static FileHandle toFileHandle(FileHandle fileHandle, Locale object) {
        StringBuilder stringBuilder = new StringBuilder(fileHandle.name());
        if (!((Locale)object).equals(ROOT_LOCALE)) {
            String string = ((Locale)object).getLanguage();
            String string2 = ((Locale)object).getCountry();
            object = ((Locale)object).getVariant();
            boolean bl = "".equals(string);
            boolean bl2 = "".equals(string2);
            boolean bl3 = "".equals(object);
            if (!(bl && bl2 && bl3)) {
                stringBuilder.append('_');
                if (!bl3) {
                    stringBuilder.append(string).append('_').append(string2).append('_').append((String)object);
                } else if (!bl2) {
                    stringBuilder.append(string).append('_').append(string2);
                } else {
                    stringBuilder.append(string);
                }
            }
        }
        return fileHandle.sibling(stringBuilder.append(".properties").toString());
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
        this.formatter = new TextFormatter(locale, !simpleFormatter);
    }

    public String get(String string) {
        String string2 = this.properties.get(string);
        if (string2 == null) {
            if (this.parent != null) {
                string2 = this.parent.get(string);
            }
            if (string2 == null) {
                if (exceptionOnMissingKey) {
                    throw new MissingResourceException("Can't find bundle key " + string, this.getClass().getName(), string);
                }
                return "???" + string + "???";
            }
        }
        return string2;
    }

    public Set<String> keys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Iterator<String> iterator = this.properties.keys();
        if (iterator != null) {
            iterator = ((ObjectMap$Keys)iterator).iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                linkedHashSet.add(string);
            }
        }
        return linkedHashSet;
    }

    public String format(String string, Object ... objectArray) {
        return this.formatter.format(this.get(string), objectArray);
    }

    public void debug(String string) {
        Iterator<String> iterator = this.properties.keys();
        if (iterator == null) {
            return;
        }
        iterator = ((ObjectMap$Keys)iterator).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            this.properties.put(string2, string);
        }
    }
}

