/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonValue$ValueType;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;

public class JsonReader
implements BaseJsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_indicies = JsonReader.init__json_indicies_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 35;
    static final int json_error = 0;
    static final int json_en_object = 5;
    static final int json_en_array = 23;
    static final int json_en_main = 1;
    private final Array<JsonValue> elements = new Array(8);
    private final Array<JsonValue> lastChild = new Array(8);
    private JsonValue root;
    private JsonValue current;
    private boolean stop;

    public JsonValue parse(String object) {
        object = ((String)object).toCharArray();
        return this.parse((char[])object, 0, ((Object)object).length);
    }

    public JsonValue parse(Reader reader) {
        char[] cArray = new char[1024];
        int n2 = 0;
        try {
            int n3;
            while ((n3 = reader.read(cArray, n2, cArray.length - n2)) != -1) {
                if (n3 == 0) {
                    char[] cArray2 = new char[cArray.length << 1];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                    continue;
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading input.", iOException);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
        return this.parse(cArray, 0, n2);
    }

    @Override
    public JsonValue parse(InputStream closeable) {
        try {
            closeable = new InputStreamReader((InputStream)closeable, "UTF-8");
        }
        catch (Exception exception) {
            throw new SerializationException("Error reading stream.", exception);
        }
        return this.parse((Reader)closeable);
    }

    @Override
    public JsonValue parse(FileHandle fileHandle) {
        Reader reader;
        try {
            reader = fileHandle.reader("UTF-8");
        }
        catch (Exception exception) {
            throw new SerializationException("Error reading file: " + fileHandle, exception);
        }
        try {
            return this.parse(reader);
        }
        catch (Exception exception) {
            throw new SerializationException("Error parsing file: " + fileHandle, exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonValue parse(char[] var1_1, int var2_2, int var3_3) {
        this.stop = false;
        var4_4 = var2_2;
        var6_5 = new int[4];
        var7_6 = 0;
        var8_7 = null;
        var9_8 = false;
        var10_9 = false;
        var11_10 = 0;
        var12_11 = null;
        try {
            var2_2 = 1;
            var5_12 = 0;
            var13_13 = 0;
            block52: while (true) {
                switch (var13_13) {
                    case 0: {
                        if (var4_4 == var3_3) {
                            var13_13 = 4;
                            continue block52;
                        }
                        if (var2_2 == 0) {
                            var13_13 = 5;
                            continue block52;
                        }
                    }
                    case 1: {
                        var15_19 = JsonReader._json_key_offsets[var2_2];
                        var14_17 = JsonReader._json_index_offsets[var2_2];
                        var13_13 = JsonReader._json_single_lengths[var2_2];
                        if (var13_13 <= 0) ** GOTO lbl42
                        var16_22 = var15_19;
                        var18_26 = var15_19 + var13_13 - 1;
                        while (var18_26 >= var16_22) {
                            var17_24 = var16_22 + (var18_26 - var16_22 >> 1);
                            if (var1_1[var4_4] < JsonReader._json_trans_keys[var17_24]) {
                                var18_26 = var17_24 - 1;
                                continue;
                            }
                            if (var1_1[var4_4] > JsonReader._json_trans_keys[var17_24]) {
                                var16_22 = var17_24 + 1;
                                continue;
                            }
                            var14_17 += var17_24 - var15_19;
                            ** GOTO lbl56
                        }
                        var15_19 += var13_13;
                        var14_17 += var13_13;
lbl42:
                        // 2 sources

                        if ((var13_13 = JsonReader._json_range_lengths[var2_2]) > 0) {
                            var16_22 = var15_19;
                            var18_26 = var15_19 + (var13_13 << 1) - 2;
                            while (var18_26 >= var16_22) {
                                var17_24 = var16_22 + (var18_26 - var16_22 >> 1 & -2);
                                if (var1_1[var4_4] < JsonReader._json_trans_keys[var17_24]) {
                                    var18_26 = var17_24 - 2;
                                    continue;
                                }
                                if (var1_1[var4_4] > JsonReader._json_trans_keys[var17_24 + 1]) {
                                    var16_22 = var17_24 + 2;
                                    continue;
                                }
                                var14_17 += var17_24 - var15_19 >> 1;
                                ** GOTO lbl56
                            }
                            var14_17 += var13_13;
                        }
lbl56:
                        // 5 sources

                        var14_17 = JsonReader._json_indicies[var14_17];
                        var2_2 = JsonReader._json_trans_targs[var14_17];
                        if (JsonReader._json_trans_actions[var14_17] == 0) ** GOTO lbl215
                        var13_13 = JsonReader._json_trans_actions[var14_17];
                        var14_17 = JsonReader._json_actions[var13_13++];
                        while (var14_17-- > 0) {
                            switch (JsonReader._json_actions[var13_13++]) {
                                case 0: {
                                    var10_9 = true;
                                    break;
                                }
                                case 1: {
                                    var16_23 = new String(var1_1, var7_6, var4_4 - var7_6);
                                    if (var9_8) {
                                        var16_23 = this.unescape(var16_23);
                                    }
                                    if (!var10_9) ** GOTO lbl74
                                    var10_9 = false;
                                    var8_7 = var16_23;
                                    ** GOTO lbl112
lbl74:
                                    // 1 sources

                                    var17_25 = var8_7;
                                    var8_7 = null;
                                    if (var11_10 == 0) ** GOTO lbl111
                                    if (var16_23.equals("true")) {
                                        this.bool(var17_25, true);
                                    } else if (var16_23.equals("false")) {
                                        this.bool(var17_25, false);
                                    } else if (var16_23.equals("null")) {
                                        this.string(var17_25, null);
                                    } else {
                                        var18_26 = 0;
                                        var15_19 = 1;
                                        block56: for (var11_10 = var7_6; var11_10 < var4_4; ++var11_10) {
                                            switch (var1_1[var11_10]) {
                                                case '+': 
                                                case '-': 
                                                case '0': 
                                                case '1': 
                                                case '2': 
                                                case '3': 
                                                case '4': 
                                                case '5': 
                                                case '6': 
                                                case '7': 
                                                case '8': 
                                                case '9': {
                                                    continue block56;
                                                }
                                                case '.': 
                                                case 'E': 
                                                case 'e': {
                                                    var18_26 = 1;
                                                    var15_19 = 0;
                                                    continue block56;
                                                }
                                                default: {
                                                    var18_26 = 0;
                                                    var15_19 = 0;
                                                    break block56;
                                                }
                                            }
                                        }
                                        if (var18_26 != 0) {
                                            try {
                                                this.number(var17_25, Double.parseDouble(var16_23), var16_23);
                                            }
                                            catch (NumberFormatException v0) {
                                            }
                                        } else if (var15_19 != 0) {
                                            try {
                                                this.number(var17_25, Long.parseLong(var16_23), var16_23);
                                            }
                                            catch (NumberFormatException v1) {}
                                        }
lbl111:
                                        // 5 sources

                                        this.string(var17_25, var16_23);
                                    }
lbl112:
                                    // 7 sources

                                    if (this.stop) break block52;
                                    var11_10 = 0;
                                    var7_6 = var4_4;
                                    break;
                                }
                                case 2: {
                                    this.startObject(var8_7);
                                    if (this.stop) break block52;
                                    var8_7 = null;
                                    if (var5_12 == var6_5.length) {
                                        var6_5 = Arrays.copyOf(var6_5, var6_5.length << 1);
                                    }
                                    var6_5[var5_12++] = var2_2;
                                    var2_2 = 5;
                                    var13_13 = 2;
                                    continue block52;
                                }
                                case 3: {
                                    this.pop();
                                    if (this.stop) break block52;
                                    var2_2 = var6_5[--var5_12];
                                    var13_13 = 2;
                                    continue block52;
                                }
                                case 4: {
                                    this.startArray(var8_7);
                                    if (this.stop) break block52;
                                    var8_7 = null;
                                    if (var5_12 == var6_5.length) {
                                        var6_5 = Arrays.copyOf(var6_5, var6_5.length << 1);
                                    }
                                    var6_5[var5_12++] = var2_2;
                                    var2_2 = 23;
                                    var13_13 = 2;
                                    continue block52;
                                }
                                case 5: {
                                    this.pop();
                                    if (this.stop) break block52;
                                    var2_2 = var6_5[--var5_12];
                                    var13_13 = 2;
                                    continue block52;
                                }
                                case 6: {
                                    if (var1_1[var4_4++] == '/') {
                                        while (var4_4 != var3_3 && var1_1[var4_4] != '\n') {
                                            ++var4_4;
                                        }
                                        --var4_4;
                                        break;
                                    }
                                    while (var4_4 + 1 < var3_3 && (var1_1[var4_4] != '*' || var1_1[var4_4 + 1] != '/')) {
                                        ++var4_4;
                                    }
                                    ++var4_4;
                                    break;
                                }
                                case 7: {
                                    var7_6 = var4_4;
                                    var9_8 = false;
                                    var11_10 = 1;
                                    if (!var10_9) ** GOTO lbl183
                                    block59: while (true) {
                                        switch (var1_1[var4_4]) {
                                            case '\\': {
                                                var9_8 = true;
                                                ** GOTO lbl179
                                            }
                                            case '/': {
                                                if (var4_4 + 1 == var3_3) ** GOTO lbl179
                                                var16_22 = var1_1[var4_4 + 1];
                                                if (var16_22 == 47) ** GOTO lbl196
                                                if (var16_22 == 42) {
                                                    break block59;
                                                }
                                                ** GOTO lbl179
                                            }
                                            case '\n': 
                                            case '\r': 
                                            case ':': {
                                                break block59;
                                            }
lbl179:
                                            // 4 sources

                                            default: {
                                                if (++var4_4 != var3_3) continue block59;
                                                break block59;
                                            }
                                        }
                                        break;
                                    }
                                    ** GOTO lbl196
lbl183:
                                    // 1 sources

                                    block60: while (true) {
                                        switch (var1_1[var4_4]) {
                                            case '\\': {
                                                var9_8 = true;
                                                ** GOTO lbl194
                                            }
                                            case '/': {
                                                if (var4_4 + 1 != var3_3 && ((var16_22 = var1_1[var4_4 + 1]) == 47 || var16_22 == 42)) {
                                                    break block60;
                                                }
                                                ** GOTO lbl194
                                            }
                                            case '\n': 
                                            case '\r': 
                                            case ',': 
                                            case ']': 
                                            case '}': {
                                                break block60;
                                            }
lbl194:
                                            // 3 sources

                                            default: {
                                                if (++var4_4 != var3_3) continue block60;
                                            }
                                        }
                                        break;
                                    }
lbl196:
                                    // 6 sources

                                    while (Character.isSpace(var1_1[--var4_4])) {
                                    }
                                    break;
                                }
                                case 8: {
                                    var7_6 = ++var4_4;
                                    var9_8 = false;
                                    block62: while (true) {
                                        switch (var1_1[var4_4]) {
                                            case '\\': {
                                                var9_8 = true;
                                                ++var4_4;
                                                ** GOTO lbl210
                                            }
                                            case '\"': {
                                                break block62;
                                            }
lbl210:
                                            // 2 sources

                                            default: {
                                                if (++var4_4 != var3_3) continue block62;
                                            }
                                        }
                                        break;
                                    }
                                    --var4_4;
                                }
                            }
                        }
                    }
lbl215:
                    // 3 sources

                    case 2: {
                        if (var2_2 == 0) {
                            var13_13 = 5;
                            continue block52;
                        }
                        if (++var4_4 != var3_3) {
                            var13_13 = 1;
                            continue block52;
                        }
                    }
                    case 4: {
                        if (var4_4 != var3_3) break block52;
                        var16_22 = JsonReader._json_eof_actions[var2_2];
                        var17_24 = JsonReader._json_actions[var16_22++];
                        while (var17_24-- > 0) {
                            switch (JsonReader._json_actions[var16_22++]) {
                                case 1: {
                                    var18_28 = new String(var1_1, var7_6, var4_4 - var7_6);
                                    if (var9_8) {
                                        var18_28 = this.unescape(var18_28);
                                    }
                                    if (!var10_9) ** GOTO lbl236
                                    var10_9 = false;
                                    var8_7 = var18_28;
                                    ** GOTO lbl274
lbl236:
                                    // 1 sources

                                    var15_21 = var8_7;
                                    var8_7 = null;
                                    if (var11_10 == 0) ** GOTO lbl273
                                    if (var18_28.equals("true")) {
                                        this.bool(var15_21, true);
                                    } else if (var18_28.equals("false")) {
                                        this.bool(var15_21, false);
                                    } else if (var18_28.equals("null")) {
                                        this.string(var15_21, null);
                                    } else {
                                        var11_10 = 0;
                                        var2_2 = 1;
                                        block64: for (var5_12 = var7_6; var5_12 < var4_4; ++var5_12) {
                                            switch (var1_1[var5_12]) {
                                                case '+': 
                                                case '-': 
                                                case '0': 
                                                case '1': 
                                                case '2': 
                                                case '3': 
                                                case '4': 
                                                case '5': 
                                                case '6': 
                                                case '7': 
                                                case '8': 
                                                case '9': {
                                                    continue block64;
                                                }
                                                case '.': 
                                                case 'E': 
                                                case 'e': {
                                                    var11_10 = 1;
                                                    var2_2 = 0;
                                                    continue block64;
                                                }
                                                default: {
                                                    var11_10 = 0;
                                                    var2_2 = 0;
                                                    break block64;
                                                }
                                            }
                                        }
                                        if (var11_10 != 0) {
                                            try {
                                                this.number(var15_21, Double.parseDouble(var18_28), var18_28);
                                            }
                                            catch (NumberFormatException v2) {
                                            }
                                        } else if (var2_2 != 0) {
                                            try {
                                                this.number(var15_21, Long.parseLong(var18_28), var18_28);
                                            }
                                            catch (NumberFormatException v3) {}
                                        }
lbl273:
                                        // 5 sources

                                        this.string(var15_21, var18_28);
                                    }
lbl274:
                                    // 7 sources

                                    if (this.stop) break block52;
                                    var11_10 = 0;
                                    var7_6 = var4_4;
                                }
                            }
                        }
                        break block52;
                    }
                }
                break;
            }
        }
        catch (RuntimeException v4) {
            var13_14 = v4;
            var12_11 = v4;
        }
        var13_15 = this.root;
        this.root = null;
        this.current = null;
        this.lastChild.clear();
        if (!this.stop) {
            if (var4_4 < var3_3) {
                var14_17 = 1;
                for (var13_16 = 0; var13_16 < var4_4; ++var13_16) {
                    if (var1_1[var13_16] != '\n') continue;
                    ++var14_17;
                }
                var13_16 = Math.max(0, var4_4 - 32);
                throw new SerializationException("Error parsing JSON on line " + var14_17 + " near: " + new String(var1_1, var13_16, var4_4 - var13_16) + "*ERROR*" + new String(var1_1, var4_4, Math.min(64, var3_3 - var4_4)), var12_11);
            }
            if (this.elements.size != 0) {
                var14_18 = this.elements.peek();
                this.elements.clear();
                if (var14_18 != null && var14_18.isObject()) {
                    throw new SerializationException("Error parsing JSON, unmatched brace.");
                }
                throw new SerializationException("Error parsing JSON, unmatched bracket.");
            }
            if (var12_11 != null) {
                throw new SerializationException("Error parsing JSON: " + new String(var1_1), var12_11);
            }
        }
        return var13_15;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 2, 0, 7, 2, 0, 8, 2, 1, 3, 2, 1, 5};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 11, 13, 14, 16, 25, 31, 37, 39, 50, 57, 64, 73, 74, 83, 85, 87, 96, 98, 100, 101, 103, 105, 116, 123, 130, 141, 142, 153, 155, 157, 168, 170, 172, 174, 179, 184, 184};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{'\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '\t', '\n', '*', '/', '\"', '*', '/', '\r', ' ', '\"', ',', '/', ':', '}', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '\t', '\n', '\t', '\n', '\r', ' ', ',', '/', '}', '\t', '\n', '\r', ' ', ',', '/', '}', '\r', ' ', '\"', ',', '/', ':', '}', '\t', '\n', '\"', '\r', ' ', '\"', ',', '/', ':', '}', '\t', '\n', '*', '/', '*', '/', '\r', ' ', '\"', ',', '/', ':', '}', '\t', '\n', '*', '/', '*', '/', '\"', '*', '/', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '\t', '\n', '\t', '\n', '\r', ' ', ',', '/', ']', '\t', '\n', '\r', ' ', ',', '/', ']', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '\t', '\n', '\"', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '\t', '\n', '*', '/', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '\t', '\n', '*', '/', '*', '/', '*', '/', '\r', ' ', '/', '\t', '\n', '\r', ' ', '/', '\t', '\n', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 9, 2, 1, 2, 7, 4, 4, 2, 9, 7, 7, 7, 1, 7, 2, 2, 7, 2, 2, 1, 2, 2, 9, 7, 7, 9, 1, 9, 2, 2, 9, 2, 2, 2, 3, 3, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 11, 14, 16, 19, 28, 34, 40, 43, 54, 62, 70, 79, 81, 90, 93, 96, 105, 108, 111, 113, 116, 119, 130, 138, 146, 157, 159, 170, 173, 176, 187, 190, 193, 196, 201, 206, 207};
    }

    private static byte[] init__json_indicies_0() {
        return new byte[]{1, 1, 2, 3, 4, 3, 5, 3, 6, 1, 0, 7, 7, 3, 8, 3, 9, 9, 3, 11, 11, 12, 13, 14, 3, 15, 11, 10, 16, 16, 17, 18, 16, 3, 19, 19, 20, 21, 19, 3, 22, 22, 3, 21, 21, 24, 3, 25, 3, 26, 3, 27, 21, 23, 28, 29, 29, 28, 30, 31, 32, 3, 33, 34, 34, 33, 13, 35, 15, 3, 34, 34, 12, 36, 37, 3, 15, 34, 10, 16, 3, 36, 36, 12, 3, 38, 3, 3, 36, 10, 39, 39, 3, 40, 40, 3, 13, 13, 12, 3, 41, 3, 15, 13, 10, 42, 42, 3, 43, 43, 3, 28, 3, 44, 44, 3, 45, 45, 3, 47, 47, 48, 49, 50, 3, 51, 52, 53, 47, 46, 54, 55, 55, 54, 56, 57, 58, 3, 59, 60, 60, 59, 49, 61, 52, 3, 60, 60, 48, 62, 63, 3, 51, 52, 53, 60, 46, 54, 3, 62, 62, 48, 3, 64, 3, 51, 3, 53, 62, 46, 65, 65, 3, 66, 66, 3, 49, 49, 48, 3, 67, 3, 51, 52, 53, 49, 46, 68, 68, 3, 69, 69, 3, 70, 70, 3, 8, 8, 71, 8, 3, 72, 72, 73, 72, 3, 3, 3, 0};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{35, 1, 3, 0, 4, 36, 36, 36, 36, 1, 6, 5, 13, 17, 22, 37, 7, 8, 9, 7, 8, 9, 7, 10, 20, 21, 11, 11, 11, 12, 17, 19, 37, 11, 12, 19, 14, 16, 15, 14, 12, 18, 17, 11, 9, 5, 24, 23, 27, 31, 34, 25, 38, 25, 25, 26, 31, 33, 38, 25, 26, 33, 28, 30, 29, 28, 26, 32, 31, 25, 23, 2, 36, 2};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{13, 0, 15, 0, 0, 7, 3, 11, 1, 11, 17, 0, 20, 0, 0, 5, 1, 1, 1, 0, 0, 0, 11, 13, 15, 0, 7, 3, 1, 1, 1, 1, 23, 0, 0, 0, 0, 0, 0, 11, 11, 0, 11, 11, 11, 11, 13, 0, 15, 0, 0, 7, 9, 3, 1, 1, 1, 1, 26, 0, 0, 0, 0, 0, 0, 11, 11, 0, 11, 11, 11, 1, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0};
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop;
    }

    private void addChild(@Null String object, JsonValue jsonValue) {
        jsonValue.setName((String)object);
        if (this.current == null) {
            this.current = jsonValue;
            this.root = jsonValue;
            return;
        }
        if (this.current.isArray() || this.current.isObject()) {
            jsonValue.parent = this.current;
            if (this.current.size == 0) {
                this.current.child = jsonValue;
            } else {
                object = this.lastChild.pop();
                this.lastChild.pop().next = jsonValue;
                jsonValue.prev = object;
            }
            this.lastChild.add(jsonValue);
            ++this.current.size;
            return;
        }
        this.root = this.current;
    }

    protected void startObject(@Null String string) {
        JsonValue jsonValue = new JsonValue(JsonValue$ValueType.object);
        if (this.current != null) {
            this.addChild(string, jsonValue);
        }
        this.elements.add(jsonValue);
        this.current = jsonValue;
    }

    protected void startArray(@Null String string) {
        JsonValue jsonValue = new JsonValue(JsonValue$ValueType.array);
        if (this.current != null) {
            this.addChild(string, jsonValue);
        }
        this.elements.add(jsonValue);
        this.current = jsonValue;
    }

    protected void pop() {
        this.root = this.elements.pop();
        if (this.current.size > 0) {
            this.lastChild.pop();
        }
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(@Null String string, String string2) {
        this.addChild(string, new JsonValue(string2));
    }

    protected void number(@Null String string, double d2, String string2) {
        this.addChild(string, new JsonValue(d2, string2));
    }

    protected void number(@Null String string, long l2, String string2) {
        this.addChild(string, new JsonValue(l2, string2));
    }

    protected void bool(@Null String string, boolean bl) {
        this.addChild(string, new JsonValue(bl));
    }

    protected String unescape(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 16);
        int n3 = 0;
        while (n3 < n2) {
            char c2;
            if ((c2 = string.charAt(n3++)) != '\\') {
                stringBuilder.append(c2);
                continue;
            }
            if (n3 == n2) break;
            if ((c2 = string.charAt(n3++)) == 'u') {
                int n4 = n3;
                stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(n4, n4 + 4), 16)));
                n3 += 4;
                continue;
            }
            switch (c2) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c2 = '\b';
                    break;
                }
                case 'f': {
                    c2 = '\f';
                    break;
                }
                case 'n': {
                    c2 = '\n';
                    break;
                }
                case 'r': {
                    c2 = '\r';
                    break;
                }
                case 't': {
                    c2 = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c2);
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

