/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonString$JsonObject;
import com.badlogic.gdx.utils.JsonWriter$OutputType;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.StringBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonString {
    final StringBuilder buffer;
    private final Array<JsonString$JsonObject> stack = new Array();
    private JsonString$JsonObject current;
    private boolean named;
    private JsonWriter$OutputType outputType = JsonWriter$OutputType.json;
    private boolean quoteLongValues = false;

    public JsonString() {
        this.buffer = new StringBuilder();
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setOutputType(JsonWriter$OutputType jsonWriter$OutputType) {
        this.outputType = jsonWriter$OutputType;
    }

    public void setQuoteLongValues(boolean bl) {
        this.quoteLongValues = bl;
    }

    public JsonString name(String string) {
        if (this.current == null || this.current.array) {
            throw new IllegalStateException("Current item must be an object.");
        }
        if (!this.current.needsComma) {
            this.current.needsComma = true;
        } else {
            this.buffer.append(',');
        }
        this.buffer.append(this.outputType.quoteName(string));
        this.buffer.append(':');
        this.named = true;
        return this;
    }

    public JsonString object() {
        this.requireCommaOrName();
        this.current = new JsonString$JsonObject(this, false);
        this.stack.add(this.current);
        return this;
    }

    public JsonString array() {
        this.requireCommaOrName();
        this.current = new JsonString$JsonObject(this, true);
        this.stack.add(this.current);
        return this;
    }

    public JsonString value(@Null Object object) {
        if (this.quoteLongValues && (object instanceof Long || object instanceof Double || object instanceof BigDecimal || object instanceof BigInteger)) {
            object = object.toString();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            long l2 = number.longValue();
            if (number.doubleValue() == (double)l2) {
                object = l2;
            }
        }
        this.requireCommaOrName();
        this.buffer.append(this.outputType.quoteValue(object));
        return this;
    }

    public JsonString json(String string) {
        this.requireCommaOrName();
        this.buffer.append(string);
        return this;
    }

    private void requireCommaOrName() {
        if (this.current == null) {
            return;
        }
        if (this.current.array) {
            if (!this.current.needsComma) {
                this.current.needsComma = true;
                return;
            }
            this.buffer.append(',');
            return;
        }
        if (!this.named) {
            throw new IllegalStateException("Name must be set.");
        }
        this.named = false;
    }

    public JsonString object(String string) {
        return this.name(string).object();
    }

    public JsonString array(String string) {
        return this.name(string).array();
    }

    public JsonString set(String string, Object object) {
        return this.name(string).value(object);
    }

    public JsonString json(String string, String string2) {
        return this.name(string).json(string2);
    }

    public JsonString pop() {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        this.stack.pop().close();
        this.current = this.stack.size == 0 ? null : this.stack.peek();
        return this;
    }

    public JsonString close() {
        while (this.stack.size > 0) {
            this.pop();
        }
        return this;
    }

    public void reset() {
        this.buffer.clear();
        this.stack.clear();
        this.current = null;
        this.named = false;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

