/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.regex.Pattern;

public enum JsonWriter$OutputType {
    json,
    javascript,
    minimal;

    private static Pattern javascriptPattern;
    private static Pattern minimalNamePattern;
    private static Pattern minimalValuePattern;

    public final String quoteValue(@Null Object object) {
        int n2;
        if (object == null) {
            return "null";
        }
        String string = object.toString();
        if (object instanceof Number || object instanceof Boolean) {
            return string;
        }
        object = new StringBuilder(string);
        ((StringBuilder)object).replace('\\', "\\\\").replace('\r', "\\r").replace('\n', "\\n").replace('\t', "\\t");
        if (!(this != minimal || string.equals("true") || string.equals("false") || string.equals("null") || string.contains("//") || string.contains("/*") || (n2 = ((StringBuilder)object).length()) <= 0 || ((StringBuilder)object).charAt(n2 - 1) == ' ' || !minimalValuePattern.matcher((CharSequence)object).matches())) {
            return ((StringBuilder)object).toString();
        }
        return "\"" + ((StringBuilder)object).replace('\"', "\\\"").toString() + '\"';
    }

    public final String quoteName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.replace('\\', "\\\\").replace('\r', "\\r").replace('\n', "\\n").replace('\t', "\\t");
        switch (this) {
            case minimal: {
                if (!string.contains("//") && !string.contains("/*") && minimalNamePattern.matcher(stringBuilder).matches()) {
                    return stringBuilder.toString();
                }
            }
            case javascript: {
                if (!javascriptPattern.matcher(stringBuilder).matches()) break;
                return stringBuilder.toString();
            }
        }
        return "\"" + stringBuilder.replace('\"', "\\\"").toString() + '\"';
    }

    static {
        javascriptPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
        minimalNamePattern = Pattern.compile("^[^\":,}/ ][^:]*$");
        minimalValuePattern = Pattern.compile("^[^\":,{\\[\\]/ ][^}\\],]*$");
    }
}

