/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.LongMap;

class LongMap$MapIterator<V> {
    private static final int INDEX_ILLEGAL = -2;
    static final int INDEX_ZERO = -1;
    public boolean hasNext;
    final LongMap<V> map;
    int nextIndex;
    int currentIndex;
    boolean valid = true;

    public LongMap$MapIterator(LongMap<V> longMap) {
        this.map = longMap;
        this.reset();
    }

    public void reset() {
        this.currentIndex = -2;
        this.nextIndex = -1;
        if (this.map.hasZeroValue) {
            this.hasNext = true;
            return;
        }
        this.findNextIndex();
    }

    void findNextIndex() {
        long[] lArray = this.map.keyTable;
        int n2 = this.map.keyTable.length;
        while (++this.nextIndex < n2) {
            if (lArray[this.nextIndex] == 0L) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }

    public void remove() {
        int n2 = this.currentIndex;
        if (n2 == -1 && this.map.hasZeroValue) {
            this.map.hasZeroValue = false;
            this.map.zeroValue = null;
        } else {
            long l2;
            if (n2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            long[] lArray = this.map.keyTable;
            V[] VArray = this.map.valueTable;
            int n3 = this.map.mask;
            int n4 = n2 + 1 & n3;
            while ((l2 = lArray[n4]) != 0L) {
                int n5 = this.map.place(l2);
                if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                    lArray[n2] = l2;
                    VArray[n2] = VArray[n4];
                    n2 = n4;
                }
                n4 = n4 + 1 & n3;
            }
            lArray[n2] = 0L;
            VArray[n2] = null;
            if (n2 != this.currentIndex) {
                --this.nextIndex;
            }
        }
        this.currentIndex = -2;
        --this.map.size;
    }
}

