/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.LongMap$Entries;
import com.badlogic.gdx.utils.LongMap$Entry;
import com.badlogic.gdx.utils.LongMap$Keys;
import com.badlogic.gdx.utils.LongMap$Values;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;
import java.util.Iterator;

public class LongMap<V>
implements Iterable<LongMap$Entry<V>> {
    public int size;
    long[] keyTable;
    V[] valueTable;
    V zeroValue;
    boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    protected int shift;
    protected int mask;
    private transient LongMap$Entries entries1;
    private transient LongMap$Entries entries2;
    private transient LongMap$Values values1;
    private transient LongMap$Values values2;
    private transient LongMap$Keys keys1;
    private transient LongMap$Keys keys2;

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int n2) {
        this(n2, 0.8f);
    }

    public LongMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + f2);
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[n2];
        this.valueTable = new Object[n2];
    }

    public LongMap(LongMap<? extends V> longMap) {
        this((int)((float)longMap.keyTable.length * longMap.loadFactor), longMap.loadFactor);
        System.arraycopy(longMap.keyTable, 0, this.keyTable, 0, longMap.keyTable.length);
        System.arraycopy(longMap.valueTable, 0, this.valueTable, 0, longMap.valueTable.length);
        this.size = longMap.size;
        this.zeroValue = longMap.zeroValue;
        this.hasZeroValue = longMap.hasZeroValue;
    }

    protected int place(long l2) {
        long l3 = l2;
        return (int)((l3 ^ l3 >>> 32) * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(long l2) {
        long[] lArray = this.keyTable;
        int n2 = this.place(l2);
        long l3;
        while ((l3 = lArray[n2]) != 0L) {
            if (l3 == l2) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    @Null
    public V put(long l2, @Null V v2) {
        if (l2 == 0L) {
            V v3 = this.zeroValue;
            this.zeroValue = v2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v3;
        }
        int n2 = this.locateKey(l2);
        if (n2 >= 0) {
            V v4 = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return v4;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = l2;
        this.valueTable[n2] = v2;
        if (++this.size >= this.threshold) {
            LongMap longMap = this;
            longMap.resize(longMap.keyTable.length << 1);
        }
        return null;
    }

    public void putAll(LongMap<? extends V> VArray) {
        this.ensureCapacity(VArray.size);
        if (VArray.hasZeroValue) {
            this.put(0L, VArray.zeroValue);
        }
        long[] lArray = VArray.keyTable;
        VArray = VArray.valueTable;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            if (l2 == 0L) continue;
            this.put(l2, VArray[i2]);
        }
    }

    private void putResize(long l2, @Null V v2) {
        long[] lArray = this.keyTable;
        int n2 = this.place(l2);
        while (true) {
            if (lArray[n2] == 0L) {
                lArray[n2] = l2;
                this.valueTable[n2] = v2;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    @Null
    public V get(long l2) {
        if (l2 == 0L) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return null;
        }
        int n2 = this.locateKey(l2);
        if (n2 >= 0) {
            return this.valueTable[n2];
        }
        return null;
    }

    public V get(long l2, @Null V v2) {
        if (l2 == 0L) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return v2;
        }
        int n2 = this.locateKey(l2);
        if (n2 >= 0) {
            return this.valueTable[n2];
        }
        return v2;
    }

    @Null
    public V remove(long l2) {
        if (l2 == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V v2 = this.zeroValue;
            this.zeroValue = null;
            --this.size;
            return v2;
        }
        int n2 = this.locateKey(l2);
        if (n2 < 0) {
            return null;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        V v3 = this.valueTable[n2];
        int n3 = this.mask;
        int n4 = n2 + 1 & n3;
        while ((l2 = lArray[n4]) != 0L) {
            int n5 = this.place(l2);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                lArray[n2] = l2;
                VArray[n2] = VArray[n4];
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        lArray[n2] = 0L;
        VArray[n2] = null;
        --this.size;
        return v3;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0L);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(@Null Object object, boolean n2) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            long[] lArray = this.keyTable;
            for (int i2 = VArray.length - 1; i2 >= 0; --i2) {
                if (lArray[i2] == 0L || VArray[i2] != null) continue;
                return true;
            }
        } else if (n2 != 0) {
            if (object == this.zeroValue) {
                return true;
            }
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (VArray[n2] != object) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (!object.equals(VArray[n2])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long l2) {
        if (l2 == 0L) {
            return this.hasZeroValue;
        }
        return this.locateKey(l2) >= 0;
    }

    public long findKey(@Null Object object, boolean n2, long l2) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0L;
            }
            long[] lArray = this.keyTable;
            for (int i2 = VArray.length - 1; i2 >= 0; --i2) {
                if (lArray[i2] == 0L || VArray[i2] != null) continue;
                return lArray[i2];
            }
        } else if (n2 != 0) {
            if (object == this.zeroValue) {
                return 0L;
            }
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (VArray[n2] != object) continue;
                return this.keyTable[n2];
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0L;
            }
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (!object.equals(VArray[n2])) continue;
                return this.keyTable[n2];
            }
        }
        return l2;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    private void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new long[n2];
        this.valueTable = new Object[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                long l2 = lArray[n2];
                if (l2 == 0L) continue;
                this.putResize(l2, VArray[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        if (this.hasZeroValue && this.zeroValue != null) {
            n2 += this.zeroValue.hashCode();
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = lArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = lArray[i2];
            if (l2 == 0L) continue;
            n2 = (int)((long)n2 + l2 * 31L);
            V v2 = VArray[i2];
            if (v2 == null) continue;
            n2 += v2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        object = (LongMap)object;
        if (((LongMap)object).size != this.size) {
            return false;
        }
        if (((LongMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((LongMap)object).zeroValue == null ? this.zeroValue != null : !((LongMap)object).zeroValue.equals(this.zeroValue))) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            long l2 = lArray[i2];
            if (l2 == 0L || !((v2 = VArray[i2]) == null ? ((LongMap)object).get(l2, ObjectMap.dummy) != null : !v2.equals(((LongMap)object).get(l2)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(@Null Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        object = (LongMap)object;
        if (((LongMap)object).size != this.size) {
            return false;
        }
        if (((LongMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && this.zeroValue != ((LongMap)object).zeroValue) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            if (l2 == 0L || VArray[i2] == ((LongMap)object).get(l2, ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        long l2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = lArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n2-- > 0) {
                l2 = lArray[n2];
                if (l2 == 0L) continue;
                stringBuilder.append(l2);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n2]);
                break;
            }
        }
        while (n2-- > 0) {
            l2 = lArray[n2];
            if (l2 == 0L) continue;
            stringBuilder.append(", ");
            stringBuilder.append(l2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<LongMap$Entry<V>> iterator() {
        return this.entries();
    }

    public LongMap$Entries<V> entries() {
        if (Collections.allocateIterators) {
            return new LongMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new LongMap$Entries(this);
            this.entries2 = new LongMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public LongMap$Values<V> values() {
        if (Collections.allocateIterators) {
            return new LongMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new LongMap$Values(this);
            this.values2 = new LongMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public LongMap$Keys keys() {
        if (Collections.allocateIterators) {
            return new LongMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new LongMap$Keys(this);
            this.keys2 = new LongMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

