/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectIntMap$Entries;
import com.badlogic.gdx.utils.ObjectIntMap$Entry;
import com.badlogic.gdx.utils.ObjectIntMap$Keys;
import com.badlogic.gdx.utils.ObjectIntMap$Values;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;

public class ObjectIntMap<K>
implements Iterable<ObjectIntMap$Entry<K>> {
    public int size;
    K[] keyTable;
    int[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;
    transient ObjectIntMap$Entries entries1;
    transient ObjectIntMap$Entries entries2;
    transient ObjectIntMap$Values values1;
    transient ObjectIntMap$Values values2;
    transient ObjectIntMap$Keys keys1;
    transient ObjectIntMap$Keys keys2;

    public ObjectIntMap() {
        this(51, 0.8f);
    }

    public ObjectIntMap(int n2) {
        this(n2, 0.8f);
    }

    public ObjectIntMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + f2);
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2];
    }

    public ObjectIntMap(ObjectIntMap<? extends K> objectIntMap) {
        this((int)((float)objectIntMap.keyTable.length * objectIntMap.loadFactor), objectIntMap.loadFactor);
        System.arraycopy(objectIntMap.keyTable, 0, this.keyTable, 0, objectIntMap.keyTable.length);
        System.arraycopy(objectIntMap.valueTable, 0, this.valueTable, 0, objectIntMap.valueTable.length);
        this.size = objectIntMap.size;
    }

    protected int place(K k2) {
        return (int)((long)k2.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(K k2) {
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n2 = this.place(k2);
        K k3;
        while ((k3 = KArray[n2]) != null) {
            if (k3.equals(k2)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    public void put(K k2, int n2) {
        int n3 = this.locateKey(k2);
        if (n3 >= 0) {
            this.valueTable[n3] = n2;
            return;
        }
        n3 = -(n3 + 1);
        this.keyTable[n3] = k2;
        this.valueTable[n3] = n2;
        if (++this.size >= this.threshold) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.resize(objectIntMap.keyTable.length << 1);
        }
    }

    public int put(K k2, int n2, int n3) {
        int n4 = this.locateKey(k2);
        if (n4 >= 0) {
            int n5 = this.valueTable[n4];
            this.valueTable[n4] = n2;
            return n5;
        }
        n4 = -(n4 + 1);
        this.keyTable[n4] = k2;
        this.valueTable[n4] = n2;
        if (++this.size >= this.threshold) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.resize(objectIntMap.keyTable.length << 1);
        }
        return n3;
    }

    public void putAll(ObjectIntMap<? extends K> object) {
        this.ensureCapacity(((ObjectIntMap)object).size);
        K[] KArray = ((ObjectIntMap)object).keyTable;
        object = ((ObjectIntMap)object).valueTable;
        int n2 = KArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            this.put(k2, (int)object[i2]);
        }
    }

    private void putResize(K k2, int n2) {
        K[] KArray = this.keyTable;
        int n3 = this.place(k2);
        while (true) {
            if (KArray[n3] == null) {
                KArray[n3] = k2;
                this.valueTable[n3] = n2;
                return;
            }
            n3 = n3 + 1 & this.mask;
        }
    }

    public int get(K k2, int n2) {
        int n3 = this.locateKey(k2);
        if (n3 < 0) {
            return n2;
        }
        return this.valueTable[n3];
    }

    public int getAndIncrement(K k2, int n2, int n3) {
        int n4 = this.locateKey(k2);
        if (n4 >= 0) {
            int n5 = this.valueTable[n4];
            int n6 = n4;
            this.valueTable[n6] = this.valueTable[n6] + n3;
            return n5;
        }
        n4 = -(n4 + 1);
        this.keyTable[n4] = k2;
        this.valueTable[n4] = n2 + n3;
        if (++this.size >= this.threshold) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.resize(objectIntMap.keyTable.length << 1);
        }
        return n2;
    }

    public int remove(K k2, int n2) {
        int n3 = this.locateKey(k2);
        if (n3 < 0) {
            return n2;
        }
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n4 = this.valueTable[n3];
        int n5 = this.mask;
        int n6 = n3 + 1 & n5;
        while ((k2 = KArray[n6]) != null) {
            int n7 = this.place(k2);
            if ((n6 - n7 & n5) > (n3 - n7 & n5)) {
                KArray[n3] = k2;
                nArray[n3] = nArray[n6];
                n3 = n6;
            }
            n6 = n6 + 1 & n5;
        }
        KArray[n3] = null;
        --this.size;
        return n4;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsValue(int n2) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            if (KArray[i2] == null || nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K k2) {
        return this.locateKey(k2) >= 0;
    }

    @Null
    public K findKey(int n2) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            K k2 = KArray[i2];
            if (k2 == null || nArray[i2] != n2) continue;
            return k2;
        }
        return null;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    final void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                K k2 = KArray[n2];
                if (k2 == null) continue;
                this.putResize(k2, nArray[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n3 = KArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            n2 += k2.hashCode() + nArray[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectIntMap)) {
            return false;
        }
        object = (ObjectIntMap)object;
        if (((ObjectIntMap)object).size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = KArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            int n3 = ((ObjectIntMap)object).get(k2, 0);
            if (n3 == 0 && !((ObjectIntMap)object).containsKey(k2)) {
                return false;
            }
            if (n3 == nArray[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString(String string) {
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String string, boolean bl) {
        K k2;
        if (this.size == 0) {
            if (bl) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    @Override
    public ObjectIntMap$Entries<K> iterator() {
        return this.entries();
    }

    public ObjectIntMap$Entries<K> entries() {
        if (Collections.allocateIterators) {
            return new ObjectIntMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new ObjectIntMap$Entries(this);
            this.entries2 = new ObjectIntMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public ObjectIntMap$Values values() {
        if (Collections.allocateIterators) {
            return new ObjectIntMap$Values((ObjectIntMap<?>)this);
        }
        if (this.values1 == null) {
            this.values1 = new ObjectIntMap$Values((ObjectIntMap<?>)this);
            this.values2 = new ObjectIntMap$Values((ObjectIntMap<?>)this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public ObjectIntMap$Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new ObjectIntMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new ObjectIntMap$Keys(this);
            this.keys2 = new ObjectIntMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

