/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.ObjectMap;
import java.util.Iterator;

abstract class ObjectMap$MapIterator<K, V, I>
implements Iterable<I>,
Iterator<I> {
    public boolean hasNext;
    final ObjectMap<K, V> map;
    int nextIndex;
    int currentIndex;
    boolean valid = true;

    public ObjectMap$MapIterator(ObjectMap<K, V> objectMap) {
        this.map = objectMap;
        this.reset();
    }

    public void reset() {
        this.currentIndex = -1;
        this.nextIndex = -1;
        this.findNextIndex();
    }

    void findNextIndex() {
        K[] KArray = this.map.keyTable;
        int n2 = this.map.keyTable.length;
        while (++this.nextIndex < n2) {
            if (KArray[this.nextIndex] == null) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }

    @Override
    public void remove() {
        Object k2;
        int n2 = this.currentIndex;
        if (n2 < 0) {
            throw new IllegalStateException("next must be called before remove.");
        }
        K[] KArray = this.map.keyTable;
        V[] VArray = this.map.valueTable;
        int n3 = this.map.mask;
        int n4 = n2 + 1 & n3;
        while ((k2 = KArray[n4]) != null) {
            int n5 = this.map.place(k2);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                KArray[n2] = k2;
                VArray[n2] = VArray[n4];
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        KArray[n2] = null;
        VArray[n2] = null;
        --this.map.size;
        if (n2 != this.currentIndex) {
            --this.nextIndex;
        }
        this.currentIndex = -1;
    }
}

