/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap$Entries;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import com.badlogic.gdx.utils.ObjectMap$Keys;
import com.badlogic.gdx.utils.ObjectMap$Values;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;

public class ObjectMap<K, V>
implements Iterable<ObjectMap$Entry<K, V>> {
    static final Object dummy = new Object();
    public int size;
    K[] keyTable;
    V[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;
    transient ObjectMap$Entries entries1;
    transient ObjectMap$Entries entries2;
    transient ObjectMap$Values values1;
    transient ObjectMap$Values values2;
    transient ObjectMap$Keys keys1;
    transient ObjectMap$Keys keys2;

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int n2) {
        this(n2, 0.8f);
    }

    public ObjectMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + f2);
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
        this.valueTable = new Object[n2];
    }

    public ObjectMap(ObjectMap<? extends K, ? extends V> objectMap) {
        this((int)((float)objectMap.keyTable.length * objectMap.loadFactor), objectMap.loadFactor);
        System.arraycopy(objectMap.keyTable, 0, this.keyTable, 0, objectMap.keyTable.length);
        System.arraycopy(objectMap.valueTable, 0, this.valueTable, 0, objectMap.valueTable.length);
        this.size = objectMap.size;
    }

    protected int place(K k2) {
        return (int)((long)k2.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(K k2) {
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n2 = this.place(k2);
        K k3;
        while ((k3 = KArray[n2]) != null) {
            if (k3.equals(k2)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    @Null
    public V put(K object, @Null V v2) {
        int n2 = this.locateKey(object);
        if (n2 >= 0) {
            object = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return (V)object;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = object;
        this.valueTable[n2] = v2;
        if (++this.size >= this.threshold) {
            ObjectMap objectMap = this;
            objectMap.resize(objectMap.keyTable.length << 1);
        }
        return null;
    }

    public void putAll(ObjectMap<? extends K, ? extends V> VArray) {
        this.ensureCapacity(VArray.size);
        K[] KArray = VArray.keyTable;
        VArray = VArray.valueTable;
        int n2 = KArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            this.put(k2, VArray[i2]);
        }
    }

    private void putResize(K k2, @Null V v2) {
        K[] KArray = this.keyTable;
        int n2 = this.place(k2);
        while (true) {
            if (KArray[n2] == null) {
                KArray[n2] = k2;
                this.valueTable[n2] = v2;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    @Null
    public <T extends K> V get(T t2) {
        int n2 = this.locateKey(t2);
        if (n2 < 0) {
            return null;
        }
        return this.valueTable[n2];
    }

    public V get(K k2, @Null V v2) {
        int n2 = this.locateKey(k2);
        if (n2 < 0) {
            return v2;
        }
        return this.valueTable[n2];
    }

    @Null
    public V remove(K k2) {
        int n2 = this.locateKey(k2);
        if (n2 < 0) {
            return null;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        V v2 = this.valueTable[n2];
        int n3 = this.mask;
        int n4 = n2 + 1 & n3;
        while ((k2 = KArray[n4]) != null) {
            int n5 = this.place(k2);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                KArray[n2] = k2;
                VArray[n2] = VArray[n4];
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        KArray[n2] = null;
        VArray[n2] = null;
        --this.size;
        return v2;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, null);
    }

    public boolean containsValue(@Null Object object, boolean n2) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            for (int i2 = VArray.length - 1; i2 >= 0; --i2) {
                if (KArray[i2] == null || VArray[i2] != null) continue;
                return true;
            }
        } else if (n2 != 0) {
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (VArray[n2] != object) continue;
                return true;
            }
        } else {
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (!object.equals(VArray[n2])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(K k2) {
        return this.locateKey(k2) >= 0;
    }

    @Null
    public K findKey(@Null Object object, boolean n2) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            for (int i2 = VArray.length - 1; i2 >= 0; --i2) {
                if (KArray[i2] == null || VArray[i2] != null) continue;
                return KArray[i2];
            }
        } else if (n2 != 0) {
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (VArray[n2] != object) continue;
                return this.keyTable[n2];
            }
        } else {
            for (n2 = VArray.length - 1; n2 >= 0; --n2) {
                if (!object.equals(VArray[n2])) continue;
                return this.keyTable[n2];
            }
        }
        return null;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    final void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new Object[n2];
        this.valueTable = new Object[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                K k2 = KArray[n2];
                if (k2 == null) continue;
                this.putResize(k2, VArray[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = KArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = KArray[i2];
            if (object == null) continue;
            n2 += object.hashCode();
            object = VArray[i2];
            if (object == null) continue;
            n2 += object.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        object = (ObjectMap)object;
        if (((ObjectMap)object).size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            K k2 = KArray[i2];
            if (k2 == null || !((v2 = VArray[i2]) == null ? ((ObjectMap)object).get(k2, dummy) != null : !v2.equals(((ObjectMap)object).get(k2)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(@Null Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        object = (ObjectMap)object;
        if (((ObjectMap)object).size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null || VArray[i2] == ((ObjectMap)object).get(k2, dummy)) continue;
            return false;
        }
        return true;
    }

    public String toString(String string) {
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String string, boolean bl) {
        Object object;
        if (this.size == 0) {
            if (bl) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            object = KArray[n2];
            if (object == null) continue;
            stringBuilder.append((Object)(object == this ? "(this)" : object));
            stringBuilder.append('=');
            object = VArray[n2];
            stringBuilder.append((Object)(object == this ? "(this)" : object));
            break;
        }
        while (n2-- > 0) {
            object = KArray[n2];
            if (object == null) continue;
            stringBuilder.append(string);
            stringBuilder.append((Object)(object == this ? "(this)" : object));
            stringBuilder.append('=');
            object = VArray[n2];
            stringBuilder.append((Object)(object == this ? "(this)" : object));
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public ObjectMap$Entries<K, V> iterator() {
        return this.entries();
    }

    public ObjectMap$Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new ObjectMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new ObjectMap$Entries(this);
            this.entries2 = new ObjectMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public ObjectMap$Values<V> values() {
        if (Collections.allocateIterators) {
            return new ObjectMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new ObjectMap$Values(this);
            this.values2 = new ObjectMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public ObjectMap$Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new ObjectMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new ObjectMap$Keys(this);
            this.keys2 = new ObjectMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

