/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectSet$ObjectSetIterator<K>
implements Iterable<K>,
Iterator<K> {
    public boolean hasNext;
    final ObjectSet<K> set;
    int nextIndex;
    int currentIndex;
    boolean valid = true;

    public ObjectSet$ObjectSetIterator(ObjectSet<K> objectSet) {
        this.set = objectSet;
        this.reset();
    }

    public void reset() {
        this.currentIndex = -1;
        this.nextIndex = -1;
        this.findNextIndex();
    }

    private void findNextIndex() {
        T[] TArray = this.set.keyTable;
        int n2 = this.set.keyTable.length;
        while (++this.nextIndex < n2) {
            if (TArray[this.nextIndex] == null) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }

    @Override
    public void remove() {
        Object t2;
        int n2 = this.currentIndex;
        if (n2 < 0) {
            throw new IllegalStateException("next must be called before remove.");
        }
        T[] TArray = this.set.keyTable;
        int n3 = this.set.mask;
        int n4 = n2 + 1 & n3;
        while ((t2 = TArray[n4]) != null) {
            int n5 = this.set.place(t2);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                TArray[n2] = t2;
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        TArray[n2] = null;
        --this.set.size;
        if (n2 != this.currentIndex) {
            --this.nextIndex;
        }
        this.currentIndex = -1;
    }

    @Override
    public boolean hasNext() {
        if (!this.valid) {
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }
        return this.hasNext;
    }

    @Override
    public K next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        if (!this.valid) {
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }
        Object t2 = this.set.keyTable[this.nextIndex];
        this.currentIndex = this.nextIndex;
        this.findNextIndex();
        return (K)t2;
    }

    @Override
    public ObjectSet$ObjectSetIterator<K> iterator() {
        return this;
    }

    public Array<K> toArray(Array<K> array) {
        while (this.hasNext) {
            array.add(this.next());
        }
        return array;
    }

    public Array<K> toArray() {
        return this.toArray(new Array(true, this.set.size));
    }
}

