/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entries;
import com.badlogic.gdx.utils.ObjectMap$Keys;
import com.badlogic.gdx.utils.ObjectMap$Values;
import com.badlogic.gdx.utils.OrderedMap$OrderedMapEntries;
import com.badlogic.gdx.utils.OrderedMap$OrderedMapKeys;
import com.badlogic.gdx.utils.OrderedMap$OrderedMapValues;

public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final Array<K> keys;

    public OrderedMap() {
        this.keys = new Array();
    }

    public OrderedMap(int n2) {
        super(n2);
        this.keys = new Array(n2);
    }

    public OrderedMap(int n2, float f2) {
        super(n2, f2);
        this.keys = new Array(n2);
    }

    public OrderedMap(OrderedMap<? extends K, ? extends V> orderedMap) {
        super(orderedMap);
        this.keys = new Array<K>(orderedMap.keys);
    }

    @Override
    public V put(K object, V v2) {
        int n2 = this.locateKey(object);
        if (n2 >= 0) {
            object = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return (V)object;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = object;
        this.valueTable[n2] = v2;
        this.keys.add(object);
        if (++this.size >= this.threshold) {
            OrderedMap orderedMap = this;
            orderedMap.resize(orderedMap.keyTable.length << 1);
        }
        return null;
    }

    @Override
    public <T extends K> void putAll(OrderedMap<T, ? extends V> orderedMap) {
        this.ensureCapacity(orderedMap.size);
        T[] TArray = orderedMap.keys.items;
        int n2 = orderedMap.keys.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object t2 = TArray[i2];
            ((ObjectMap)this).put(t2, orderedMap.get(t2));
        }
    }

    @Override
    public V remove(K k2) {
        this.keys.removeValue(k2, false);
        return super.remove(k2);
    }

    public V removeIndex(int n2) {
        OrderedMap orderedMap = this;
        return super.remove(orderedMap.keys.removeIndex(n2));
    }

    public boolean alter(K k2, K k3) {
        if (this.containsKey(k3)) {
            return false;
        }
        int n2 = this.keys.indexOf(k2, false);
        if (n2 == -1) {
            return false;
        }
        super.put(k3, super.remove(k2));
        this.keys.set(n2, k3);
        return true;
    }

    public boolean alterIndex(int n2, K k2) {
        if (n2 < 0 || n2 >= this.size || this.containsKey(k2)) {
            return false;
        }
        OrderedMap orderedMap = this;
        super.put(k2, super.remove(orderedMap.keys.get(n2)));
        this.keys.set(n2, k2);
        return true;
    }

    @Override
    public void clear(int n2) {
        this.keys.clear();
        super.clear(n2);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    public Array<K> orderedKeys() {
        return this.keys;
    }

    @Override
    public ObjectMap$Entries<K, V> iterator() {
        return ((ObjectMap)this).entries();
    }

    @Override
    public ObjectMap$Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new OrderedMap$OrderedMapEntries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new OrderedMap$OrderedMapEntries(this);
            this.entries2 = new OrderedMap$OrderedMapEntries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    @Override
    public ObjectMap$Values<V> values() {
        if (Collections.allocateIterators) {
            return new OrderedMap$OrderedMapValues(this);
        }
        if (this.values1 == null) {
            this.values1 = new OrderedMap$OrderedMapValues(this);
            this.values2 = new OrderedMap$OrderedMapValues(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    @Override
    public ObjectMap$Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new OrderedMap$OrderedMapKeys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new OrderedMap$OrderedMapKeys(this);
            this.keys2 = new OrderedMap$OrderedMapKeys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    @Override
    protected String toString(String string, boolean bl) {
        if (this.size == 0) {
            if (bl) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        Array<K> array = this.keys;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = array.get(i2);
            if (i2 > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append((Object)(object == this ? "(this)" : object));
            stringBuilder.append('=');
            object = this.get(object);
            stringBuilder.append((Object)(object == this ? "(this)" : object));
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }
}

