/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.ObjectSet$ObjectSetIterator;
import com.badlogic.gdx.utils.OrderedSet$OrderedSetIterator;

public class OrderedSet<T>
extends ObjectSet<T> {
    final Array<T> items;
    transient OrderedSet$OrderedSetIterator iterator1;
    transient OrderedSet$OrderedSetIterator iterator2;

    public OrderedSet() {
        this.items = new Array();
    }

    public OrderedSet(int n2, float f2) {
        super(n2, f2);
        this.items = new Array(n2);
    }

    public OrderedSet(int n2) {
        super(n2);
        this.items = new Array(n2);
    }

    public OrderedSet(OrderedSet<? extends T> orderedSet) {
        super(orderedSet);
        this.items = new Array<T>(orderedSet.items);
    }

    @Override
    public boolean add(T t2) {
        if (!super.add(t2)) {
            return false;
        }
        this.items.add(t2);
        return true;
    }

    public boolean add(T t2, int n2) {
        if (!super.add(t2)) {
            int n3 = this.items.indexOf(t2, true);
            if (n3 != n2) {
                Array<T> array = this.items;
                array.insert(n2, array.removeIndex(n3));
            }
            return false;
        }
        this.items.insert(n2, t2);
        return true;
    }

    @Override
    public void addAll(OrderedSet<T> orderedSet) {
        this.ensureCapacity(orderedSet.size);
        T[] TArray = orderedSet.items.items;
        int n2 = orderedSet.items.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((ObjectSet)this).add(TArray[i2]);
        }
    }

    @Override
    public boolean remove(T t2) {
        if (!super.remove(t2)) {
            return false;
        }
        this.items.removeValue(t2, false);
        return true;
    }

    public T removeIndex(int n2) {
        T t2 = this.items.removeIndex(n2);
        super.remove(t2);
        return t2;
    }

    public boolean alter(T t2, T t3) {
        if (this.contains(t3)) {
            return false;
        }
        if (!super.remove(t2)) {
            return false;
        }
        super.add(t3);
        this.items.set(this.items.indexOf(t2, false), t3);
        return true;
    }

    public boolean alterIndex(int n2, T t2) {
        if (n2 < 0 || n2 >= this.size || this.contains(t2)) {
            return false;
        }
        OrderedSet orderedSet = this;
        super.remove(orderedSet.items.get(n2));
        super.add(t2);
        this.items.set(n2, t2);
        return true;
    }

    @Override
    public void clear(int n2) {
        this.items.clear();
        super.clear(n2);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    public Array<T> orderedItems() {
        return this.items;
    }

    @Override
    public OrderedSet$OrderedSetIterator<T> iterator() {
        if (Collections.allocateIterators) {
            return new OrderedSet$OrderedSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new OrderedSet$OrderedSetIterator(this);
            this.iterator2 = new OrderedSet$OrderedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            ((ObjectSet$ObjectSetIterator)this.iterator1).reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        ((ObjectSet$ObjectSetIterator)this.iterator2).reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        T[] TArray = this.items.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(TArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String toString(String string) {
        return this.items.toString(string);
    }

    public static <T> OrderedSet<T> with(T ... TArray) {
        OrderedSet<T> orderedSet = new OrderedSet<T>();
        orderedSet.addAll(TArray);
        return orderedSet;
    }
}

