/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class PauseableThread
extends Thread {
    final Runnable runnable;
    boolean paused = false;
    boolean exit = false;

    public PauseableThread(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        while (true) {
            PauseableThread pauseableThread = this;
            synchronized (pauseableThread) {
                try {
                    while (this.paused) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            if (this.exit) {
                return;
            }
            this.runnable.run();
        }
    }

    public void onPause() {
        this.paused = true;
    }

    public void onResume() {
        PauseableThread pauseableThread = this;
        synchronized (pauseableThread) {
            this.paused = false;
            this.notifyAll();
            return;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void stopThread() {
        this.exit = true;
        if (this.paused) {
            this.onResume();
        }
    }
}

