/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.PooledLinkedList$1;
import com.badlogic.gdx.utils.PooledLinkedList$Item;

public class PooledLinkedList<T> {
    private PooledLinkedList$Item<T> head;
    private PooledLinkedList$Item<T> tail;
    private PooledLinkedList$Item<T> iter;
    private PooledLinkedList$Item<T> curr;
    private int size = 0;
    private final Pool<PooledLinkedList$Item<T>> pool;

    public PooledLinkedList(int n2) {
        this.pool = new PooledLinkedList$1(this, 16, n2);
    }

    public void add(T t2) {
        PooledLinkedList$Item<T> pooledLinkedList$Item = this.pool.obtain();
        this.pool.obtain().payload = t2;
        pooledLinkedList$Item.next = null;
        pooledLinkedList$Item.prev = null;
        if (this.head == null) {
            this.head = pooledLinkedList$Item;
            this.tail = pooledLinkedList$Item;
            ++this.size;
            return;
        }
        pooledLinkedList$Item.prev = this.tail;
        this.tail.next = pooledLinkedList$Item;
        this.tail = pooledLinkedList$Item;
        ++this.size;
    }

    public void addFirst(T t2) {
        PooledLinkedList$Item<T> pooledLinkedList$Item = this.pool.obtain();
        this.pool.obtain().payload = t2;
        pooledLinkedList$Item.next = this.head;
        pooledLinkedList$Item.prev = null;
        if (this.head != null) {
            this.head.prev = pooledLinkedList$Item;
        } else {
            this.tail = pooledLinkedList$Item;
        }
        this.head = pooledLinkedList$Item;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public void iter() {
        this.iter = this.head;
    }

    public void iterReverse() {
        this.iter = this.tail;
    }

    @Null
    public T next() {
        if (this.iter == null) {
            return null;
        }
        Object t2 = this.iter.payload;
        this.curr = this.iter;
        this.iter = this.iter.next;
        return t2;
    }

    @Null
    public T previous() {
        if (this.iter == null) {
            return null;
        }
        Object t2 = this.iter.payload;
        this.curr = this.iter;
        this.iter = this.iter.prev;
        return t2;
    }

    public void remove() {
        if (this.curr == null) {
            return;
        }
        --this.size;
        PooledLinkedList$Item<T> pooledLinkedList$Item = this.curr;
        PooledLinkedList$Item pooledLinkedList$Item2 = this.curr.next;
        PooledLinkedList$Item pooledLinkedList$Item3 = this.curr.prev;
        this.pool.free(this.curr);
        this.curr = null;
        if (this.size == 0) {
            this.head = null;
            this.tail = null;
            return;
        }
        if (pooledLinkedList$Item == this.head) {
            pooledLinkedList$Item2.prev = null;
            this.head = pooledLinkedList$Item2;
            return;
        }
        if (pooledLinkedList$Item == this.tail) {
            pooledLinkedList$Item3.next = null;
            this.tail = pooledLinkedList$Item3;
            return;
        }
        pooledLinkedList$Item3.next = pooledLinkedList$Item2;
        pooledLinkedList$Item2.prev = pooledLinkedList$Item3;
    }

    @Null
    public T removeLast() {
        if (this.tail == null) {
            return null;
        }
        Object t2 = this.tail.payload;
        --this.size;
        PooledLinkedList$Item pooledLinkedList$Item = this.tail.prev;
        this.pool.free(this.tail);
        if (this.size == 0) {
            this.head = null;
            this.tail = null;
        } else {
            this.tail = pooledLinkedList$Item;
            this.tail.next = null;
        }
        return t2;
    }

    public void clear() {
        this.iter();
        while (this.next() != null) {
            this.remove();
        }
    }
}

